-- SMK34
-- 
--
-- author: fruktor
-- www.eifok-team.de
-- 

SMK34 = {};


function SMK34.prerequisitesPresent(specializations)
    return true;
end;

function SMK34:load(xmlFile)	
	
	self.setPlane = SpecializationUtil.callSpecializationsFunction("setPlane");
	
	self.plane = {};
	self.plane.open = {};
	self.plane.close = {};
	local i = 0;
	while true do
		local str = getXMLString(xmlFile, string.format("vehicle.smk34.planeopen(%d)#idx", i));
		if str ~= nil then
			local node = Utils.indexToObject(self.components, str);
			table.insert(self.plane.open, node);
		else
			break;
		end
		i = i +1;
	end
	i = 0;
	while true do
		local str = getXMLString(xmlFile, string.format("vehicle.smk34.planeclose(%d)#idx", i));
		if str ~= nil then
			local node = Utils.indexToObject(self.components, str);
			table.insert(self.plane.close, node);
		else
			break;
		end
		i = i +1;
	end
	
	self.plane.anim	= {};
	self.plane.anim.idx = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.smk34.animation#idx"));
	self.plane.anim.charset = getAnimCharacterSet(self.plane.anim.idx);
	self.plane.anim.clipIdx = getAnimClipIndex(self.plane.anim.charset, getXMLString(xmlFile, "vehicle.smk34.animation#clip"));	
	
	assignAnimTrackClip(self.plane.anim.charset, 0, self.plane.anim.clipIdx);
	setAnimTrackLoopState(self.plane.anim.charset, 0, false);
	self.plane.anim.duration = getAnimClipDuration(self.plane.anim.charset, self.plane.anim.clipIdx);		
	
	self.plane.animdummy = {};
	self.plane.animdummy.idx = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.smk34.animationdummy#idx"));
	local  xr, yr, zr = getRotation(self.plane.animdummy.idx);
	self.plane.animdummy.cRot = xr;
	self.plane.animdummy.lRot = xr;
	self.plane.animdummy.min = Utils.degToRad( getXMLFloat(xmlFile, "vehicle.smk34.animationdummy#min") );
	self.plane.animdummy.max = Utils.degToRad( getXMLFloat(xmlFile, "vehicle.smk34.animationdummy#max") );

	self.plane.jnt = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.smk34.plane.joint#idx"));
	self.plane.msh = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.smk34.plane.mesh#idx"));
	self.plane.ref = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.smk34.plane.ref#idx"));
	
	link( getRootNode(), self.plane.msh );
	setTranslation( self.plane.msh, 0, 0, 0 );
	setRotation( self.plane.msh, 0, 0, 0 );	
	
	self.allowFillFromAir = false;
	self.plane.bOpen = false;
	for i,j in pairs(self.plane.open) do
		setVisibility(j, false);
	end
	for i,j in pairs(self.plane.close) do
		setVisibility(j, true);
	end
	

end;

function SMK34:delete()
	if self.plane.msh ~= nil then
		delete(self.plane.msh);
	end;
end;

function SMK34:readStream(streamId, connection)
	local state = streamReadBool(streamId);
	self:setPlane(state, true);
end;

function SMK34:writeStream(streamId, connection)	
	streamWriteBool(streamId, self.plane.bOpen);
end;

function SMK34:mouseEvent(posX, posY, isDown, isUp, button)
end;

function SMK34:keyEvent(unicode, sym, modifier, isDown)

end;

function SMK34:update(dt)

	if Vehicle.debugRendering then

	end;	
	
	
	--###
	if self:getIsActive() then
		if self:getIsActiveForInput() then
			if self.tipState == Trailer.TIPSTATE_CLOSED then
				if InputBinding.hasEvent(InputBinding.SMK34_PLANE) then
					self:setPlane(not self.plane.bOpen);
				end
			end
		end
	end
	
	--###
	local  xr, yr, zr = getRotation(self.plane.animdummy.idx);
	self.plane.animdummy.cRot = xr;
	
	if self.plane.animdummy.cRot ~= self.plane.animdummy.lRot then
		self.plane.animdummy.lRot = self.plane.animdummy.cRot;
		
		local prct = ( self.plane.animdummy.cRot - self.plane.animdummy.min ) / ( self.plane.animdummy.max - self.plane.animdummy.min );
		enableAnimTrack(self.plane.anim.charset, 0);
		setAnimTrackTime(self.plane.anim.charset, 0, prct*self.plane.anim.duration, true);
		disableAnimTrack(self.plane.anim.charset, 0);		
		
		Cylindered.updateMovingPart(self, self.movingParts[1]);
		Cylindered.updateMovingPart(self, self.movingParts[2]);
	end	
	
end;


function SMK34:updateTick(dt)



end;

function SMK34:draw()
	if self.tipState == Trailer.TIPSTATE_CLOSED then
		g_currentMission:addHelpButtonText( g_i18n:getText("SMK34_PLANE"), InputBinding.SMK34_PLANE );	
	end;
end;

function SMK34:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)	
	local state = getXMLBool(xmlFile, key.."#PlaneOpen");
	self:setPlane(state, true);
    return BaseMission.VEHICLE_LOAD_OK;	
end;

function SMK34:getSaveAttributesAndNodes(nodeIdent)
    local attributes = 'PlaneOpen="'.. tostring(self.plane.bOpen) .. '"';
    return attributes, nil;
end;

function SMK34:onAttach(attacherVehicle)

end;

function SMK34:onDetach()

end;


function SMK34:setPlane(state, noEventSend)
	
	SetPlaneEvent.sendEvent(self, state, noEventSend);
	
	self.plane.bOpen = state;

	for i,j in pairs(self.plane.open) do
		setVisibility(j, state);
	end
	for i,j in pairs(self.plane.close) do
		setVisibility(j, not state);
	end	
	
	self.allowFillFromAir = state;

	
end;

