--
-- slaveI3Danim  v0.9 
-- Specialization to slave I3D animations to 1D-movement of other parts of the model

-- by upsidedown, inspired by controlI3DAnim (Sven777b)
-- 
-- frei verwendbar - keine erlaubnis ntig  |  free for use - no permission needed.
-- Modifikationen erst nach Rcksprache!    |  modifications only with my permission.

slaveI3Danim = {};

slaveI3Danim.axisTable = {x=1, y=2, z=3, rx=4, ry=5, rz=6 };

function slaveI3Danim.prerequisitesPresent(specializations)
    return true;
end;

function slaveI3Danim:load(xmlFile)
	--self.setI3DAnimState = SpecializationUtil.callSpecializationsFunction("setI3DAnimState");
	local i=0;
	self.slaveI3Danims = {};
	
	
	
	while true do
		local basename = string.format("vehicle.SlaveI3dAnims.anim(%d)#",i);
		local anim = {};
		local mIndex = getXMLString(xmlFile,basename.."masterNode");
		anim.master = Utils.indexToObject(self.components, mIndex);
		
		anim.masterAxis = getXMLString(xmlFile,basename.."masterAxis");
		anim.masterMinValue = getXMLFloat(xmlFile,basename.."masterMinValue");
		anim.masterMaxValue = getXMLFloat(xmlFile,basename.."masterMaxValue");
		
		
		
		local rnindex = getXMLString(xmlFile,basename.."rootnode");
		
		if rnindex == nil then break; end;
		
		local axisIndex = slaveI3Danim.axisTable[anim.masterAxis];
		if axisIndex > 3 then
			anim.masterMinValue = math.rad(anim.masterMinValue);
			anim.masterMaxValue = math.rad(anim.masterMaxValue);			
		end;
		
		anim.rootNode = Utils.indexToObject(self.components, rnindex);
		
		if anim.rootNode ~= nil and anim.rootNode ~= 0 then
			
			anim.charSet = getAnimCharacterSet(anim.rootNode);
			if anim.charSet ~= 0 then
				
				local clipname = getXMLString(xmlFile,basename.."clipname");
				local clip = getAnimClipIndex(anim.charSet, clipname);
				if clip ~= nil then
				
					assignAnimTrackClip(anim.charSet, 0, clip);
					--anim.loop = false;
					setAnimTrackLoopState(anim.charSet, 0,false);
					
					anim.duration = getAnimClipDuration(anim.charSet, clip);
					anim.lastSlaveAlpha = -1;
					
					table.insert(self.slaveI3Danims,anim);
				else
					print("Error: slaveI3Danims - ("..clipname..") clip not found");
				end;
			else
				print("Error: slaveI3Danims - ("..clipname..") charSet not found");
			end;
		else
			print("Error: slaveI3Danims - ("..clipname..") rootNode not found");
		end;
		
		i=i+1;
	end;
	
end;

function slaveI3Danim:postLoad(xmlFile)
	self.forceIsActive = true; 
	slaveI3Danim.updateTick(self,0);
	self.forceIsActive = false; 
end;

function slaveI3Danim:readStream(streamId, timestamp, connection)
	
end;

function slaveI3Danim:writeStream(streamId, connection, dirtyMask)
	
end;

function slaveI3Danim:update(dt)
		
end;

function slaveI3Danim:updateTick(dt)
	if self:getIsActive() then
		
		for k,anim in pairs(self.slaveI3Danims) do
			
			local axisIndex = slaveI3Danim.axisTable[anim.masterAxis];
			local coord

			if axisIndex > 3 then
				coord = {getRotation(anim.master)};
				axisIndex = axisIndex-3;
			else
				coord = {getTranslation(anim.master)};
			end;
						
			local value = coord[axisIndex];

			local alpha = (value - anim.masterMinValue)/(anim.masterMaxValue-anim.masterMinValue);
			
			alpha = Utils.clamp(alpha,0,1);
			
			if alpha ~= anim.lastSlaveAlpha then				
				enableAnimTrack(anim.charSet, 0);
				setAnimTrackTime(anim.charSet, 0,alpha*anim.duration);
			
				anim.lastSlaveAlpha = alpha;
			else
				disableAnimTrack(anim.charSet,0);
			end;
		
		end;
	else
		for k,anim in pairs(self.slaveI3Danims) do
			disableAnimTrack(anim.charSet,0);
		end;
	end;
end;

function slaveI3Danim:draw()
	
end;

function slaveI3Danim:mouseEvent(posX, posY, isDown, isUp, button)
end;

function slaveI3Danim:keyEvent(unicode, sym, modifier, isDown)
end;

function slaveI3Danim:delete()
end;