--
-- MarshfieldEstate
--
-- @author  Stefan Geiger
-- @date  06/08/12
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

MarshfieldEstate = {}

local MarshfieldEsate_mt = Class(MarshfieldEstate, Mission00);


function MarshfieldEstate:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = MarshfieldEsate_mt;
    end;
    local self = MarshfieldEstate:superClass():new(baseDirectory, mt);

--    self.playerStartX = 39;
--    self.playerStartY = 0.1;
--    self.playerStartZ = -330;
--    self.playerRotX = 0;
--    self.playerRotY = Utils.degToRad(90);

    return self;
end;

function MarshfieldEstate:delete()
    MarshfieldEstate:superClass().delete(self);
end;

function MarshfieldEstate:load()
    self:startLoadingTask();

    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);

    self.helpIconsBase = nil;
    self.collectableHorseshoesObject = nil;
    self.fieldDefinitionBase = nil;
    self.vehicleShopBase = nil;

    self:loadMap(Utils.getFilename("map/map.i3d", self.baseDirectory), true, self.loadMap01Finished, self);
end;

function MarshfieldEstate:loadMap01Finished(node, arguments)

       self.terrainDetailAngleNumChannels = 8; -- durch die gewünschte Anzahl Channels ersetzen
	   self.terrainDetailAngleMaxValue = bitShiftLeft(1, self.terrainDetailAngleNumChannels) - 1;
    self:loadMapXMLFile(Utils.getFilename("MarshfieldEstate.xml", self.baseDirectory));

    self.missionPDA:loadMap(Utils.getFilename("pda_map.png", self.baseDirectory), 2048, 2048);

    g_inGameMenu:setMapViewsMap(Utils.getFilename("pda_map.png", self.baseDirectory));

    local iconSize = self.missionPDA.pdaMapWidth / 15;

    -- ATMs

    -- Vehicle Shop

    -- Phone Booths

    -- farm silos
    -- bga
    
    -- Grass Heaps

    -- livestock

    MarshfieldEstate:superClass().load(self);

    if not self.missionDynamicInfo.isMultiplayer then
        self:updateFoundHorseshoes();
        self:updateFoundHelpIcons();
        self:updateMeteoriteCrash();
        self:updateRainbow();
    else
        self:removeAllHorseshoes();
        self:removeAllHelpIcons();
    end;

    if g_isGamescomVersion then
        self:playerOwnsAllFields();
    end;

    self:finishLoadingTask();
end;

function MarshfieldEstate:onStartMission()
    MarshfieldEstate:superClass().onStartMission(self);
end;

function MarshfieldEstate:mouseEvent(posX, posY, isDown, isUp, button)
    MarshfieldEstate:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function MarshfieldEstate:keyEvent(unicode, sym, modifier, isDown)
    MarshfieldEstate:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function MarshfieldEstate:update(dt)
    MarshfieldEstate:superClass().update(self, dt);
end;

function MarshfieldEstate:draw()
    MarshfieldEstate:superClass().draw(self);
end;