mrFullPowershiftSetGearEvent = {};
mrFullPowershiftSetGearEvent_mt = Class(mrFullPowershiftSetGearEvent, Event);

InitEventClass(mrFullPowershiftSetGearEvent, "mrFullPowershiftSetGearEvent");

 
function mrFullPowershiftSetGearEvent:emptyNew()
	local self = Event:new(mrFullPowershiftSetGearEvent_mt);
	self.className="mrFullPowershiftSetGearEvent";
	return self;
end;

function mrFullPowershiftSetGearEvent:new(object, gearNum)
	local self = mrFullPowershiftSetGearEvent:emptyNew();
	self.gearNum = gearNum;
	self.object = object;
	return self;
end;

function mrFullPowershiftSetGearEvent:readStream(streamId, connection)
	--both clients and server can receive this event
	local id = streamReadInt32(streamId);
	self.gearNum = streamReadInt32(streamId);
	self.object = networkGetObject(id);
	self:run(connection);
end;

function mrFullPowershiftSetGearEvent:writeStream(streamId, connection)
	--both clients and server can send this event
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteInt32(streamId, self.gearNum);
end;

function mrFullPowershiftSetGearEvent:run(connection)
	----both clients and server can "run" this event (after reading it)	
	
	if not connection:getIsServer() then
		--we are the server, and so, we need to broadcast the new gearnum to all the other clients
		self.object:setGear(self.gearNum, false);	
	else
		--we are the client, and so we just receive the new gearnum
		self.object:setGear(self.gearNum, true);	
	end;
end;