--[[************************************************************************************************************************************************************
	
	RealisticBallastSave v1.0
	
	10/2013 by Saty / http://forum.lsczech.cz
	
****************************************************************************************************************************************************************
	
	(EN) INFO
	
	Free for use on mods. Modifications only with my permission !
	
****************************************************************************************************************************************************************
	
	(CZ) INFO
	
	Pro volne pouziti v modech. ZAKAZ modifikaci bez meho souhlasu !
	
************************************************************************************************************************************************************]]--

RealisticBallastSave = {};

function RealisticBallastSave.prerequisitesPresent(specializations)
	return true;
end;

function RealisticBallastSave:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		local realBallastMode = Utils.getNoNil(getXMLFloat(xmlFile, key.."#realBallast"), 0);
		if self.realBallastMode ~= nil then
			if self.realBallastMode.currentMode ~= realBallastMode then
				self:realBallastChangeMode(realBallastMode);
			end;
		end;
	end; 
	return BaseMission.VEHICLE_LOAD_OK;
end;

function RealisticBallastSave:getSaveAttributesAndNodes(nodeIdent)
	local attributes = nil;
	if self.realBallastMode ~= nil then
		attributes = 'realBallast="'.. tostring(self.realBallastMode.currentMode) .. '"';
	end
	return attributes, nil;
end;

function RealisticBallastSave:load(xmlFile)
end;

function RealisticBallastSave:delete()
end;

function RealisticBallastSave:mouseEvent(posX, posY, isDown, isUp, button)
end;

function RealisticBallastSave:keyEvent(unicode, sym, modifier, isDown)
end;

function RealisticBallastSave:update(dt)
end;

function RealisticBallastSave:draw()
end;