pun = {};
function pun.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Fillable, specializations) and SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function pun:load(xmlFile)
	
    self.fillScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fillScale#value"), 1);
    self.wasToFast = false;
    
	self.currentFruitType = FruitUtil.FRUITTYPE_UNKNOWN;
	
	self.lastArea = 0;
	self.lastAreaBiggerZero = self.lastArea > 0;
	self.vkl = false;
	
	self.trailerRaycastCallback = pun.trailerRaycastCallback;

	self.pipe = {};
	self.pipe.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pipe#index"));
	self.pipe.distance = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.pipe#raycastDistance"), 7);

	self.isLoading = true;
	
	self.pipeStrawParticleSystems = {};
    local i = 0;
    while true do
        local namei = string.format("vehicle.pipeStrawParticleSystems.pipeStrawParticleSystem(%d)", i);
		local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, namei .. "#index"));
		if nodei == nil then
			break;
		end; 
        Utils.loadParticleSystem(xmlFile, self.pipeStrawParticleSystems, namei, nodei, false, nil, self.baseDirectory)		
		Utils.setEmittingState(self.pipeStrawParticleSystems,false)
		i = i +1;		
    end;
	
end;

function pun:delete()
	Utils.deleteParticleSystem(self.pipeStrawParticleSystems);
end;

function pun:readStream(streamId, connection)
	
	self.lastAreaBiggerZero = streamReadBool(streamId);
	self.currentFruitType = streamReadInt8(streamId);
	self.isLoading = true;
end;

function pun:writeStream(streamId, connection)
	streamWriteBool(streamId, self.lastAreaBiggerZero);
	streamWriteInt8(streamId, self.currentFruitType);
	streamWriteBool(streamId, self.isLoaded);
end;

function pun:readUpdateStream(streamId, timestamp, connection)
	if connection:getIsServer() then
		self.lastAreaBiggerZero = streamReadBool(streamId);
		self.currentFruitType = streamReadInt8(streamId);
	end;
end;

function pun:writeUpdateStream(streamId, connection, dirtyMask)
	if not connection:getIsServer() then
		streamWriteBool(streamId, self.lastAreaBiggerZero);
		streamWriteInt8(streamId, self.currentFruitType);
	end;
end;

function pun:mouseEvent(posX, posY, isDown, isUp, button)
end;

function pun:keyEvent(unicode, sym, modifier, isDown)
end;

function pun:update(dt)
	if self:getIsActive() then
		
			if self.vkl then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("pun_off"), self.typeDesc), InputBinding.pun_ob);
				
			else
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("pun_on"), self.typeDesc), InputBinding.pun_ob);
				
			end;
			if InputBinding.hasEvent (InputBinding.pun_ob) then
			self.vkl = not self.vkl;
		end;
			
	end;			
end;

function pun:updateTick(dt)
	self.trailerFoundId = 0;
	self.wasToFast = false;
    self.lastArea = 0;
   
	local x, y, z = getWorldTranslation(self.pipe.node);
	local dx, dy, dz = localDirectionToWorld(self.pipe.node, 0, -0.5, 0);
	raycastAll(x, y, z, dx, dy, dz, "trailerRaycastCallback", self.pipe.distance, self);
   
	if self:getIsActive() then	
        		
		self.currentFruitType = FruitUtil.FRUITTYPE_UNKNOWN;	
		
		local deltaLevel = 0;
        if self.vkl then
            local toFast = self:doCheckSpeedLimit() and self.attacherVehicle.lastSpeed*3600 > 20;
            if self.isServer then
                if not toFast then
                    local cuttingAreasSend = {};
					
                    for k, cuttingArea in pairs(self.cuttingAreas) do
                        if self:getIsAreaActive(cuttingArea) then
                            local x,y,z = getWorldTranslation(cuttingArea.start);
                            local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
                            local x2,y2,z2 = getWorldTranslation(cuttingArea.height);
                            table.insert(cuttingAreasSend, {x,z,x1,z1,x2,z2});
                        end;
                    end;
                    if (table.getn(cuttingAreasSend) > 0) then
						local fruitTypeFix = false;
						local lastArea, fillType, fruitType = CutAreaEvent.runLocally(cuttingAreasSend, self.fillTypes, self.currentFillType);
						self.lastArea = lastArea;
						self.lastAreaBiggerZero = (self.lastArea > 0);
						local pixelToSqm = g_currentMission:getFruitPixelsToSqm();
                        local sqm = lastArea*pixelToSqm;
						local fruitType = FruitUtil.FRUITTYPE_UNKNOWN;
						if self.fillLevel > self.capacity*self.fillTypeChangeThreshold and FruitUtil.fillTypeToFruitType[self.currentFillType] ~= nil and FruitUtil.fillTypeIsWindrow[self.currentFillType] then
                            fruitTypeFix = true;
                            fruitType = FruitUtil.fillTypeToFruitType[self.currentFillType];
                        end
						
							if lastArea > 0 then
								self.currentFruitType = FruitUtil.fillTypeToFruitType[fillType];
								local pixelToSqm = g_currentMission:getFruitPixelsToSqm();
								local literPerSqm = FruitUtil.fruitIndexToDesc[self.currentFruitType].literPerSqm;
								local sqm = lastArea * pixelToSqm;
								local deltaLevel = 0;		
								local fruitType = FruitUtil.fillTypeToFruitType[fillType]
								deltaLevel = (sqm * literPerSqm * 8 * self.fillScale)/2;
								if self.trailerFoundId ~= nil and self.trailerFoundId ~= 0 then
									local trailer = g_currentMission.nodeToVehicle[self.trailerFoundId];
									if trailer ~= nil and trailer ~= self and trailer:allowFillType(Fillable.FILLTYPE_BARLEY_WINDROW, true) and trailer.allowFillFromAir and trailer.capacity ~= trailer.fillLevel then
										trailer:setFillLevel(trailer.fillLevel+deltaLevel, Fillable.FILLTYPE_BARLEY_WINDROW);
									end;
								end;
								
							
								
							end;
						
                    end;
                end;
				self.wasToFast = toFast;
			end;
		end;
		if self.vkl and self.lastAreaBiggerZero then
			Utils.setEmittingState(self.pipeStrawParticleSystems, true);
		else
			Utils.setEmittingState(self.pipeStrawParticleSystems, false);	
		end;
	end;
end;


function pun:draw()

end;
	


function pun:onDetach()

	
end;

function pun:onAttach(attacherVehicle)
end;

function pun:onLeave()
end;

function pun:onDeactivate()

	

end;
  
function pun:trailerRaycastCallback(transformId, x, y, z, distance)
local vehicle = g_currentMission.nodeToVehicle[transformId];
	if vehicle ~= nil then
		if vehicle.exactFillRootNode == transformId then
			self.trailerFoundId = transformId;
			return false;
		end;
	end;
	return true;
end;