liquitmanurestorageLoader = {};
liquitmanurestorageLoader.triggers = {};
g_BaseDir = g_currentModDirectory;

function liquitmanurestorageLoader.onCreate(id)
	print("created LiquitManureLager, id: ", tostring(id));
	
	local selltrigger = liquitmanurestorage:new(g_server ~= nil, g_client ~= nil);
    g_currentMission:addOnCreateLoadedObject(selltrigger);
    selltrigger:load(id);
    selltrigger:register(true);
    table.insert(liquitmanurestorageLoader.triggers, selltrigger);
	
end;
function liquitmanurestorageLoader:loadMap(name)
end;
function liquitmanurestorageLoader:deleteMap()
	liquitmanurestorageLoader.triggers = {};
end;
function liquitmanurestorageLoader:mouseEvent(posX, posY, isDown, isUp, button)
end;
function liquitmanurestorageLoader:keyEvent(unicode, sym, modifier, isDown)
end;
function liquitmanurestorageLoader:update(dt)
end;
function liquitmanurestorageLoader:draw(dt)
	for i,trigger in ipairs(liquitmanurestorageLoader.triggers) do
		trigger:draw(trigger);
	end;
end;

addModEventListener(liquitmanurestorageLoader);

------------modOnCreate.baleSellOnCreate-------------------modOnCreate.liquitmanurestorageOnCreate-------------------------------------------------------------------

liquitmanurestorage = {};

local liquitmanurestorage_mt = Class(liquitmanurestorage,Object);

function liquitmanurestorage:new(isServer, isClient)
	local self = Object:new(isServer, isClient, liquitmanurestorage_mt)
	return self
 end;
 
function liquitmanurestorage:load(id)
	self.nodeId = id
	self.setFillLevel = liquitmanurestorage.setFillLevel;
	self.allowFillType = liquitmanurestorage.allowFillType;

	local triggerIndex = getUserAttribute(id, "triggerIndex")
    if triggerIndex ~= nil then
		manureTrigger = Utils.indexToObject(id, triggerIndex)
		if manureTrigger ~= nil then
        	addTrigger(manureTrigger, "triggerCallback", self);
		end
    end
	self.capacity = Utils.getNoNil(getUserAttribute(id, "capacity"), 800000)
	local minY, maxY = Utils.getVectorFromString(getUserAttribute(id, "moveMinMaxY"))
	if minY ~= nil and maxY ~= nil then
		self.moveMinY = minY
		self.moveMaxY = maxY
		self.movingId = Utils.indexToObject(id, getUserAttribute(id, "movingIndex"))
	end
	self.fillTypes = {};
	self.fillTypes[Fillable.FILLTYPE_UNKNOWN] = true;
	local fillTypes = getUserAttribute(id, "fillType");
	if fillTypes ~= nil then
		local types = Utils.splitString(" ", fillTypes);
		for k,v in pairs(types) do
			local fillType = Fillable.fillTypeNameToInt[v];
			if fillType ~= nil then
				self.fillTypes[fillType] = true;
			else
				print("Warning: '"..self.configFileName.. "' has invalid fillType '"..v.."'.");
			end;
		end;
	end;
	self.triggerId = manureTrigger;
	self.currentFillType = FruitUtil.FILLTYPE_UNKNOWN;
	self.fillLevel = 0;
	--self:setFillLevel(self.fillLevel, self.fillType);
	self.vehiclesInRange = {}
	self.playerInRange = false
	self.sentcurrentFillType = self.currentFillType
	self.sentFillLevel = self.fillLevel
		self.ManureLagerDirtyFlag = self:getNextDirtyFlag();

			g_currentMission:addNodeObject(self.nodeId, self)
	g_currentMission:addOnCreateLoadedObjectToSave(self)
end; 

function liquitmanurestorage:delete()
	removeTrigger(self.triggerId);
end;

function liquitmanurestorage:readStream(streamId, connection)
	liquitmanurestorage:superClass().readStream(self, streamId, connection)
	if connection:getIsServer() then
		local fillLevel = streamReadFloat32(streamId)
		local fillType = streamReadUIntN(streamId, liquitmanurestorage.sendNumBits)
		self:setFillLevel(fillLevel, fillType)
	end;
end;

function liquitmanurestorage:writeStream(streamId, connection)
  liquitmanurestorage:superClass().readStream(self, streamId, connection)
  if not connection:getIsServer() then
		streamWriteFloat32(streamId, self.fillLevel)
		streamWriteUIntN(streamId, self.currentFillType, liquitmanurestorage.sendNumBits)
	end;
end;

function liquitmanurestorage:readUpdateStream(streamId, timestamp, connection)
	liquitmanurestorage:superClass().readUpdateStream(self, streamId, timestamp, connection)
	if connection:getIsServer() then
		local fillLevel = streamReadFloat32(streamId)
		local fillType = streamReadUIntN(streamId, liquitmanurestorage.sendNumBits)
		self:setFillLevel(fillLevel, fillType)
	end;
end;

function liquitmanurestorage:writeUpdateStream(streamId, connection, dirtyMask)
	liquitmanurestorage:superClass().writeUpdateStream(self, streamId, connection, dirtyMask)
	if not connection:getIsServer() then
		streamWriteFloat32(streamId, self.fillLevel)
		streamWriteUIntN(streamId, self.currentFillType, liquitmanurestorage.sendNumBits)
	end;
end;

function liquitmanurestorage:loadFromAttributesAndNodes(xmlFile, key)
	local fillLevel = getXMLFloat(xmlFile, key.."#fillLevel");
	local fillType = getXMLString(xmlFile, key.."#fillType");
	if fillLevel ~= nil and fillType ~= nil then
		local fillTypeInt = Fillable.fillTypeNameToInt[fillType];
		if fillTypeInt ~= nil then
			self:setFillLevel(fillLevel, fillTypeInt);
		end;
	end;
	return true
end

function liquitmanurestorage:getSaveAttributesAndNodes(nodeIdent)
	local fillType = Fillable.fillTypeIntToName[self.currentFillType];
	if fillType == nil then
		fillType = Fillable.fillTypeIntToName[Fillable.FILLTYPE_UNKNOWN];
	end;
	attributes = " fillType=\"" .. fillType .. "\""
	attributes = attributes .. " fillLevel=\"" .. self.fillLevel .. "\""
	return attributes, nodes
end

function liquitmanurestorage:update(dt)
	if self:getShowInfo() then
		g_currentMission:addExtraPrintText(g_i18n:getText("fill_level") .. " " .. math.floor(self.fillLevel) .. " (" .. math.floor(100 * self.fillLevel / self.capacity) .. "%)")
	end;
end;

function liquitmanurestorage:updateTick(dt)
	if self.isServer then
		if self.fillLevel ~= self.sentFillLevel or self.currentFillType ~= self.sentcurrentFillType then
			self:raiseDirtyFlags(self.ManureLagerDirtyFlag)
			self.sentFillLevel = self.fillLevel
			self.sentcurrentFillType = self.currentFillType
		end
	end
end;

function liquitmanurestorage:setFillLevel(fillLevel, fillType, force)
	self.currentFillType = fillType;
	self.fillLevel = fillLevel;
	if self.fillLevel >= self.capacity then
		self.fillLevel = self.capacity;
	end;
	if self.fillLevel <= 0 then
		self.fillLevel = 0;
		self.currentFillType = FruitUtil.FRUITTYPE_UNKNOWN;
	end;
	if self.movingId ~= nil then
		local x, y, z = getTranslation(self.movingId)
		local y = self.moveMinY + (self.moveMaxY - self.moveMinY) * self.fillLevel / self.capacity
		setTranslation(self.movingId, x, y, z)
	end
end;

function liquitmanurestorage:DoReFill(sprayer, delta)
 if self.fillLevel < self.capacity then
		sprayer:setFillLevel(sprayer.fillLevel - delta, sprayer.currentFillType, true);
		if sprayer.fillLevel > 0 then
			self:setFillLevel(self.fillLevel + delta, sprayer.currentFillType, true);
		end
	end;
end

function liquitmanurestorage:getShowInfo()
	if (g_currentMission.controlPlayer and self.playerInRange) then
		return true;
	end;
	if not g_currentMission.controlPlayer then
		for vehicle in pairs(self.vehiclesInRange) do
			if vehicle:getIsActiveForInput(false) then
				return true;
			end;
		end;
	end;
	return false;
end;
function liquitmanurestorage:getIsActivatable2(fillable)
	return true
end

function liquitmanurestorage:fillSprayer(sprayer, delta)
	if not sprayer:allowFillType(self.currentFillType, false) then
		return 0
	end
	delta = math.max(math.min(delta, self.fillLevel), 0)
	local oldFillLevel = sprayer:getFillLevel(self.currentFillType)
	if delta > 0 then
		sprayer:setFillLevel(oldFillLevel + delta, self.currentFillType, true)
		delta = sprayer:getFillLevel(self.currentFillType) - oldFillLevel
		if delta > 0 then
			self:setFillLevel(self.fillLevel - delta,self.currentFillType)
		end
	end

	return delta
end
function liquitmanurestorage:getIsActivatable(fillable)
	if not fillable:allowFillType(self.currentFillType, false) or self.fillLevel <= 0 then
		return false;
	end;
	return true
end
function liquitmanurestorage:allowFillType(fillType, allowEmptying)
	local allowed = false;
	if self.fillTypes[fillType] then
		if self.currentFillType ~= Fillable.FILLTYPE_UNKNOWN then
			if self.currentFillType ~= fillType then
				if self.fillLevel <= self.capacity*0.05 then
					allowed = true; -- fill level is low enough to be overridden
					if allowEmptying then
						self.fillLevel = 0; -- empty the trailer
					end;
				end;
			else
				allowed = true; -- fill type is the same as the trailer's current fill type
			end;
		else
			allowed = true; -- fillable is empty --> Fillable.FILLTYPE_UNKNOWN
		end;
	end;
	return allowed;
end;
function liquitmanurestorage:triggerCallback(triggerId, otherActorId, onEnter, onLeave, onStay, otherShapeId)
	if (onEnter or onLeave) then
		if g_currentMission.player ~= nil and otherActorId == g_currentMission.player.rootNode then
			if onEnter then
				self.playerInRange = true
			else
				self.playerInRange = false
			end
		else
			local vehicle = g_currentMission.nodeToVehicle[otherActorId]
			if vehicle ~= nil then
				if onEnter then
					self.vehiclesInRange[vehicle] = true
				else
					self.vehiclesInRange[vehicle] = nil
				end
			end
			if vehicle ~= nil and vehicle.addSprayerFillTrigger ~= nil and vehicle.removeSprayerFillTrigger ~= nil then
				if onEnter then
					vehicle:addSprayerFillTrigger(self);
					vehicle:addReFillTrigger(self);
				else -- onLeave
					vehicle:removeSprayerFillTrigger(self);
					vehicle:removeReFillTrigger(self);
				end;
			end;
		end
	end
end

g_onCreateUtil.addOnCreateFunction("liquitmanurestorageOnCreate", liquitmanurestorageLoader.onCreate);