--
-- MIG_Map_MadeInGermany_Celle
--
-- @author  Stefan Geiger
-- @date  06/08/12
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

MIG_Map_MadeInGermany_Celle = {}

local MIG_Map_MadeInGermany_Celle_mt = Class(MIG_Map_MadeInGermany_Celle, Mission00);


function MIG_Map_MadeInGermany_Celle:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = MIG_Map_MadeInGermany_Celle_mt;
    end;
    local self = MIG_Map_MadeInGermany_Celle:superClass():new(baseDirectory, mt);

--    self.playerStartX = 39;
--    self.playerStartY = 0.1;
--    self.playerStartZ = -330;
--    self.playerRotX = 0;
--    self.playerRotY = Utils.degToRad(90);

    return self;
end;

function MIG_Map_MadeInGermany_Celle:delete()
    MIG_Map_MadeInGermany_Celle:superClass().delete(self);
end;

function MIG_Map_MadeInGermany_Celle:load()
    self:startLoadingTask();

    self.environment = Environment:new(Utils.getFilename("MIG_Map/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);

    self.helpIconsBase = nil;
    self.collectableHorseshoesObject = nil;
    self.fieldDefinitionBase = nil;
    self.vehicleShopBase = nil;

    self:loadMap(Utils.getFilename("map01.i3d", self.baseDirectory), true, self.loadMap01Finished, self);



	FruitUtil.fruitTypes.rape.literPerSqm = 0.816;
	FruitUtil.fruitTypes.maize.literPerSqm = 2.0;
	FruitUtil.fruitTypes.wheat.literPerSqm = 0.85;
	FruitUtil.fruitTypes.barley.literPerSqm = 0.633;
	FruitUtil.fruitTypes.grass.literPerSqm = 3;	
end;

function MIG_Map_MadeInGermany_Celle:loadMap01Finished(node, arguments)


	self.terrainDetailAngleNumChannels = 8; -- durch die gewnschte Anzahl Channels ersetzen
	self.terrainDetailAngleMaxValue = bitShiftLeft(1, self.terrainDetailAngleNumChannels) - 1;


    self:loadMapXMLFile(Utils.getFilename("MIG_Map_MadeInGermany_Celle.xml", self.baseDirectory));

    self.missionPDA:loadMap(Utils.getFilename("map01/pda_map.dds", self.baseDirectory), 4096, 4096);

    g_inGameMenu:setMapViewsMap(Utils.getFilename("map01/pda_map.dds", self.baseDirectory), 4096, 4096);

    local iconSize = self.missionPDA.pdaMapWidth / 15;

    -- ATMs
    self.missionPDA:createMapHotspot("Bank", Utils.getFilename("$dataS2/missions/hud_pda_spot_bank.png", self.baseDirectory), 4096 - 230, 4096 + 439.5, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Bank", Utils.getFilename("$dataS2/missions/hud_pda_spot_bank.png", self.baseDirectory), 4096 - 144.65, 4096 - 352.25, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Bank", Utils.getFilename("$dataS2/missions/hud_pda_spot_bank.png", self.baseDirectory), 4096 + 513.75, 4096 + 202, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Bank", Utils.getFilename("$dataS2/missions/hud_pda_spot_bank.png", self.baseDirectory), 4096 + 723.9, 4096 + 608.25, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Bank", Utils.getFilename("$dataS2/missions/hud_pda_spot_bank.png", self.baseDirectory), 4096 - 162, 4096 - 679.51, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- Vehicle Shop
    self.missionPDA:createMapHotspot("Shop", Utils.getFilename("$dataS2/missions/hud_pda_spot_shop.png", self.baseDirectory), 4096 - 130, 4096 - 383, iconSize, iconSize * (4 / 3), false, false, false, 0, true);


    -- farm silos
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), 4096 + 43.5, 4096 - 128.3, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    -- bga
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), 4096 + 395.1, 4096 - 693.7, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    

    -- livestock
    self.missionPDA:createMapHotspot("Cows", Utils.getFilename("$dataS2/missions/hud_pda_spot_cows.png", self.baseDirectory), 4096 + 256, 4096 + 655, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Sheep", Utils.getFilename("$dataS2/missions/hud_pda_spot_sheep.png", self.baseDirectory), -600, 585, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Chickens", Utils.getFilename("$dataS2/missions/hud_pda_spot_chickens.png", self.baseDirectory), -12, -93, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    MIG_Map_MadeInGermany_Celle:superClass().load(self);

    if not self.missionDynamicInfo.isMultiplayer then
        self:updateFoundHorseshoes();
        self:updateFoundHelpIcons();
        self:updateMeteoriteCrash();
        self:updateRainbow();
    else
        self:removeAllHorseshoes();
        self:removeAllHelpIcons();
    end;

    if g_isGamescomVersion then
        self:playerOwnsAllFields();
    end;

    self:finishLoadingTask();
end;

function MIG_Map_MadeInGermany_Celle:onStartMission()
    MIG_Map_MadeInGermany_Celle:superClass().onStartMission(self);
end;

function MIG_Map_MadeInGermany_Celle:mouseEvent(posX, posY, isDown, isUp, button)
    MIG_Map_MadeInGermany_Celle:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function MIG_Map_MadeInGermany_Celle:keyEvent(unicode, sym, modifier, isDown)
    MIG_Map_MadeInGermany_Celle:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function MIG_Map_MadeInGermany_Celle:update(dt)
    MIG_Map_MadeInGermany_Celle:superClass().update(self, dt);
end;

function MIG_Map_MadeInGermany_Celle:draw()
    MIG_Map_MadeInGermany_Celle:superClass().draw(self);
end;