--
-- Fuchs Guellefass
-- Class for the Fuchs Guellefass
--
-- @author  Stefan Maurus - www.stefanmaurus.de
-- @date  20.08.2012
-- @last edit 09.02.2013
--
Vehicle.registerJointType("distributor");

FuchsGuellefass = {};
  
function FuchsGuellefass.prerequisitesPresent(specializations)
      return SpecializationUtil.hasSpecialization(Sprayer, specializations);
end;

function FuchsGuellefass:load(xmlFile)
	self.setdeckelAnimationisPlaying = SpecializationUtil.callSpecializationsFunction("setdeckelAnimationisPlaying"); 
	
	-- Fuellstandsanzeiger 
	self.Zeiger = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Zeiger#index"));	
	self.ZeigerMin =  Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.Zeiger#rotationMax"));	
	self.ZeigerMax =  Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.Zeiger#rotationMin"));	
	self.ZeigerAchse = getXMLString(xmlFile, "vehicle.Zeiger#rotationAchse");
	self.XAchse = "x";
	self.YAchse = "y";
	self.ZAchse = "z";
	self.PositiveZahl = false;
	self.NegativeZahl = false;
	self.ZeigerRotationNew = 0;

	-- Sounds
	self.ManurefillSoundIndex = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.ManurefillSound#index"));	
  	local ManurefillSound = getXMLString(xmlFile, "vehicle.ManurefillSound#file");
    if ManurefillSound ~= nil and ManurefillSound ~= "" then
		ManurefillSound = Utils.getFilename(ManurefillSound, self.baseDirectory);
		self.ManurefillSound = createAudioSource("ManurefillSound", ManurefillSound, 30, 25, 0.5, 0);
		link(self.ManurefillSoundIndex, self.ManurefillSound);
		setVisibility(self.ManurefillSound, false);
    end;
	
  	local ManurefillSoundMax = getXMLString(xmlFile, "vehicle.ManurefillSound#file");
    if ManurefillSoundMax ~= nil and ManurefillSoundMax ~= "" then
		ManurefillSoundMax = Utils.getFilename(ManurefillSoundMax, self.baseDirectory);
		self.ManurefillSoundMax = createAudioSource("ManurefillSoundMax", ManurefillSoundMax, 30, 25, 1, 0);
		link(self.ManurefillSoundIndex, self.ManurefillSoundMax);
		setVisibility(self.ManurefillSoundMax, false);
    end;		
	
	--Animations
    local deckelAnimation = {};
    deckelAnimation.name = getXMLString(xmlFile, "vehicle.deckelAnimation#name");
    deckelAnimation.openSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.deckelAnimation#openSpeedScale"), 1);
    deckelAnimation.closeSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.deckelAnimation#closeSpeedScale"), -deckelAnimation.openSpeedScale);
    if deckelAnimation.name ~= nil then
        self.deckelAnimation = deckelAnimation;
    end;	
	self.deckelAnimationisPlaying = false;
	
	--Plane
	self.ManurePlane = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.ManurePlane#index"));
	self.getFieldIsOwnedNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.getFieldIsOwned#index"));		
	
	self.CuttingAreasHelpisOn = false;
	self.distributerIsAttached = false;
	self.isFuchsFass = true;
end;

function FuchsGuellefass:detachImplement()
	self.distributerIsAttached = false;
	self.CuttingAreasHelpisOn = false;	
end;

function FuchsGuellefass:delete()
	setVisibility(self.ManurefillSound, false);
	setVisibility(self.ManurefillSoundMax, false);		
end;

function FuchsGuellefass:readStream(streamId, connection)
	self:setdeckelAnimationisPlaying(streamReadBool(streamId), true);	
end;

function FuchsGuellefass:writeStream(streamId, connection) 
	streamWriteBool(streamId, self.deckelAnimationisPlaying);
end;

function FuchsGuellefass:setdeckelAnimationisPlaying(bool, noEventSend)
	self.deckelAnimationisPlaying = bool;
	SetdeckelAnimationisPlayingEvent.sendEvent(self, bool, noEventSend);
end;

function FuchsGuellefass:mouseEvent(posX, posY, isDown, isUp, button)
end;
 
function FuchsGuellefass:keyEvent(unicode, sym, modifier, isDown)
end;
 
function FuchsGuellefass:update(dt)
	local rx, ry, rz = getRotation(self.Zeiger)
	local unterschiedMinMax = self.ZeigerMax - self.ZeigerMin; 
	if unterschiedMinMax > 0 then
		self.PositiveZahl = true;
		self.NegativeZahl = false;		
	else
		self.NegativeZahl = true;
		self.PositiveZahl = false;
	end;	
	local fillLevelNew = self.fillLevel / self.capacity * 100;
	local fillLevelPerCent = math.floor(fillLevelNew)
	local RotationStep = unterschiedMinMax / 100; 
	local ZeigerRotation = fillLevelPerCent * RotationStep; 
	local ZeigerRotationRad = math.rad(ZeigerRotation); 
	if self.PositiveZahl == true and self.NegativeZahl == false then
		self.ZeigerRotationNew = ZeigerRotationRad * -1;
	elseif self.PositiveZahl == false and self.NegativeZahl == true then
		self.ZeigerRotationNew = ZeigerRotationRad * 1;	
	end;
	if self.ZeigerAchse == self.XAchse then
		setRotation(self.Zeiger, self.ZeigerRotationNew, ry, rz)
	elseif self.ZeigerAchse == self.YAchse then
		setRotation(self.Zeiger, rx, self.ZeigerRotationNew, rz)	
	elseif self.ZeigerAchse == self.ZAchse then
		setRotation(self.Zeiger, rx, ry, self.ZeigerRotationNew)	
	end;
	
	
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.OpenCloseDeckel) then
			self:setdeckelAnimationisPlaying(not self.deckelAnimationisPlaying);	
		end;
		if self.distributerIsAttached then
			if InputBinding.hasEvent(InputBinding.CuttingAreasHelpOnOff) then
				if self.CuttingAreasHelpisOn then
					self.CuttingAreasHelpisOn = false;
				else
					self.CuttingAreasHelpisOn = true;
				end;
			end;
		end;
	end;	
end;

function FuchsGuellefass:updateTick(dt)
	
	if self.deckelAnimationisPlaying then
		self:playAnimation(self.deckelAnimation.name, self.deckelAnimation.openSpeedScale, self:getAnimationTime(self.deckelAnimation.name), true);
	else
		self:playAnimation(self.deckelAnimation.name, self.deckelAnimation.closeSpeedScale, self:getAnimationTime(self.deckelAnimation.name), true);	
	end;
	
	local fillLevelNew = self.fillLevel / self.capacity * 100;
	local fillLevelPerCent = math.floor(fillLevelNew)	
	if fillLevelPerCent > 99 then
		setVisibility(self.ManurePlane, true);	
	else
		setVisibility(self.ManurePlane, false);	
	end;
	
	if self.isSprayerFilling then
		if fillLevelPerCent < 97 then
			setVisibility(self.ManurefillSound, true);
			setVisibility(self.ManurefillSoundMax, false);		
		elseif fillLevelPerCent > 97 then
			setVisibility(self.ManurefillSound, true);
			setVisibility(self.ManurefillSoundMax, true);	
		elseif fillLevelPerCent > 98 then
			setVisibility(self.ManurefillSound, false);
			setVisibility(self.ManurefillSoundMax, true);	
		end;
	else
		setVisibility(self.ManurefillSound, false);
		setVisibility(self.ManurefillSoundMax, false);				
	end;
	
end;

function FuchsGuellefass:draw()	
	if self.deckelAnimationisPlaying then
		g_currentMission:addHelpButtonText(g_i18n:getText("CloseDeckel"), InputBinding.OpenCloseDeckel);		
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("OpenDeckel"), InputBinding.OpenCloseDeckel);
	end;
	if self.distributerIsAttached then
		if not self.CuttingAreasHelpisOn then
			g_currentMission:addHelpButtonText(g_i18n:getText("CuttingAreasHelpTurnOn"), InputBinding.CuttingAreasHelpOnOff);		
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("CuttingAreasHelpTurnOff"), InputBinding.CuttingAreasHelpOnOff);
		end;
	end;
end;
 
function FuchsGuellefass:onDetach()
	setVisibility(self.ManurefillSound, false);
	setVisibility(self.ManurefillSoundMax, false);		
end;

function FuchsGuellefass:onLeave()
	local fillLevelNew = self.fillLevel / self.capacity * 100;
	local fillLevelPerCent = math.floor(fillLevelNew)	
	if self.isSprayerFilling then
		if fillLevelPerCent < 95 then
			setVisibility(self.ManurefillSound, true);
			setVisibility(self.ManurefillSoundMax, false);		
		elseif fillLevelPerCent > 95 then
			setVisibility(self.ManurefillSound, false);
			setVisibility(self.ManurefillSoundMax, true);	
		end;
	else
		setVisibility(self.ManurefillSound, false);
		setVisibility(self.ManurefillSoundMax, false);				
	end;
end;
 
function FuchsGuellefass:onDeactivate()
end;
  
function FuchsGuellefass:onDeactivateSounds()
	setVisibility(self.ManurefillSound, false);
	setVisibility(self.ManurefillSoundMax, false);			
end;

function FuchsGuellefass:SupdateTick(dt)
	if self.isFuchsFass then
       if self:getIsActive() then
           local showFieldNotOwnedWarning = false;
           if self.isTurnedOn then
               if not self:getIsTurnedOnAllowed(true) then
                   self:setIsTurnedOn(false);
               end;
           end
           if self.isTurnedOn and self.allowsSpraying then
   
               if self.isClient then
                   -- update valve particle systems
                   local foldAnimTime = self.foldAnimTime;
                   if foldAnimTime ~= nil and foldAnimTime ~= self.lastSprayValveUpdateFoldTime then
                       self.lastSprayValveUpdateFoldTime = foldAnimTime;
                       for _,sprayValve in pairs(self.sprayValves) do
                           Utils.setEmittingState(sprayValve.particleSystems, foldAnimTime <= sprayValve.foldMaxLimit and foldAnimTime >= sprayValve.foldMinLimit);
                       end
                   end
               end
   
               self.lastSprayingArea = 0;
   
               if self:doCheckSpeedLimit() and self.lastSpeed*3600 > 31 then
                   self.speedViolationTimer = self.speedViolationTimer - dt;
               else
                   self.speedViolationTimer = self.speedViolationMaxTime;
               end;
   
               if self.isServer then
                   if self.speedViolationTimer > 0 then
                       local litersPerSecond = self.sprayLitersPerSecond[self.currentFillType];
                       if litersPerSecond == nil then
                           litersPerSecond = self.defaultSprayLitersPerSecond;
                       end
                       local usage = litersPerSecond * dt*0.001;
   
                       local hasSpray = false;
   
                       if self.capacity == 0 or self:getIsHired() then
                           hasSpray = true;
                           local fillType = self.currentFillType;
                           if fillType == Fillable.FILLTYPE_UNKNOWN then
                               fillType = self:getFirstEnabledFillType();
                           end
                           local fillTypeDesc = Fillable.fillTypeIndexToDesc[fillType];
                           if fillTypeDesc ~= nil then
                               local delta = usage*fillTypeDesc.pricePerLiter
                               g_currentMission.missionStats.expensesTotal = g_currentMission.missionStats.expensesTotal + delta;
                               g_currentMission.missionStats.expensesSession = g_currentMission.missionStats.expensesSession + delta;
   
                               g_currentMission:addSharedMoney(-delta, "other");
   
                               -- TODO update spray stats
                               --[[g_currentMission.missionStats.sprayUsageTotal = g_currentMission.missionStats.sprayUsageTotal + usage;
                               g_currentMission.missionStats.sprayUsageSession = g_currentMission.missionStats.sprayUsageSession + usage;]]
                           end;
                       else
                           if self.fillLevel > 0 then
                               hasSpray = true;
                               self:setFillLevel(self.fillLevel - usage, self.currentFillType);
                           else
                               -- try to find another attached sprayer
                               local fillType = self.currentFillType;
                               if fillType == Fillable.FILLTYPE_UNKNOWN then
                                   fillType = self:getFirstEnabledFillType();
                               end
                               local sprayerTank = Sprayer.findAttachedSprayerTank(self:getRootAttacherVehicle(), fillType);
                               if sprayerTank ~= nil then
                                   hasSpray = true;
                                   sprayerTank:setFillLevel(sprayerTank:getFillLevel(fillType) - usage, fillType);
                               end
                           end;
                       end;
   
                       if hasSpray then
                           local cuttingAreasSend = {};
                           for _,cuttingArea in pairs(self.cuttingAreas) do
                               if self:getIsAreaActive(cuttingArea) then
                                   local x,_,z = getWorldTranslation(self.getFieldIsOwnedNode);
                                   if g_currentMission:getIsFieldOwnedAtWorldPos(x,z) then
									   local x,_,z = getWorldTranslation(cuttingArea.start);								   
                                       local x1,_,z1 = getWorldTranslation(cuttingArea.width);
                                       local x2,_,z2 = getWorldTranslation(cuttingArea.height);
   
                                       local sqm = math.abs((z1-z)*(x2-x) - (x1-x)*(z2-z)); -- this is the cross product with y=0
   
                                       --Utils.updateSprayArea(x, z, x1, z1, x2, z2);
   
                                       self.lastSprayingArea = self.lastSprayingArea + sqm;
   
                                       table.insert(cuttingAreasSend, {x,z,x1,z1,x2,z2});
                                   else
                                       showFieldNotOwnedWarning = true;
                                   end
                               end;
                           end;
                           if (table.getn(cuttingAreasSend) > 0) then
                               SprayerAreaEvent.runLocally(cuttingAreasSend);
                               g_server:broadcastEvent(SprayerAreaEvent:new(cuttingAreasSend));
                           end;
                       end;
                   end;
               end;
   
               if self.isClient then
                   if not self.spraySoundEnabled and self.spraySound ~= nil and self:getIsActiveForSound() then
                       playSample(self.spraySound, 0, self.spraySoundVolume, 0);
                       self.spraySoundEnabled = true;
                   end;
               end;
   
               for _, node in pairs(self.turnedOnRotationNodes) do
                   rotate(node.node, 0, -dt*node.rotSpeed, 0);
               end
           else
               self.speedViolationTimer = self.speedViolationMaxTime;
           end;
   
           if self.isServer then
               if showFieldNotOwnedWarning ~= self.showFieldNotOwnedWarning then
                   self.showFieldNotOwnedWarning = showFieldNotOwnedWarning;
                   self:raiseDirtyFlags(self.sprayerDirtyFlag);
               end
           end
       end;
   
       if self.isServer and self.isSprayerFilling then
           local delta = 0;
           if self.sprayerFillTrigger ~= nil then
               delta = self.fillLitersPerSecond*dt*0.001;
               delta = self.sprayerFillTrigger:fillSprayer(self, delta);
           end
   
           if delta <= 0 then
               self:setIsSprayerFilling(false);
           end;
       end;
	   
	else
	
       if self:getIsActive() then
           local showFieldNotOwnedWarning = false;
           if self.isTurnedOn then
               if not self:getIsTurnedOnAllowed(true) then
                   self:setIsTurnedOn(false);
               end;
           end
           if self.isTurnedOn and self.allowsSpraying then
   
               if self.isClient then
                   -- update valve particle systems
                   local foldAnimTime = self.foldAnimTime;
                   if foldAnimTime ~= nil and foldAnimTime ~= self.lastSprayValveUpdateFoldTime then
                       self.lastSprayValveUpdateFoldTime = foldAnimTime;
                       for _,sprayValve in pairs(self.sprayValves) do
                           Utils.setEmittingState(sprayValve.particleSystems, foldAnimTime <= sprayValve.foldMaxLimit and foldAnimTime >= sprayValve.foldMinLimit);
                       end
                   end
               end
   
               self.lastSprayingArea = 0;
   
               if self:doCheckSpeedLimit() and self.lastSpeed*3600 > 31 then
                   self.speedViolationTimer = self.speedViolationTimer - dt;
               else
                   self.speedViolationTimer = self.speedViolationMaxTime;
               end;
   
               if self.isServer then
                   if self.speedViolationTimer > 0 then
                       local litersPerSecond = self.sprayLitersPerSecond[self.currentFillType];
                       if litersPerSecond == nil then
                           litersPerSecond = self.defaultSprayLitersPerSecond;
                       end
                       local usage = litersPerSecond * dt*0.001;
   
                       local hasSpray = false;
   
                       if self.capacity == 0 or self:getIsHired() then
                           hasSpray = true;
                           local fillType = self.currentFillType;
                           if fillType == Fillable.FILLTYPE_UNKNOWN then
                               fillType = self:getFirstEnabledFillType();
                           end
                           local fillTypeDesc = Fillable.fillTypeIndexToDesc[fillType];
                           if fillTypeDesc ~= nil then
                               local delta = usage*fillTypeDesc.pricePerLiter
                               g_currentMission.missionStats.expensesTotal = g_currentMission.missionStats.expensesTotal + delta;
                               g_currentMission.missionStats.expensesSession = g_currentMission.missionStats.expensesSession + delta;
   
                               g_currentMission:addSharedMoney(-delta, "other");
   
                               -- TODO update spray stats
                               --[[g_currentMission.missionStats.sprayUsageTotal = g_currentMission.missionStats.sprayUsageTotal + usage;
                               g_currentMission.missionStats.sprayUsageSession = g_currentMission.missionStats.sprayUsageSession + usage;]]
                           end;
                       else
                           if self.fillLevel > 0 then
                               hasSpray = true;
                               self:setFillLevel(self.fillLevel - usage, self.currentFillType);
                           else
                               -- try to find another attached sprayer
                               local fillType = self.currentFillType;
                               if fillType == Fillable.FILLTYPE_UNKNOWN then
                                   fillType = self:getFirstEnabledFillType();
                               end
                               local sprayerTank = Sprayer.findAttachedSprayerTank(self:getRootAttacherVehicle(), fillType);
                               if sprayerTank ~= nil then
                                   hasSpray = true;
                                   sprayerTank:setFillLevel(sprayerTank:getFillLevel(fillType) - usage, fillType);
                               end
                           end;
                       end;
   
                       if hasSpray then
                           local cuttingAreasSend = {};
                           for _,cuttingArea in pairs(self.cuttingAreas) do
                               if self:getIsAreaActive(cuttingArea) then
                                   local x,_,z = getWorldTranslation(cuttingArea.start);
                                   if g_currentMission:getIsFieldOwnedAtWorldPos(x,z) then
                                       local x1,_,z1 = getWorldTranslation(cuttingArea.width);
                                       local x2,_,z2 = getWorldTranslation(cuttingArea.height);
   
                                       local sqm = math.abs((z1-z)*(x2-x) - (x1-x)*(z2-z)); -- this is the cross product with y=0
   
                                       --Utils.updateSprayArea(x, z, x1, z1, x2, z2);
   
                                       self.lastSprayingArea = self.lastSprayingArea + sqm;
   
                                       table.insert(cuttingAreasSend, {x,z,x1,z1,x2,z2});
                                   else
                                       showFieldNotOwnedWarning = true;
                                   end
                               end;
                           end;
                           if (table.getn(cuttingAreasSend) > 0) then
                               SprayerAreaEvent.runLocally(cuttingAreasSend);
                               g_server:broadcastEvent(SprayerAreaEvent:new(cuttingAreasSend));
                           end;
                       end;
                   end;
               end;
   
               if self.isClient then
                   if not self.spraySoundEnabled and self.spraySound ~= nil and self:getIsActiveForSound() then
                       playSample(self.spraySound, 0, self.spraySoundVolume, 0);
                       self.spraySoundEnabled = true;
                   end;
               end;
   
               for _, node in pairs(self.turnedOnRotationNodes) do
                   rotate(node.node, 0, -dt*node.rotSpeed, 0);
               end
           else
               self.speedViolationTimer = self.speedViolationMaxTime;
           end;
   
           if self.isServer then
               if showFieldNotOwnedWarning ~= self.showFieldNotOwnedWarning then
                   self.showFieldNotOwnedWarning = showFieldNotOwnedWarning;
                   self:raiseDirtyFlags(self.sprayerDirtyFlag);
               end
           end
       end;
   
       if self.isServer and self.isSprayerFilling then
           local delta = 0;
           if self.sprayerFillTrigger ~= nil then
               delta = self.fillLitersPerSecond*dt*0.001;
               delta = self.sprayerFillTrigger:fillSprayer(self, delta);
           end
   
           if delta <= 0 then
               self:setIsSprayerFilling(false);
           end;
       end;	
	end;
end;

Sprayer.updateTick = Utils.appendedFunction(Sprayer.updateTick, FuchsGuellefass.SupdateTick);
 
--------------------
--*****EVENT1*****--
--------------------


SetdeckelAnimationisPlayingEvent = {};
SetdeckelAnimationisPlayingEvent_mt = Class(SetdeckelAnimationisPlayingEvent, Event);

InitEventClass(SetdeckelAnimationisPlayingEvent, "SetdeckelAnimationisPlayingEvent");

function SetdeckelAnimationisPlayingEvent:emptyNew()
    local self = Event:new(SetdeckelAnimationisPlayingEvent_mt);
    self.className="SetdeckelAnimationisPlayingEvent";
    return self;
end;

function SetdeckelAnimationisPlayingEvent:new(vehicle, deckelAnimationisPlaying)
    local self = SetdeckelAnimationisPlayingEvent:emptyNew()
    self.vehicle = vehicle;
	self.deckelAnimationisPlaying = deckelAnimationisPlaying;
    return self;
end;

function SetdeckelAnimationisPlayingEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.vehicle = networkGetObject(id);

	self.deckelAnimationisPlaying = streamReadBool(streamId);
	self.vehicle:setdeckelAnimationisPlaying(self.deckelAnimationisPlaying, true);
	
	if not connection:getIsServer() then
        g_server:broadcastEvent(SetdeckelAnimationisPlayingEvent:new(self.vehicle, self.deckelAnimationisPlaying), nil, connection, self.vehicle);
    end;
end;

function SetdeckelAnimationisPlayingEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.deckelAnimationisPlaying);
end;


function SetdeckelAnimationisPlayingEvent.sendEvent(vehicle, deckelAnimationisPlaying, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetdeckelAnimationisPlayingEvent:new(vehicle, deckelAnimationisPlaying), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetdeckelAnimationisPlayingEvent:new(vehicle, deckelAnimationisPlaying));
		end;
	end;
end;
