SetWindowRotationEvent = {};
SetWindowRotationEvent_mt = Class(SetWindowRotationEvent, Event);
  
InitEventClass(SetWindowRotationEvent, "SetWindowRotationEvent");
  
function SetWindowRotationEvent:emptyNew()
      local self = Event:new(SetWindowRotationEvent_mt);
      self.className="SetWindowRotationEvent";
      return self;
 end;

function SetWindowRotationEvent:new(object, rotationMax14)
      local self = SetWindowRotationEvent:emptyNew()
      self.object = object;
      self.rotationMax14 = rotationMax14;
      return self;
end;
 
function SetWindowRotationEvent:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.rotationMax14 = streamReadBool(streamId);
      self.object = networkGetObject(id);
      self:run(connection);
end;
  
function SetWindowRotationEvent:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteBool(streamId, self.rotationMax14);
end;
 
function SetWindowRotationEvent:run(connection)
      self.object:setRotationMax14(self.rotationMax14, true);
      if not connection:getIsServer() then
          g_server:broadcastEvent(SetWindowRotationEvent:new(self.object, self.rotationMax14), nil, connection, self.object);
      end;
end;