SetRoofRotationEvent = {};
SetRoofRotationEvent_mt = Class(SetRoofRotationEvent, Event);
  
InitEventClass(SetRoofRotationEvent, "SetRoofRotationEvent");
  
function SetRoofRotationEvent:emptyNew()
      local self = Event:new(SetRoofRotationEvent_mt);
      self.className="SetRoofRotationEvent";
      return self;
 end;

function SetRoofRotationEvent:new(object, rotationMax13)
      local self = SetRoofRotationEvent:emptyNew()
      self.object = object;
      self.rotationMax15 = rotationMax15;
      return self;
end;
 
function SetRoofRotationEvent:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.rotationMax15 = streamReadBool(streamId);
      self.object = networkGetObject(id);
      self:run(connection);
end;
  
function SetRoofRotationEvent:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteBool(streamId, self.rotationMax15);
end;
 
function SetRoofRotationEvent:run(connection)
      self.object:setRotationMax15(self.rotationMax15, true);
      if not connection:getIsServer() then
          g_server:broadcastEvent(SetRoofRotationEvent:new(self.object, self.rotationMax15), nil, connection, self.object);
      end;
end;