--
-- InteractiveButtons
-- Specialization for an interactive control button
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v2.0
-- @date  		15/10/10
-- @history:	v1.0 - Initial version
--				v2.0 - converted to ls2011
--

InteractiveButtons = {};

function InteractiveButtons.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(InteractiveControl, specializations);
end;

function InteractiveButtons:load(xmlFile)

	self.count = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.interactiveComponents.buttons#count"), 0);	
	if self.count ~= 0 then	
		for i=1, self.count do	
			local buttonName = string.format("vehicle.interactiveComponents.buttons.button%d", i);	
			local name = Utils.getNoNil(g_i18n:getText(getXMLString(xmlFile, buttonName .. "#name")), "ERROR");
			local mark = Utils.indexToObject(self.components, getXMLString(xmlFile, buttonName .. "#mark"));
			local highlight = getChildAt(mark, 0);
			local size = Utils.getNoNil(getXMLFloat(xmlFile, buttonName .. "#size"), 0.1);
			local event = getXMLString(xmlFile, buttonName .. "#event");
			local onMessage = g_i18n:getText("ic_button_on");
			local offMessage = g_i18n:getText("ic_button_off");
		
			local button = Button:new(nil, highlight, name, mark, size, event, self, onMessage, offMessage);

			table.insert(self.interactiveObjects, button);
		end;
	end;
	
end;

function InteractiveButtons:delete()
end;

function InteractiveButtons:mouseEvent(posX, posY, isDown, isUp, button)
end;

function InteractiveButtons:keyEvent(unicode, sym, modifier, isDown)
end;

function InteractiveButtons:update(dt)	
end;

function InteractiveButtons:draw()
end;



--
-- Button Class
-- Specifies an interactive Button
--
-- SFM-Modding
-- @author  Manuel Leithner
-- @date  25/12/09
--

Button = {};

function Button:new(node, highlight, name, mark, size, event, vehicle, onMessage, offMessage)

	local Button_mt = Class(Button, InteractiveComponentInterface);	
    local instance = InteractiveComponentInterface:new(node, highlight, name, mark, size, onMessage, offMessage, Button_mt);

	instance.vehicle = vehicle;
	instance.event = event;
	
	return instance;	
end;

function Button:delete()
	InteractiveComponentInterface.delete(self);
end;

function Button:mouseEvent(posX, posY, isDown, isUp, button)
	InteractiveComponentInterface.mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function Button:keyEvent(unicode, sym, modifier, isDown)
	InteractiveComponentInterface.keyEvent(self, unicode, sym, modifier, isDown);
end;

function Button:update(dt)
	InteractiveComponentInterface.update(self, dt);
end;

function Button:draw()
	InteractiveComponentInterface.draw(self);
end;

function Button:doAction(dt)
	if self.vehicle ~= nil then
		if self.event == "toggleBeaconLight" then
			if self.vehicle.beaconLightsActive then
				self.vehicle:setBeaconLightsVisibility(false);
			else
				self.vehicle:setBeaconLightsVisibility(true);
			end;
		end;	
		if self.event == "toggleWiper" then 
			if not self.vehicle.isWiperActive then
				enableAnimTrack(self.vehicle.wiperAnimCharSet, 0);
				self.vehicle.isWiperActive = true;
			else
				disableAnimTrack(self.vehicle.wiperAnimCharSet, 0);	
				self.vehicle.isWiperActive = false;				
			end;
		end;
		if self.event == "toggleNewLight1" then
			if self.vehicle.newFrontLight1Active then
				self.vehicle:setNewLightsVisibility(1, false);
				if self.vehicle.newFrontLight2Active then
					if (self.vehicle.newBackLight1Active or self.vehicle.newBackLight2Active) then
						self.vehicle:setLightState(4);
					else
						self.vehicle:setLightState(2);
					end;
				else
					if (self.vehicle.newBackLight1Active or self.vehicle.newBackLight2Active) and self.vehicle.newStandardLightActive then
						self.vehicle:setLightState(5);
					elseif self.vehicle.newBackLight1Active or self.vehicle.newBackLight2Active and not self.vehicle.newStandardLightActive then
						self.vehicle:setLightState(3);
					elseif not self.vehicle.newBackLight1Active and not self.vehicle.newBackLight2Active and self.vehicle.newStandardLightActive then
						self.vehicle:setLightState(1);
					else
						self.vehicle:setLightState(0);
					end;
				end;
			else
				self.vehicle:setNewLightsVisibility(1, true);
				if (self.vehicle.newBackLight1Active or self.vehicle.newBackLight2Active) then
					self.vehicle:setLightState(4);
				else
					self.vehicle:setLightState(2);
				end;
			end;
		end;		
		if self.event == "toggleNewLight2" then
			if self.vehicle.newFrontLight2Active then
				self.vehicle:setNewLightsVisibility(2, false);
				if self.vehicle.newFrontLight1Active then
					if (self.vehicle.newBackLight1Active or self.vehicle.newBackLight2Active) then
						self.vehicle:setLightState(4);
					else
						self.vehicle:setLightState(2);
					end;
				else
					if (self.vehicle.newBackLight1Active or self.vehicle.newBackLight2Active) and self.vehicle.newStandardLightActive then
						self.vehicle:setLightState(5);
					elseif self.vehicle.newBackLight1Active or self.vehicle.newBackLight2Active and not self.vehicle.newStandardLightActive then
						self.vehicle:setLightState(3);
					elseif not self.vehicle.newBackLight1Active and not self.vehicle.newBackLight2Active and self.vehicle.newStandardLightActive then
						self.vehicle:setLightState(1);
					else
						self.vehicle:setLightState(0);
					end;
				end;
			else
				self.vehicle:setNewLightsVisibility(2, true);
				if (self.vehicle.newBackLight1Active or self.vehicle.newBackLight2Active) then
					self.vehicle:setLightState(4);
				else
					self.vehicle:setLightState(2);
				end;
			end;
		end;	
		if self.event == "toggleNewLight3" then
			if self.vehicle.newBackLight1Active then
				self.vehicle:setNewLightsVisibility(3, false);
				if self.vehicle.newBackLight2Active then
					if self.vehicle.newFrontLight1Active or self.vehicle.newFrontLight2Active then
						self.vehicle:setLightState(4);
					elseif not self.vehicle.newFrontLight1Active and not self.vehicle.newFrontLight2Active and self.vehicle.newStandardLightActive then 
						self.vehicle:setLightState(5);
					else
						self.vehicle:setLightState(0);
					end;
				else
					if self.vehicle.newFrontLight1Active or self.vehicle.newFrontLight2Active then
						self.vehicle:setLightState(2);
					elseif not self.vehicle.newFrontLight1Active and not self.vehicle.newFrontLight2Active and self.vehicle.newStandardLightActive then 
						self.vehicle:setLightState(1);
					else
						self.vehicle:setLightState(0);
					end;
				end;
			else
				self.vehicle:setNewLightsVisibility(3, true);
				if self.vehicle.newFrontLight1Active or self.vehicle.newFrontLight2Active then
					self.vehicle:setLightState(4);
				elseif not self.vehicle.newFrontLight1Active and not self.vehicle.newFrontLight2Active and self.vehicle.newStandardLightActive then 
					self.vehicle:setLightState(5);
				else
					self.vehicle:setLightState(3);
				end;

			end;
		end;	
		if self.event == "toggleNewLight4" then
			if self.vehicle.newStandardLightActive then
				self.vehicle:setNewLightsVisibility(4, false);
				if (self.vehicle.newFrontLight1Active or self.vehicle.newFrontLight2Active) and (self.vehicle.newBackLight1Active or self.vehicle.newBackLight2Active) then
					self.vehicle:setLightState(4);
				elseif self.vehicle.newBackLight1Active or self.vehicle.newBackLight2Active then
					self.vehicle:setLightState(3);
				elseif self.vehicle.newFrontLight1Active or self.vehicle.newFrontLight2Active then
					self.vehicle:setLightState(2);
				else
					self.vehicle:setLightState(0);
				end;
			else
				self.vehicle:setNewLightsVisibility(4, true);
				if (self.vehicle.newFrontLight1Active or self.vehicle.newFrontLight2Active) and (self.vehicle.newBackLight1Active or self.vehicle.newBackLight2Active) then
					self.vehicle:setLightState(4);
				elseif self.vehicle.newBackLight1Active or self.vehicle.newBackLight2Active then
					self.vehicle:setLightState(5);
				elseif self.vehicle.newFrontLight1Active or self.vehicle.newFrontLight2Active then
					self.vehicle:setLightState(2);
				else
					self.vehicle:setLightState(1);
				end;
			end;
		end;	
		if self.event == "toggleNewLight5" then
			if self.vehicle.newBackLight2Active then
				self.vehicle:setNewLightsVisibility(5, false);
				if self.vehicle.newBackLight2Active then
					if self.vehicle.newFrontLight1Active or self.vehicle.newFrontLight2Active then
						self.vehicle:setLightState(4);
					elseif not self.vehicle.newFrontLight1Active and not self.vehicle.newFrontLight2Active and self.vehicle.newStandardLightActive then 
						self.vehicle:setLightState(5);
					else
						self.vehicle:setLightState(0);
					end;
				else
					if self.vehicle.newFrontLight1Active or self.vehicle.newFrontLight2Active then
						self.vehicle:setLightState(2);
					elseif not self.vehicle.newFrontLight1Active and not self.vehicle.newFrontLight2Active and self.vehicle.newStandardLightActive then 
						self.vehicle:setLightState(1);
					else
						self.vehicle:setLightState(0);
					end;
				end;
			else
				self.vehicle:setNewLightsVisibility(5, true);
				if self.vehicle.newFrontLight1Active or self.vehicle.newFrontLight2Active then
					self.vehicle:setLightState(4);
				elseif not self.vehicle.newFrontLight1Active and not self.vehicle.newFrontLight2Active and self.vehicle.newStandardLightActive then 
					self.vehicle:setLightState(5);
				else
					self.vehicle:setLightState(3);
				end;
			end;
		end;
		if self.event == "lowerBack" then
			if self.vehicle.lowerBack then
				self.vehicle:setJointMoveDown(1, false);
				self.vehicle.lowerBack = false;
			else
				self.vehicle:setJointMoveDown(1, true);
				self.vehicle.lowerBack = true
			end;
		end;
		if self.event == "lowerFront" then
			if self.vehicle.lowerFront then
				self.vehicle:setJointMoveDown(2, false);
				self.vehicle.lowerFront = false;
			else
				self.vehicle:setJointMoveDown(2, true);
				self.vehicle.lowerFront = true;
			end;
		end;
	end;
end;

function Button:onEnter(dt)
	InteractiveComponentInterface.onEnter(self, dt);
end;

function Button:onExit(dt)
	InteractiveComponentInterface.onExit(self, dt);
end;

function Button:setActive()
	InteractiveComponentInterface.setActive(self, isActive);
end;

function Button:setVisible(isVisible)
	InteractiveComponentInterface.setVisible(self, isVisible);
end;