-- Autor: ?? --
-- Edit: Rockstar94 --


handBrake = {};

function handBrake.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function handBrake:load(xmlFile)
	self.setHandBrakeState = SpecializationUtil.callSpecializationsFunction("setHandBrakeState");
	self.handBrakeHud = Overlay:new("hBOverlay", Utils.getFilename("scripts/reczny.dds", self.baseDirectory), 0.945, 0.14, 0.070, 0.075);
	
	self.handbrake = false;
    
	handbrakeSoundFile = Utils.getFilename("Dzwieki/handbrake.wav", self.baseDirectory);
    self.handbrakeSoundId = createSample("handbrakeSound");
    loadSample(self.handbrakeSoundId, handbrakeSoundFile, false);
    self.handbrakePlaying = false;
    
	self.brakereleasePlaying = false;
    self.BreakForceVal = 10000/self.motor.brakeForce;

    self.HandBrakeTurnOff = false;
	
	self.isSelectable = true;
	self.isSelected = true;	
end;

function handBrake:delete()
end;

function handBrake:mouseEvent(posX, posY, isDown, isUp, button)
end;

function handBrake:keyEvent(unicode, sym, modifier, isDown)
	if self.isClient then
		if self:getIsActiveForInput(self.needsSelection) and not self:hasInputConflictWithSelection() then	
			if isDown and sym == Input.KEY_space then
				self:setHandBrakeState(not self.handbrake);
				if self.handbrake and self:getIsActiveForSound() then
					playSample(self.handbrakeSoundId,1,1,0);
				end;
			end;
		end;
	end;
end;

function handBrake:updateTick(dt)
   if self.isServer then
        if self.handbrake then
            if self.isServer then
                for k,wheel in pairs(self.wheels) do
                    setWheelShapeProps(wheel.node, wheel.wheelShape, 0, 999, 0);
                end;
            end;
        elseif not self.handbrake and self.HandBrakeTurnOff then
            if self.isServer then
                for k,wheel in pairs(self.wheels) do
                    setWheelShapeProps(wheel.node, wheel.wheelShape, 0, 0, 0);
                end;
            end;
            self.HandBrakeTurnOff = false;
        end;
    end;
end;

function handBrake:update(dt)
	if self.isClient then
		if self.isMotorStarted then        
			if Input.isKeyPressed(Input.KEY_s) then
					if not self.braking then
						self.braking = true;
					end;
					self.brakereleasePlaying = false;				
			else
				self.brakePlaying = false;
				self.braking = false;
			end;
		end;
	end;
end;

function handBrake:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then		
		local handbrake = getXMLBool(xmlFile, key.."#handbrake");
		
		if handbrake ~= nil then
			self.handbrake = handbrake;
		end;
	end;
    return BaseMission.VEHICLE_LOAD_OK;
end;

function handBrake:getSaveAttributesAndNodes(nodeIdent)
	if self.handbrake then
		handbrake = "true";
	else
		handbrake = "false";
	end;
	
	local attributes = string.format('handbrake="%s"',handbrake);
    return attributes,nodes;
end;

function handBrake:draw()
	if self.isClient then
		if self.isEntered then	
			if self.handbrake then
				if Input.isKeyPressed(Input.KEY_w) or Input.isKeyPressed(Input.KEY_s) then
					self.handBrakeHud:render();
				end;
			self.handBrakeHud:render();
			end;
			if self:getIsActiveForInput(self.needsSelection) and not self:hasInputConflictWithSelection() then	
				g_currentMission:addHelpButtonText(g_i18n:getText("HB_c360"), InputBinding.HB);
			end;
		end;
		
		if self.isEntered then	
			if self.isMotorStarted then
				if self.handbrake then
					if self:getIsActiveForInput(self.needsSelection) and not self:hasInputConflictWithSelection() then
						if Input.isKeyPressed(Input.KEY_w) or Input.isKeyPressed(Input.KEY_s) then
							g_currentMission:showBlinkingWarning(g_i18n:getText("handbrakeRELEASE"), 1000);
						end;
					end;
					if not self:getIsActiveForInput(self.needsSelection) or self:hasInputConflictWithSelection() then
						if Input.isKeyPressed(Input.KEY_w) or Input.isKeyPressed(Input.KEY_s) then
							g_currentMission:showBlinkingWarning(g_i18n:getText("handbrakeRELEASE_selected"), 2000);
						end;
					end;
				end;
			end;
		end;
	end;
end;

function handBrake:onLeave()
end;

function handBrake:setHandBrakeState(state, noEventSend)
    self.handbrake = state;
    self.HandBrakeTurnOff = state;
end;