-- by modelleicher
-- www.schwabenmodding.bplaced.net
-- LUA fuer die komplette Animation einer Vorderachse beim MB-Trac

tracFrontAxle = {};

function tracFrontAxle.prerequisitesPresent(specializations)
    return true;
end;

function tracFrontAxle:load(xmlFile)
	self.zyl = {}; -- Zylinder
	self.zyl.leftZyl = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tracFrontAchse.Lenkzylinder#linksZylIndex"));
	self.zyl.leftStempel =	Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tracFrontAchse.Lenkzylinder#linksStempelIndex"));
	self.zyl.rightZyl = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tracFrontAchse.Lenkzylinder#rechtsZylIndex"));
	self.zyl.rightStempel = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tracFrontAchse.Lenkzylinder#rechtsStempelIndex"));
	
	self.sst = {}; -- Spurstange
	self.sst.sstIndex = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tracFrontAchse.Spurstange#index"));
	self.sst.scaleRefPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tracFrontAchse.Spurstange#scaleRefPunkt"));
	self.sst.dirRefPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tracFrontAchse.Spurstange#directionRefPunkt"));
	self.sst.doScaleBool = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.tracFrontAchse.Spurstange#doScaleBool"), true);
	if self.sst.doScaleBool == true then
		ax, ay, az = getWorldTranslation(self.sst.sstIndex);
		bx, by, bz = getWorldTranslation(self.sst.scaleRefPoint);
		self.sst.scaleDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);	
	end;
	
	self.qs = {}; -- Querstrebe
	self.qs.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tracFrontAchse.Querstrebe#index"));
	self.qs.scaleRefPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tracFrontAchse.Querstrebe#scaleRefPunkt"));
	self.qs.dirRefPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tracFrontAchse.Querstrebe#directionRefPunkt"));
	self.qs.doScaleBool = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.tracFrontAchse.Querstrebe#doScaleBool"), true);
	if self.qs.doScaleBool == true then
		ax2, ay2, az2 = getWorldTranslation(self.qs.index);
		bx2, by2, bz2 = getWorldTranslation(self.qs.scaleRefPoint);
		self.qs.scaleDistance = Utils.vector3Length(ax2-bx2, ay2-by2, az2-bz2);	
	end;
	
	self.std = {}; --Stodmpfer
	self.std.leftZyl = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tracFrontAchse.Stossdaempfer#linksZylIndex"));
	self.std.leftStempel = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tracFrontAchse.Stossdaempfer#linksStempelIndex"));
	self.std.rightZyl = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tracFrontAchse.Stossdaempfer#rechtsZylIndex"));
	self.std.rightStempel = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tracFrontAchse.Stossdaempfer#rechtsStempelIndex"));
	
	self.fl = {}; -- Feder Links
	self.fl.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tracFrontAchse.Federn.Links#index"));
	self.fl.scaleRefPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tracFrontAchse.Federn.Links#scaleRefPunkt"));
	self.fl.dirRefPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tracFrontAchse.Federn.Links#directionRefPunkt"));
	local flax, flay, flaz = getWorldTranslation(self.fl.index);
	local flbx, flby, flbz = getWorldTranslation(self.fl.scaleRefPoint);
	self.fl.scaleDistance = Utils.vector3Length(flax-flbx, flay-flby, flaz-flbz);	
	
	self.fr = {}; -- Feder Rechts
	self.fr.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tracFrontAchse.Federn.Rechts#index"));
	self.fr.scaleRefPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tracFrontAchse.Federn.Rechts#scaleRefPunkt"));
	self.fr.dirRefPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tracFrontAchse.Federn.Rechts#directionRefPunkt"));
	local frax, fray, fraz = getWorldTranslation(self.fr.index);
	local frbx, frby, frbz = getWorldTranslation(self.fr.scaleRefPoint);
	self.fr.scaleDistance = Utils.vector3Length(frax-frbx, fray-frby, fraz-frbz);	

end;
function tracFrontAxle:delete()
end;
function tracFrontAxle:mouseEvent(posX, posY, isDown, isUp, button)
end;
function tracFrontAxle:keyEvent(unicode, sym, modifier, isDown)
end;

function tracFrontAxle:update(dt)
	if self:getIsActive() then
		-- Direction des linken Zylinders
		if self.zyl.leftZyl ~= nil and self.zyl.rightZyl ~= nil then
			local ax, ay, az = getWorldTranslation(self.zyl.leftZyl);
			local bx, by, bz = getWorldTranslation(self.zyl.leftStempel);
			x, y, z = worldDirectionToLocal(getParent(self.zyl.leftZyl), bx-ax, by-ay, bz-az);
			setDirection(self.zyl.leftZyl, x, y, z, 0, 0, 1);
			local ax2, ay2, az2 = getWorldTranslation(self.zyl.leftStempel);
			local bx2, by2, bz2 = getWorldTranslation(self.zyl.leftZyl);
			x2, y2, z2 = worldDirectionToLocal(getParent(self.zyl.leftStempel), bx2-ax2, by2-ay2, bz2-az2);
			setDirection(self.zyl.leftStempel, x2, y2, z2, 0, 0, 1);	
			-- Direction des rechten Zylinders
			local ax3, ay3, az3 = getWorldTranslation(self.zyl.rightZyl);
			local bx3, by3, bz3 = getWorldTranslation(self.zyl.rightStempel);
			x3, y3, z3 = worldDirectionToLocal(getParent(self.zyl.rightZyl), bx3-ax3, by3-ay3, bz3-az3);
			setDirection(self.zyl.rightZyl, x3, y3, z3, 0, 0, 1);
			local ax4, ay4, az4 = getWorldTranslation(self.zyl.rightStempel);
			local bx4, by4, bz4 = getWorldTranslation(self.zyl.rightZyl);
			x4, y4, z4 = worldDirectionToLocal(getParent(self.zyl.rightStempel), bx4-ax4, by4-ay4, bz4-az4);
			setDirection(self.zyl.rightStempel, x4, y4, z4, 0, 0, 1);					
		end;
		
		-- Animation der Spurstange
		if self.sst.sstIndex ~= nil then
			local ax, ay, az = getWorldTranslation(self.sst.sstIndex);
			local bx, by, bz = getWorldTranslation(self.sst.dirRefPoint);
			x, y, z = worldDirectionToLocal(getParent(self.sst.sstIndex), bx-ax, by-ay, bz-az);
			setDirection(self.sst.sstIndex, x, y, z, 0, 0, 1);		
			if self.sst.doScaleBool == true then
				local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
				local scaleX, scaleY, scaleZ = getScale(self.sst.sstIndex);
				local setScaleWert = scaleZ * (distance / self.sst.scaleDistance);
				setScale(self.sst.sstIndex, 1, 1, setScaleWert);
			end;
		end;
		
		-- Animation der Querstrebe
		if self.qs.index ~= nil then
			local ax, ay, az = getWorldTranslation(self.qs.index);
			local bx, by, bz = getWorldTranslation(self.qs.dirRefPoint);
			x, y, z = worldDirectionToLocal(getParent(self.qs.index), bx-ax, by-ay, bz-az);
			setDirection(self.qs.index, x, y, z, 0, 0, 1);			
			if self.qs.doScaleBool == true then
				local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
				local scaleX, scaleY, scaleZ = getScale(self.qs.index);
				local setScaleWert = scaleZ * (distance / self.qs.scaleDistance);
				setScale(self.qs.index, 1, 1, setScaleWert);
			end;
		end;
		
		-- Animation der Stossdaempfer
		if self.std.leftZyl ~= nil and self.std.rightZyl ~= nil then
			local ax, ay, az = getWorldTranslation(self.std.leftZyl);
			local bx, by, bz = getWorldTranslation(self.std.leftStempel);
			x, y, z = worldDirectionToLocal(getParent(self.std.leftZyl), bx-ax, by-ay, bz-az);
			setDirection(self.std.leftZyl, x, y, z, 0, 0, 1);
			local ax2, ay2, az2 = getWorldTranslation(self.std.leftStempel);
			local bx2, by2, bz2 = getWorldTranslation(self.std.leftZyl);
			x2, y2, z2 = worldDirectionToLocal(getParent(self.std.leftStempel), bx2-ax2, by2-ay2, bz2-az2);
			setDirection(self.std.leftStempel, x2, y2, z2, 0, 0, 1);	
			-- Direction des rechten Zylinders
			local ax3, ay3, az3 = getWorldTranslation(self.std.rightZyl);
			local bx3, by3, bz3 = getWorldTranslation(self.std.rightStempel);
			x3, y3, z3 = worldDirectionToLocal(getParent(self.std.rightZyl), bx3-ax3, by3-ay3, bz3-az3);
			setDirection(self.std.rightZyl, x3, y3, z3, 0, 0, 1);
			local ax4, ay4, az4 = getWorldTranslation(self.std.rightStempel);
			local bx4, by4, bz4 = getWorldTranslation(self.std.rightZyl);
			x4, y4, z4 = worldDirectionToLocal(getParent(self.std.rightStempel), bx4-ax4, by4-ay4, bz4-az4);
			setDirection(self.std.rightStempel, x4, y4, z4, 0, 0, 1);					
		end
		
		-- Animation der Federn
		if self.fl.index ~= nil then
			local ax, ay, az = getWorldTranslation(self.fl.index);
			local bx, by, bz = getWorldTranslation(self.fl.dirRefPoint);
			x, y, z = worldDirectionToLocal(getParent(self.fl.index), bx-ax, by-ay, bz-az);
			setDirection(self.fl.index, x, y, z, 0, 0, 1);			
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			local scaleX, scaleY, scaleZ = getScale(self.fl.index);
			local setScaleWert = scaleZ * (distance / self.fl.scaleDistance);
			setScale(self.fl.index, 1, 1, setScaleWert);	
		end;
		if self.fr.index ~= nil then
			local ax, ay, az = getWorldTranslation(self.fr.index);
			local bx, by, bz = getWorldTranslation(self.fr.dirRefPoint);
			x, y, z = worldDirectionToLocal(getParent(self.fr.index), bx-ax, by-ay, bz-az);
			setDirection(self.fr.index, x, y, z, 0, 0, 1);			
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			local scaleX, scaleY, scaleZ = getScale(self.fr.index);
			local setScaleWert = scaleZ * (distance / self.fr.scaleDistance);
			setScale(self.fr.index, 1, 1, setScaleWert);	
		end;	
	end;
end;

function tracFrontAxle:draw()	
end;
