-- by modelleicher
-- www.schwabenmodding.bplaced.net

Armaturen = {};

function Armaturen.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Armaturen:load(xmlFile)

	-- Uhr / clock
	self.uhrZeigerKlein = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Armaturen.Uhr#zeigerKleinIndex"));
	self.uhrZeigerGross = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Armaturen.Uhr#zeigerGrossIndex"));

	-- Tachozeiger / Speedometer animation
	self.tachoZeiger = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Armaturen.TachoZeiger#zeigerIndex"));
	self.tachoZeigerMultiplicator = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.Armaturen.TachoZeiger#multiplicator"), 10);
	self.tachoZeigerMaxRotation = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.Armaturen.TachoZeiger#maxRotation"), 245);
	
	-- Temperaturzeiger / temperature Display animation
	self.temperaturZeiger = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Armaturen.TemperaturZeiger#zeigerIndex"));
	self.temperaturZeigerMaxRot = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.Armaturen.TemperaturZeiger#maxRotation"), 50);
	self.tempCnt = 0;
	
	-- Tankzeiger / fuel gauge 
	self.tankZeiger = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Armaturen.TankZeiger#zeigerIndex"));
	self.tankZeigerMaxRot = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.Armaturen.TankZeiger#maxRotation"), 50);
	
	-- Tankleuchte leuchtet auf sobald im Tank zu wenig drin ist / warning light if fuel level low
	self.tankLeuchte = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Armaturen.TankLeuchte#index"));
	self.tankMinWarnLevel = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.Armaturen.TankLeuchte#minWarnLevel"));
	setVisibility(self.tankLeuchte, false);

	-- Zustzliche Blinkleuchten in den Armaturen bei angehngten Anhngern / additional lights for turninglights at the dashboard if trailers attached
	self.blinkerLeuchte1L = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Armaturen.BlinkerLeuchten#leuchte1L"));
	self.blinkerLeuchte1R = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Armaturen.BlinkerLeuchten#leuchte1R"));
	self.blinkerLeuchte2L = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Armaturen.BlinkerLeuchten#leuchte2L"));
	self.blinkerLeuchte2R = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Armaturen.BlinkerLeuchten#leuchte2R"));
	self.hasAttachedTrailers = 0;
	setVisibility(self.blinkerLeuchte1L, false);
	setVisibility(self.blinkerLeuchte2L, false);
	setVisibility(self.blinkerLeuchte1R, false);
	setVisibility(self.blinkerLeuchte2R, false);
	
	-- Ladekontrollleuchte / Batterie load light
	self.ladeLeuchte = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Armaturen.LadeKontrollLeuchte#index"));
	setVisibility(self.ladeLeuchte, false);
	self.ladeLeuchteOn = 0;
	self.ladeTimer = 50;
	
end;
function Armaturen:delete()
end;
function Armaturen:mouseEvent(posX, posY, isDown, isUp, button)
end;
function Armaturen:keyEvent(unicode, sym, modifier, isDown)
end;

function Armaturen:updateTick(dt)
	-- Zustzliche Blinkleuchten in den Armaturen bei angehngten Anhngern / additional lights for turninglights at the dashboard if trailers attached
	if table.getn(self.attachedImplements) > 0 or self.hasAttachedTrailers > 0 then
		self.hasAttachedTrailers = 0;
		for i=1, table.getn(self.attachedImplements) do  
			if self.attachedImplements[i].object.lastFillDelta ~= nil then -- "catch" all trailers 
				self.hasAttachedTrailers = 	self.hasAttachedTrailers +1;
			elseif self.attachedImplements[i].object.isSprayerFilling ~= nil and self.attachedImplements[i].object.wheels[1] ~= nil then -- "catch" manure and dung spreader with wheels --> "trailers", too
				self.hasAttachedTrailers = 	self.hasAttachedTrailers +1;
			end;
			if table.getn(self.attachedImplements[i].object.attachedImplements) > 0 then -- maybe the trailer has also attached a trailer.. 
				for r=1, table.getn(self.attachedImplements[i].object.attachedImplements) do
					if self.attachedImplements[i].object.attachedImplements[r].object.lastFillDelta ~= nil then -- "catch" attached trailer at the trailer here
						self.hasAttachedTrailers = 	self.hasAttachedTrailers +1;
					end;
				end;
			end;
		end;
		if self.hasAttachedTrailers == 0 then
			setVisibility(self.blinkerLeuchte1L, false);
			setVisibility(self.blinkerLeuchte2L, false);
			setVisibility(self.blinkerLeuchte1R, false);
			setVisibility(self.blinkerLeuchte2R, false);
		elseif self.hasAttachedTrailers == 1 then
			setVisibility(self.blinkerLeuchte1L, true);
			setVisibility(self.blinkerLeuchte2L, false);
			setVisibility(self.blinkerLeuchte1R, true);
			setVisibility(self.blinkerLeuchte2R, false);			
		elseif self.hasAttachedTrailers == 2 then
			setVisibility(self.blinkerLeuchte1L, true);
			setVisibility(self.blinkerLeuchte2L, true);	
			setVisibility(self.blinkerLeuchte1R, true);
			setVisibility(self.blinkerLeuchte2R, true);			
		end;
	end;
end;
function Armaturen:update(dt)
	if self:getIsActive() then
		-- Uhr / clock
		local clockTime = g_currentMission.environment.dayTime;
		local gr = clockTime / 10000;
		local kl = clockTime / 120000;
		setRotation(self.uhrZeigerKlein, 0, math.rad(-kl), 0);
		setRotation(self.uhrZeigerGross, 0, math.rad(-gr), 0);
		
		if self.isMotorStarted then
			-- Ladekontrollleuchte / Batterie load light
			if self.ladeLeuchteOn == 1 then
				setVisibility(self.ladeLeuchte, true);
				if self.movingDirection ~= 0 then
					self.timerTrue = true;
				end;
				if self.timerTrue then
					self.ladeTimer = math.max(self.ladeTimer - 0.1, 0);
				end;
				if self.ladeTimer == 0 then
					setVisibility(self.ladeLeuchte, false);
					self.timerTrue = nil;
					self.ladeLeuchteOn = 0;
					self.ladeTimer = 50;
				end;
			end;
			
						
			-- Tachozeiger / speedometer animation
			self.kmhMath = math.min(100, math.max(0, self.lastSpeed*self.speedDisplayScale*3600));
			local zeigerRotation = self.kmhMath * self.tachoZeigerMultiplicator;
			if zeigerRotation <= self.tachoZeigerMaxRotation then
				setRotation(self.tachoZeiger, 0, -Utils.degToRad(zeigerRotation), 0);
			else
				setRotation(self.tachoZeiger, 0, -Utils.degToRad(self.tachoZeigerMaxRotation), 0);	
			end;
			
			-- Temperaturanzeiger / temperature display animation und / and berechnung / calculation
			if self.tempCnt < 3000 then
				setRotation(self.temperaturZeiger, 0, Utils.degToRad(-(self.temperaturZeigerMaxRot/10000)*self.tempCnt), 0);
				self.tempCnt = self.tempCnt + 0.5;
			elseif self.tempCnt > 3000 and self.tempCnt < 6000 then
				setRotation(self.temperaturZeiger, 0, Utils.degToRad(-(self.temperaturZeigerMaxRot/10000)*self.tempCnt), 0);
				self.tempCnt = math.min(self.tempCnt + 0.2, 10000);			
			else
				setRotation(self.temperaturZeiger, 0, Utils.degToRad(-(self.temperaturZeigerMaxRot/10000)*self.tempCnt), 0);
				self.tempCnt = math.min(self.tempCnt + 0.05, 10000);
			end;
		
		end;
	else
		self.tempCnt = math.max(self.tempCnt - 0.08, 0);
	end;
end;
function Armaturen:draw()
end;

function Armaturen:onEnter()
	self.ladeLeuchteOn = 1;
end;
function Armaturen:onLeave()
	self.ladeLeuchteOn = 0;
end;

