-- WheelDirtSpecialization
--
-- @ Autor  Tobias F. (John Deere 6930 @ 1. Ls-Modschmiede http://landwirtschaftssimulator-mods.de/)
-- @ Last Edit  28/07/2009
-- @Edited 11/11/2013
WheelDirtSpecialization = {};

if BaseMission.wheelDirt == nil then
	BaseMission.wheelDirt = {};
end;

function WheelDirtSpecialization.prerequisitesPresent(specializations)
    return true;
end;

function WheelDirtSpecialization:load(xmlFile)
	self.DirtWheels = {};
    local i = 0;
    while true do
        local namei = string.format("vehicle.DirtWheels.DirtWheel(%d)", i);
		local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, namei .. "#index"));
		local dirtFileDry = getXMLString(xmlFile, namei .. "#dirtFileDry");
		local dirtFileRain = getXMLString(xmlFile, namei .. "#dirtFileRain");
		if (nodei and dirtFileRain and dirtFileDry) == nil then
			break;
		end; 
		self.DirtWheels[i] = {}
		self.DirtWheels[i].ps = {}
        Utils.loadParticleSystem(xmlFile, self.DirtWheels[i].ps, namei, nodei, false, nil, self.baseDirectory);
		self.DirtWheels[i].isActive = Utils.getNoNil(getXMLBool(xmlFile, namei .. "#isActive"), true);
		self.DirtWheels[i].node = nodei;
		self.DirtWheels[i].dirtFileDry = dirtFileDry;
		self.DirtWheels[i].dirtFileRain = dirtFileRain;
		self.DirtWheels[i].distance = Utils.getNoNil(getXMLString(xmlFile, namei .. "#distance"), 0.1);
		self.DirtWheels[i].timeOnDirtGround = 0;
		self.DirtWheels[i].createDirt = false;
		self.DirtWheels[i].LastCreatedGround = nil;
		i = i+1;
    end;
	if g_currentMission.wheelDirt == nil then
		g_currentMission.wheelDirt = {};
	end;
end;

function WheelDirtSpecialization:delete()
	for k, dirtWheel in pairs(self.DirtWheels) do
		Utils.deleteParticleSystem(dirtWheel.ps);
    end;
end;

function WheelDirtSpecialization:mouseEvent(posX, posY, isDown, isUp, button)
end;

function WheelDirtSpecialization:keyEvent(unicode, sym, modifier, isDown)
end;


function WheelDirtSpecialization:update(dt)
	if self:getIsActive() then
		for k, dirtWheel in pairs(self.DirtWheels) do
			-- checks if node on terrainDetail
			local x,y,z = getWorldTranslation(dirtWheel.node);
			local cultivatorChannel = Utils.getDensity(g_currentMission.terrainDetailId, g_currentMission.cultivatorChannel, x, z, x-0.01, z-0.01, x+0.01, z+0.01);
			local ploughChannel = Utils.getDensity(g_currentMission.terrainDetailId, g_currentMission.ploughChannel, x, z, x-0.01, z-0.01, x+0.01, z+0.01);
			local sowingChannel = Utils.getDensity(g_currentMission.terrainDetailId, g_currentMission.sowingChannel, x, z, x-0.01, z-0.01, x+0.01, z+0.01);
			if cultivatorChannel > 0 or ploughChannel > 0 or sowingChannel > 0 then
				if self.movingDirection ~= 0 then
					if dirtWheel.timeOnDirtGround <= 8000 then
						if sowingChannel > 0 and g_currentMission.environment.lastRainScale > 0.1 and g_currentMission.environment.timeSinceLastRain < 30 then
							dirtWheel.timeOnDirtGround = dirtWheel.timeOnDirtGround+self.lastSpeed*900;
						else
							dirtWheel.timeOnDirtGround = dirtWheel.timeOnDirtGround+self.lastSpeed*1800;
						end;
					end;
					if self.lastSpeed*3600 > 28 and (ploughChannel or cultivatorChannel) > 0 and not (g_currentMission.environment.lastRainScale > 0.1 and g_currentMission.environment.timeSinceLastRain < 30) then
						Utils.setEmittingState(dirtWheel.ps, true);
					else
						Utils.setEmittingState(dirtWheel.ps, false);
					end;
				end;		
			else
				if dirtWheel.timeOnDirtGround > 0 then
					if self.movingDirection ~= 0 then
						if dirtWheel.timeOnDirtGround >= 2000 then
							if self.lastSpeed*3600 > 7 then
								if dirtWheel.LastCreatedGround == nil then
									dirtWheel.createDirt = true;
								else
									local nearestDistance = 0.8;
									if self.lastSpeed*3600 > 10 then
										nearestDistance = 0.65;
									elseif self.lastSpeed*3600 > 15 then
										nearestDistance = 0.8;
									elseif self.lastSpeed*3600 > 20 then
										nearestDistance = 1.0;
									end;
									local px, py, pz = getWorldTranslation(dirtWheel.node);
									local vx, vy, vz = getWorldTranslation(dirtWheel.LastCreatedGround);
									dirtWheel.distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
									if dirtWheel.distance > nearestDistance then
										dirtWheel.createDirt = true;
									end;
								end;
								Utils.setEmittingState(dirtWheel.ps, true);
							end;
						end;
						dirtWheel.timeOnDirtGround = dirtWheel.timeOnDirtGround-self.lastSpeed*3600;
					else
						Utils.setEmittingState(dirtWheel.ps, false);
					end;
				end;
				if dirtWheel.timeOnDirtGround <= 0 then
					dirtWheel.timeOnDirtGround = 0;
					Utils.setEmittingState(dirtWheel.ps, false);
				end;
				Utils.setEmittingState(dirtWheel.ps, false);
			end;
			if dirtWheel.createDirt then
				local i3dPath = nil;
				if g_currentMission.environment.lastRainScale > 0.1 and g_currentMission.environment.timeSinceLastRain < 30 then
					i3dPath = dirtWheel.dirtFileRain;
				else
					i3dPath = dirtWheel.dirtFileDry;
				end;
				local GroundId
				if table.getn(g_currentMission.wheelDirt) < 400 then
					local GroundRoot = Utils.loadSharedI3DFile(i3dPath, self.baseDirectory);
					GroundId = getChildAt(GroundRoot, 0);
					setRigidBodyType(GroundId, "None");
					link(getRootNode(), GroundId);
					delete(GroundRoot);
				else
					GroundId = g_currentMission.wheelDirt[1].id;
					table.remove(g_currentMission.wheelDirt, 1);
					if GroundId == nil then
						break;
					end;
					link(getRootNode(), GroundId);
				end;
				local x,y,z = getWorldRotation(dirtWheel.node);
				setRotation(GroundId, x,y,z);
				local x,y,z = getWorldTranslation(dirtWheel.node);
				setTranslation(GroundId, x,y,z);
				
				local Ground = {};
				Ground.id = GroundId;
				
				table.insert(g_currentMission.wheelDirt, Ground)
				
				dirtWheel.LastCreatedGround = GroundId;
				dirtWheel.createDirt = false; 
			end;
		end;
	end;
end;

function WheelDirtSpecialization:draw()
end;