--
-- IHC 1455 XL
-- Spezialization um Hilfe ein- bzw. ausblenden zu knnen
-- 
--
-- Author  Friedrich L.  -  Skullman
-- Date 18. Dezember 2010
-- Web www.modding-society.de
--
-- Copyright (c) Friedrich L. - All Rights Reserved.
--

ShowHelp = {};

function ShowHelp.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function ShowHelp:load(xmlFile)
	self.showHelp = false;
end;

function ShowHelp:delete()
end;

function ShowHelp:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ShowHelp:keyEvent(unicode, sym, modifier, isDown)
end;

function ShowHelp:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.TOGGLE_SHOW_HELP) then
			self.showHelp = not self.showHelp;
		end;
	end;
end;



function ShowHelp:updateTick(dt)
end;


function ShowHelp:draw()
	if not self.showHelp then
		setTextColor(1,0.847,0,1);
		renderText(0.78, 0.3, 0.022, InputBinding.getKeyNamesOfDigitalAction(InputBinding.TOGGLE_SHOW_HELP)..": Info Ein");
	 else
		-- Koordinaten sind aus der F930.lua - Author leider unbekannt
		renderText(0.78, 0.3150, 0.022, InputBinding.getKeyNamesOfDigitalAction(InputBinding.TOGGLE_SHOW_HELP)..": Info Aus");
		renderText(0.76, 0.72, 0.023, "- MB SK Info -");
		renderText(0.76, 0.66, 0.018, InputBinding.getKeyNamesOfDigitalAction(InputBinding.TOGGLE_LIGHTS)..": Licht");
		renderText(0.76, 0.64, 0.018, InputBinding.getKeyNamesOfDigitalAction(InputBinding.anti)..": Arbeitslicht");
		renderText(0.76, 0.62, 0.018, InputBinding.getKeyNamesOfDigitalAction(InputBinding.backwork)..": Such-Scheinwerfer");
		renderText(0.76, 0.60, 0.018, InputBinding.getKeyNamesOfDigitalAction(InputBinding.Allrad3800)..": Allrad");
		--renderText(0.76, 0.57, 0.018, "");
		renderText(0.76, 0.56, 0.018, InputBinding.getKeyNamesOfDigitalAction(InputBinding.grut)..": Kranfuehrer ein/aus");
		renderText(0.76, 0.54, 0.018, InputBinding.getKeyNamesOfDigitalAction(InputBinding.SETMOVINGTOOLSPEEDUP)..": Geschwindigkeit Kran erhoehen");
		renderText(0.76, 0.52, 0.018, InputBinding.getKeyNamesOfDigitalAction(InputBinding.SETMOVINGTOOLSPEEDDOWN)..": Geschwindigkeit Kran verringern");
		renderText(0.76, 0.50, 0.018, "Taste 5: Hoch Schalten");
		renderText(0.76, 0.48, 0.018, "Taste 6: Runter Schalten");
		renderText(0.76, 0.46, 0.018, "Taste K: SuchLicht Links schwenken");
		renderText(0.76, 0.44, 0.018, "Taste L: SuchLicht Rechts schwenken");
		--renderText(0.76, 0.41, 0.018, "");
		renderText(0.76, 0.40, 0.018, InputBinding.getKeyNamesOfDigitalAction(InputBinding.BEL3LEFT)..": Blinker links");
		renderText(0.76, 0.38, 0.018, InputBinding.getKeyNamesOfDigitalAction(InputBinding.BEL3WARN)..": Warnblinker");
		renderText(0.76, 0.36, 0.018, InputBinding.getKeyNamesOfDigitalAction(InputBinding.BEL3RIGHT)..": Blinker rechts");
		renderText(0.76, 0.34, 0.018, InputBinding.getKeyNamesOfDigitalAction(InputBinding.MANUAL_IGNITION_KEY)..": Motor Starten");
		--renderText(0.76, 0.49, 0.018, "");  
	end;
end;  

function ShowHelp:onLeave()
	self.showHelp = false;
end;




