﻿--
-- MMSuchlicht
--
-- schwenkbarer Scheinwerfer
--
-- by MMAgrarservice
--

MMSuchlicht = {}

function MMSuchlicht.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function MMSuchlicht:load(xmlFile)  
	local rotationNode1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotation1#index"));
	if rotationNode1 ~= nil then
        	self.rotation1 = {};
        	self.rotation1.node = rotationNode1;
        	local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation1#minRot"));
        	self.rotation1.minRot = {};
        	self.rotation1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        	self.rotation1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        	self.rotation1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        	x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation1#maxRot"));
        	self.rotation1.maxRot = {};
        	self.rotation1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        	self.rotation1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        	self.rotation1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        	self.rotation1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation1#rotTime"), 2)*1000;
        	self.rotation1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation1#touchRotLimit"), 10));
	end;
	local rotationNode2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotation2#index"));
	if rotationNode2 ~= nil then
        	self.rotation2 = {};
        	self.rotation2.node = rotationNode2;
        	local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation2#minRot"));
        	self.rotation2.minRot = {};
        	self.rotation2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        	self.rotation2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        	self.rotation2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        	x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation2#maxRot"));
        	self.rotation2.maxRot = {};
        	self.rotation2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        	self.rotation2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        	self.rotation2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        	self.rotation2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation2#rotTime"), 2)*1000;
        	self.rotation2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation2#touchRotLimit"), 10));
	end;
end;

function MMSuchlicht:delete()
end;

function MMSuchlicht:mouseEvent(posX, posY, isDown, isUp, button)
end;
	  
function MMSuchlicht:keyEvent(unicode, sym, modifier, isDown)

	if sym == Input.KEY_l then
		self.rotation1Min = isDown;
		self.rotation2Min = isDown;
	end;
	if sym == Input.KEY_k then
		self.rotation1Max = isDown;
		self.rotation2Max = isDown;
	end;
end;

function MMSuchlicht:update(dt)
	local doRotate = self.rotation1Max or self.rotation1Min 
	if self.rotation1 ~= nil and doRotate then
        	local x, y, z = getRotation(self.rotation1.node);
        	local rot = {x,y,z};
        	local newRot = Utils.getMovedLimitedValues(rot, self.rotation1.maxRot, self.rotation1.minRot, 3, self.rotation1.rotTime, dt, not self.rotation1Max);
        	setRotation(self.rotation1.node, unpack(newRot));
	end;
	local doRotate = self.rotation2Max or self.rotation2Min 
	if self.rotation2 ~= nil and doRotate then
        	local x, y, z = getRotation(self.rotation2.node);
        	local rot = {x,y,z};
        	local newRot = Utils.getMovedLimitedValues(rot, self.rotation2.maxRot, self.rotation2.minRot, 3, self.rotation2.rotTime, dt, not self.rotation2Max);
        	setRotation(self.rotation2.node, unpack(newRot));
	end;
end;

function MMSuchlicht:onLeave()
end;

function MMSuchlicht:draw()
end;
