--AttacherSetRpm Specialization
--Idee und ertse Versuche: "Pitzmann Tuning"
--Realisierung: "Sven777b"
--V1.0 12.07.2011
--Edit by Marc85(Thanks to Modelleicher) 3.06.2013--
--frei verwendbar, keine erlaubnis ntig.
--free for use, no permission needed.
--Modifikationen erst nach Rcksprache!!
--modifications only with my permission!!

AttacherSetRpm = {};

function AttacherSetRpm.prerequisitesPresent(specializations)
	print("Specialization AttacherSetRpm by Pitzmann Tuning and Sven777b");
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function AttacherSetRpm:load(xmlFile)
	self.engine = false;
	self.rul = false;
	self.standardMinRpm = self.motor.minRpm;
	self.auswahl = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.togglebeacon.togglebeacon#vehiclesetrpmbeacon"),true);
end;

function AttacherSetRpm:delete()
end;

function AttacherSetRpm:mouseEvent(posX, posY, isDown, isUp, button)
end;

function AttacherSetRpm:keyEvent(unicode, sym, modifier, isDown)
end;

function AttacherSetRpm:update(dt)
end;

function AttacherSetRpm:updateTick(dt)
	if self:getIsActive() then 
		local einschalten = checkImplements(self);
		if self.cylinderedHydraulicSoundEnabled then 
			einschalten = true; 
		end;
		if self.tipState == Trailer.TIPSTATE_CLOSING or self.tipState == Trailer.TIPSTATE_OPENING or self.isTurnedOn then      --Edit by Marc85, erweiterung um eigenes Gert fest im Gert/ zugmaschine--
			einschalten = true; 																					
		end;																											   -- Edit Ende--
		if einschalten and self.auswahl then
			if not self.beaconLightsActive then 
				self:setBeaconLightsVisibility(true);
				self.rul = true;
			end;
		else
			if self.rul then
				self:setBeaconLightsVisibility(false);
				self.rul = false;
			end;
		end;
		if einschalten and self.isMotorStarted or self.engine and self.isMotorStarted then
			local fuelUsed = 0.00000003*dt*math.abs(self.motor.minRpm);
			self:setFuelFillLevel(self.fuelFillLevel-fuelUsed);
			g_currentMission.missionStats.fuelUsageTotal = g_currentMission.missionStats.fuelUsageTotal + fuelUsed;
			g_currentMission.missionStats.fuelUsageSession = g_currentMission.missionStats.fuelUsageSession + fuelUsed;
			if self.motor.minRpm == self.standardMinRpm then
				self.motor.minRpm = math.min(self.motor.minRpm+2000, 2000);
			end;
		else
			if self.motor.minRpm ~= self.standardMinRpm then
				self.motor.minRpm = self.standardMinRpm;
			end;
		end;
	end;
end;

function AttacherSetRpm:draw()
end;

function AttacherSetRpm:onLeave()
	self.engine = false;
	self.rul = false;
	self.motor.minRpm = self.standardMinRpm;
end;

function checkImplements( objekt ) 
	if objekt.attachedImplements ~= nil then 
		for _, implement in pairs(objekt.attachedImplements) do 
			if implement.object.foldAnimTime ~= nil then 
				if implement.object.foldAnimTime > 0 and implement.object.foldAnimTime < 1 then 
					return true; 
				end; 
			end; 
			if implement.object.tipState == Trailer.TIPSTATE_CLOSING or implement.object.tipState == Trailer.TIPSTATE_OPENING or implement.object.isTurnedOn then 
				return true; 
			end;				
			if implement.object.attachedImplements ~= nil then 
				if checkImplements(implement.object) == true then 
					return true; 
				end; 
			end; 
		end; 
	end; 
	return false; 
end;
