--
-- NickersonsFarm
--
-- @author  Stefan Geiger
-- @date  06/08/12
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

NickersonsFarm = {}

local NickersonsFarm_mt = Class(NickersonsFarm, Mission00);


function NickersonsFarm:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = NickersonsFarm_mt;
    end;
    local self = NickersonsFarm:superClass():new(baseDirectory, mt);

--    self.playerStartX = 39;
--    self.playerStartY = 0.1;
--    self.playerStartZ = -330;
--    self.playerRotX = 0;
--    self.playerRotY = Utils.degToRad(90);

    return self;
end;

function NickersonsFarm:delete()
    NickersonsFarm:superClass().delete(self);
end;

function NickersonsFarm:load()
    self:startLoadingTask();

    self.environment = Environment:new(Utils.getFilename("map/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);

    self.helpIconsBase = nil;
    self.collectableHorseshoesObject = nil;
    self.fieldDefinitionBase = nil;
    self.vehicleShopBase = nil;

    self:loadMap(Utils.getFilename("map/NickersonsFarm.i3d", self.baseDirectory), true, self.loadMap01Finished, self);
end;

function NickersonsFarm:loadMap01Finished(node, arguments)

	self.terrainDetailAngleNumChannels = 8; -- durch die gewnschte Anzahl Channels ersetzen
	self.terrainDetailAngleMaxValue = bitShiftLeft(1, self.terrainDetailAngleNumChannels) - 1;

    self:loadMapXMLFile(Utils.getFilename("NickersonsFarm.xml", self.baseDirectory));

    self.missionPDA:loadMap(Utils.getFilename("pda_map.png", self.baseDirectory), 2048, 2048);

    g_inGameMenu:setMapViewsMap(Utils.getFilename("pda_map.png", self.baseDirectory));

    local iconSize = self.missionPDA.pdaMapWidth / 15;

   NickersonsFarm:superClass().load(self);

    if not self.missionDynamicInfo.isMultiplayer then
        self:updateFoundHorseshoes();
        self:updateFoundHelpIcons();
        self:updateMeteoriteCrash();
        self:updateRainbow();
    else
        self:removeAllHorseshoes();
        self:removeAllHelpIcons();
    end;

    self:finishLoadingTask();
end;

function NickersonsFarm:onStartMission()
    NickersonsFarm:superClass().onStartMission(self);
end;

function NickersonsFarm:mouseEvent(posX, posY, isDown, isUp, button)
    NickersonsFarm:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function NickersonsFarm:keyEvent(unicode, sym, modifier, isDown)
    NickersonsFarm:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function NickersonsFarm:update(dt)
    NickersonsFarm:superClass().update(self, dt);
end;

function NickersonsFarm:draw()
    NickersonsFarm:superClass().draw(self);
end;
function MyFieldDefinitionUpdate(self, superFunc, dt)
  -- Do not call the base update() function, in attempt at making fields buy-icons not rotate.
  -- May cause other problems though.
  --superFunc(self,dt)
end
FieldDefinition.update = Utils.overwrittenFunction(FieldDefinition.update, MyFieldDefinitionUpdate);