baleAttacher = {};

function baleAttacher.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function baleAttacher:load(xmlFile)
	self.searchObjects = baleAttacher.searchObjects;
	self.attachobjects = baleAttacher.attachobjects;
	self.detachobjects = baleAttacher.detachobjects;
	self.OrientJoint = baleAttacher.OrientJoint;
	self.setBaleAttachingState = baleAttacher.setBaleAttachingState;
	self.isObjectInRange = baleAttacher.isObjectInRange;
	self.place = {};
	local i=0;
	while true do
		local basename = string.format("vehicle.baleCastPoints.baleCastPoint(%d)",i);
		local place = {};
		place.node1 = Utils.indexToObject(self.components, getXMLString(xmlFile,basename.."#frontRight"));

		if place.node1 == nil then
			break;
		end;
		place.node2 = Utils.indexToObject(self.components, getXMLString(xmlFile,basename.."#backLeft"));
		place.attacherNode = Utils.indexToObject(self.components, Utils.getNoNil(getXMLString(xmlFile,basename.."#attacherNode"),"0>"));
		place.highOffset = Utils.getNoNil(getXMLFloat(xmlFile,basename.."#highOffset"),4);
		table.insert(self.place,place);
		i=i+1;
	end;
	self.allowVehicleAttachment = getXMLBool(xmlFile,"vehicle.baleCastPoints#allowVehicleAttachment");
	self.allowAttachment = true;
	self.Attachedobjects = {};
	self.objectsAttached = false;
	
	self.oldRotComp3 = {getWorldRotation(self.components[3].node)};
end;
function baleAttacher:readStream(streamId, connection)
	
end;

function baleAttacher:writeStream(streamId, connection)

end;
function baleAttacher:keyEvent(unicode, sym, modifier, isDown)

end;
function baleAttacher:draw()

end;
function baleAttacher:update(dt)
	local x,y,z = getWorldRotation(self.components[3].node);
	if x ~= self.oldRotComp3[1] or y ~= self.oldRotComp3[2] or z ~= self.oldRotComp3[3] then
		self.oldRotComp3 = {x,y,z};
		for _, part in pairs(self.movingParts) do
			part.isDirty = true;
		end;
	end;
end;

function baleAttacher:updateTick(dt)
	if self:getIsActive() and self.isServer then
		if self.movingDirection ~= 0 and self.allowAttachment then
			if self.objectsAttached == false then
				self:setBaleAttachingState(false);
			end;
		else
			if self.objectsAttached == true then
				self:setBaleAttachingState(true);
			end;
		end;
	end;
end;

function baleAttacher:isObjectInRange(place,object)
	local Xmax, Ymax, Zmax = getWorldTranslation(place.node1);
		  Xmax, Ymax, Zmax = worldToLocal(place.attacherNode,Xmax, Ymax, Zmax);
		  
	local Xmin, Ymin, Zmin = getWorldTranslation(place.node2);	
		  Xmin, Ymin, Zmin = worldToLocal(place.attacherNode,Xmin, Ymin, Zmin);
	
	local Xt, Yt, Zt = getWorldTranslation(object);
		  Xt, Yt, Zt = worldToLocal(place.attacherNode,Xt, Yt, Zt);
		
	if (Xt < math.max(Xmax,Xmin) and Xt > math.min(Xmax,Xmin)) and (Zt < math.max(Zmax,Zmin) and Zt > math.min(Zmax,Zmin)) and (Yt<= ((Ymax+Ymin)/2)+place.highOffset and Yt>= (Ymax+Ymin)/2) then
		return true;
	else
		return false;
	end;
end;
function baleAttacher:searchObjects()
	for index,item in pairs(g_currentMission.itemsToSave) do
		if item.item:isa(Bale) then 
			if item.item.isAttached == nil then--and (getUserAttribute(item.item.nodeId, "isHaybale") == true or getUserAttribute(item.item.nodeId, "isStrawbale") == true or getUserAttribute(item.item.nodeId, "isRoundbale") == true) then
				for k,v in pairs(self.place) do
					local isInRange = self:isObjectInRange(v,item.item.nodeId);			
					local is1stAttached = false;
					if isInRange then
						is1stAttached = self:attachobjects(v,item.item.nodeId,item.item);
					end;
					if is1stAttached then
						self.objectsAttached = true;
					end;
				end;
			end;
		end;
	end;
	if self.allowVehicleAttachment == true then
		for k,v in pairs(g_currentMission.vehicles) do
			if v ~= self and v ~= self.attacherVehicle then
				local is1stAttached = false;
				for index,components in pairs(v.components) do		
					for k1,v1 in pairs(self.place) do
						local isInRange = self:isObjectInRange(v1,components.node);	
						if isInRange then	
							is1stAttached = self:attachobjects(v1,components.node);
						end;
					end;
				end;
				if is1stAttached then
					self.objectsAttached = true;
				end;
			end;
		end;
	end;
end;
function baleAttacher:setBaleAttachingState(isCoupling,noEventSend)
	if not noEventSend and self.objectsAttached == isCoupling and not self.allowAttachment then
		--sendEvent
	end;

	if isCoupling then
		self:detachobjects();	
	elseif not isCoupling and not self.objectsAttached then
		self:searchObjects();
	end;
end;
function baleAttacher:OrientJoint(Source, Target)	
	local xw, yw, zw = getWorldTranslation(Source);		
	local x,y,z = worldToLocal(getParent(Target), xw, yw, zw);	
	setTranslation(Target, x,y,z);			
	--JointRotation Anpassung an das Objekt
	local zX, zY, zZ = localDirectionToWorld(Source, 0,0,1);
	local zX, zY, zZ = worldDirectionToLocal(getParent(Target), zX, zY, zZ);
	local yX, yY, yZ = localDirectionToWorld(Source, 0,1,0);
	local yX, yY, yZ = worldDirectionToLocal(getParent(Target), yX, yY, yZ);
	setDirection(Target, zX, zY, zZ, yX, yY, yZ);
	return false;
end;

function baleAttacher:attachobjects(place,object,baleT)
	local attachedobject = {};
	attachedobject.object = object;
	if self.isServer then
		attachedobject.AT = createTransformGroup("AT");
		link(place.attacherNode,attachedobject.AT);
		
		attachedobject.objectMass = getMass(object);
		setMass(object,attachedobject.objectMass*0.1);
		
		self:OrientJoint(object,attachedobject.AT);

		local constr = JointConstructor:new();					
		constr:setActors(place.attacherNode, object);
		constr:setJointTransforms(attachedobject.AT,  object);
		for i=1, 3 do
			constr:setTranslationLimit(i-1, true, 0, 0);
			constr:setRotationLimit(i-1,0,0);
		end;
		attachedobject.JointIndex = constr:finalize();
		
		if baleT ~= nil then
			attachedobject.baleT = baleT;
			baleT.isAttached = true;
		end;
	end;

	table.insert(self.Attachedobjects, attachedobject);
	return true;
end;

function baleAttacher:detachobjects()
	if self.isServer then
		for k,v in pairs(self.Attachedobjects) do
			removeJoint(v.JointIndex);
			delete(v.AT);
			v.JointIndex = nil;
			setMass(v.object,v.objectMass);
			if v.baleT ~= nil then
				v.baleT.isAttached = nil;
			end;
		end;
	end;
	
	self.Attachedobjects = nil;
	self.Attachedobjects = {};
	self.objectsAttached = false;
end;



function baleAttacher:onAttach(attacherVehicle)
	if self.isServer then
		self:setBaleAttachingState(false);
	end;
end;
function baleAttacher:onDetach()

	if self.isServer then
		self:setBaleAttachingState(true);
	end;
end;
function baleAttacher:onActivate()
	if self.isServer then
		self:setBaleAttachingState(false);
	end;
end;
function baleAttacher:onDeactivate()
	if self.isServer then
		self:setBaleAttachingState(true);
	end;
end;
function baleAttacher:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then

	end;
    return BaseMission.VEHICLE_LOAD_OK;
end;

function baleAttacher:getSaveAttributesAndNodes(nodeIdent)
   -- local attributes = ' side="'..tostring(self.currentSide)..'"';
    local attributes = nil;
    local node = nil;
    return attributes, node;
end;
function baleAttacher:delete()

end;

function baleAttacher:mouseEvent(posX, posY, isDown, isUp, button)
end;


