
--Written by ihc-433,Werkstattleiter und Ordaton NAS-Moddingsquad
--Date: 10.11.2012

Palfinger = {};

function Palfinger.prerequisitesPresent(specializations)
    Vehicle.registerJointType("Trailer");
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function Palfinger:deleteFinal()
    Palfinger:superClass().deleteFinal(self);
end;
function Palfinger:load(xmlFile)
	self.Trigger1 = Palfinger.Trigger1;
	self.TriggerIndex1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Trigger1#index"));
	addTrigger(self.TriggerIndex1, "Trigger1", self);
	self.enteredTrigger1 = false;
	self.Trigger2 = Palfinger.Trigger2;
	self.TriggerIndex2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Trigger2#index"));
	addTrigger(self.TriggerIndex1, "Trigger2", self);
	self.enteredTrigger2 = false;

	local hydraulicsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hydraulics#count"), 0);	
	self.hydraulics = {};	
	for i=1, hydraulicsCount do
		local hydraulicName = string.format("vehicle.hydraulics.hydraulic%d", i);		
		self.hydraulics[i] = {};		
		self.hydraulics[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#index"));
		self.hydraulics[i].punch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punch"));
		self.hydraulics[i].translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punchFixpoint"));
		self.hydraulics[i].fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#fixpoint"));
		if self.hydraulics[i].punch ~= nil and self.hydraulics[i].translationPunch ~= nil then
			local ax, ay, az = getWorldTranslation(self.hydraulics[i].punch);
			local bx, by, bz = getWorldTranslation(self.hydraulics[i].translationPunch);		
			self.hydraulics[i].punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		end;
	end;
	
	self.hud = {0.76,0.2,0.2,0.7};
	self.hud.On = false;
	self.hud.allowed = false;
	self.hud.size = 1;
	self.hud.Text = {};
	self.hud.Text.PosX = self.hud[1] + 0.02;
	self.hud.Text.PosY1 = self.hud[2]+0.02;
	self.hud.Text.size1 = 0.02;
	self.hud.Text.PosY2 = self.hud.Text.PosY1-self.hud.size;
	self.hud.Text.PosY3 = self.hud.Text.PosY2-self.hud.size;
	self.hud.Text.PosY4 = self.hud.Text.PosY3-self.hud.size;
	self.hud.Text.size4 = 0.02;
	self.hud.Text.PosY5 = self.hud.Text.PosY4-self.hud.size;
	self.hud.Text.size5 = 0.02;
	self.NGHOverlay = Overlay:new("PalfingerOverlay", Utils.getFilename("tex/Hud.dds", self.baseDirectory), self.hud[1], self.hud[2], self.hud[3], self.hud[4]);
	
end;

function Palfinger:Trigger1(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	if (g_currentMission.controlledVehicle and otherId == g_currentMission.controlledVehicle.components[1].node) or (g_currentMission.player and otherId == g_currentMission.player.rootNode) then
		if onEnter then
			self.enteredTrigger1 = true;
		end;
	if onLeave then 
		self.enteredTrigger1 = false;
		end;
	end;
end;
function Palfinger:Trigger2(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	if (g_currentMission.controlledVehicle and otherId == g_currentMission.controlledVehicle.components[1].node) or (g_currentMission.player and otherId == g_currentMission.player.rootNode) then
		if onEnter then
			self.enteredTrigger2 = true;
		end;
	if onLeave then 
		self.enteredTrigger2 = false;
		end;
	end;
end;

function Palfinger:readStream(streamId, connection)
	
end;

function Palfinger:writeStream(streamId, connection)	
	
end;

function Palfinger:delete()
	
end;

function Palfinger:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Palfinger:keyEvent(unicode, sym, modifier, isDown)
end;

function Palfinger:update(dt)
	
	if self.enteredTrigger1 then 
		if InputBinding.isPressed(InputBinding.Palfinger_PK_1) then 
			self:setAnimationTime(5, self.animationParts[5].currentPosition+(self.animationParts[5].offSet*(dt/5)));
		end;
		if InputBinding.isPressed(InputBinding.Palfinger_PK_2) then 
			self:setAnimationTime(5, self.animationParts[5].currentPosition-(self.animationParts[5].offSet*(dt/5)));
		end;
		if InputBinding.isPressed(InputBinding.Palfinger_PK_3) then 
			self:setAnimationTime(6, self.animationParts[6].currentPosition+(self.animationParts[6].offSet*(dt/5)));
		end;
		if InputBinding.isPressed(InputBinding.Palfinger_PK_4) then 
			self:setAnimationTime(6, self.animationParts[6].currentPosition-(self.animationParts[6].offSet*(dt/5)));
		end;
		if self.animationParts[5].clip then
					g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Palfinger_PK_1")), InputBinding.Palfinger_PK_1);
					g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Palfinger_PK_2")), InputBinding.Palfinger_PK_2);
		end;
		if self.animationParts[6].clip then
					g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Palfinger_PK_3")), InputBinding.Palfinger_PK_3);
					g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Palfinger_PK_4")), InputBinding.Palfinger_PK_4);
		end;
	end;
	if self.enteredTrigger2 then
		if InputBinding.isPressed(InputBinding.Palfinger_PK_5) then 
			self:setAnimationTime(7, self.animationParts[7].currentPosition+(self.animationParts[7].offSet*(dt/5)));
		end;
		if InputBinding.isPressed(InputBinding.Palfinger_PK_6) then 
			self:setAnimationTime(7, self.animationParts[7].currentPosition-(self.animationParts[7].offSet*(dt/5)));
		end;
		if InputBinding.isPressed(InputBinding.Palfinger_PK_7) then 
			self:setAnimationTime(8, self.animationParts[8].currentPosition+(self.animationParts[8].offSet*(dt/5)));
		end;
		if InputBinding.isPressed(InputBinding.Palfinger_PK_8) then
			self:setAnimationTime(8, self.animationParts[8].currentPosition-(self.animationParts[8].offSet*(dt/5)));
		end;
		if self.animationParts[7].clip then
					g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Palfinger_PK_1")), InputBinding.Palfinger_PK_5);
					g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Palfinger_PK_2")), InputBinding.Palfinger_PK_6);
		end;
		if self.animationParts[8].clip then
					g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Palfinger_PK_3")), InputBinding.Palfinger_PK_7);
					g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Palfinger_PK_4")), InputBinding.Palfinger_PK_8);
		end;
	end;
	
	if self:getIsActiveForInput() then
		if InputBinding.isPressed(InputBinding.Palfinger_PK_9) then
			self:setAnimationTime(9, self.animationParts[9].currentPosition+(self.animationParts[9].offSet*(dt/5)));
		end;
		if InputBinding.isPressed(InputBinding.Palfinger_PK_10) then
			self:setAnimationTime(9, self.animationParts[9].currentPosition-(self.animationParts[9].offSet*(dt/5)));
		end;
		if InputBinding.isPressed(InputBinding.Palfinger_PK_11) then
			self:setAnimationTime(10, self.animationParts[10].currentPosition+(self.animationParts[10].offSet*(dt/5)));
		end;
		if InputBinding.isPressed(InputBinding.Palfinger_PK_12) then
			self:setAnimationTime(10, self.animationParts[10].currentPosition-(self.animationParts[10].offSet*(dt/5)));
		end;
		if InputBinding.isPressed(InputBinding.Palfinger_PK_13) then
			self:setAnimationTime(11, self.animationParts[11].currentPosition+(self.animationParts[11].offSet*(dt/5)));
		end;
		if InputBinding.isPressed(InputBinding.Palfinger_PK_14) then
			self:setAnimationTime(11, self.animationParts[11].currentPosition-(self.animationParts[11].offSet*(dt/5)));
		end;
		if InputBinding.isPressed(InputBinding.Palfinger_PK_15) then
			self:setAnimationTime(12, self.animationParts[12].currentPosition+(self.animationParts[12].offSet*(dt/5)));
		end;
		if InputBinding.isPressed(InputBinding.Palfinger_PK_16) then
			self:setAnimationTime(12, self.animationParts[12].currentPosition-(self.animationParts[12].offSet*(dt/5)));
		end;
		if InputBinding.isPressed(InputBinding.Palfinger_PK_17) then
			self:setAnimationTime(13, self.animationParts[13].currentPosition+(self.animationParts[13].offSet*(dt/5)));
		end;
		if InputBinding.isPressed(InputBinding.Palfinger_PK_18) then
			self:setAnimationTime(13, self.animationParts[13].currentPosition-(self.animationParts[13].offSet*(dt/5)));
		end;
		if InputBinding.hasEvent(InputBinding.Hud) then
			self.hud.On = not self.hud.On;
		end;
	end;
end;

function Palfinger:triggerCallback(triggerId,otherId,onEnter,onLeave,onStay)
    if (triggerId == self.stateChange) then
        if (onEnter and g_currentMission.controlPlayer and g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode) then
            self.changeAllowed = true;
        elseif (onLeave) then
            self.changeAllowed = false;
        end;
    end;
end;
function Palfinger:updateTick(dt)

	for i=1, table.getn(self.hydraulics) do
		local ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		local bx, by, bz = getWorldTranslation(self.hydraulics[i].fixPoint);
		if bx ~= nil and by ~= nil and bz ~= nil then
			local x, y, z = worldDirectionToLocal(getParent(self.hydraulics[i].node), bx-ax, by-ay, bz-az);
			setDirection(self.hydraulics[i].node, x, y, z, 0, 0, 1);
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			if self.hydraulics[i].punch ~= nil and self.hydraulics[i].punchDistance ~= nil and self.hydraulics[i].translationPunch then
				if self.hydraulics[i].doScale then
					local xScale, yScale, zScale = getScale(self.hydraulics[i].punch);
					local newScale = xScale * (distance / self.hydraulics[i].punchDistance);
					setScale(self.hydraulics[i].punch, 1, 1, newScale);
				else
					setTranslation(self.hydraulics[i].punch, 0, 0, distance-self.hydraulics[i].punchDistance);
				end;
			end;
		end;
	end;
end;

function Palfinger:onAttach(attacherVehicle)
end;	

function Palfinger:onDetach()
	
end;

function Palfinger:draw()
	if self:getIsActive() then
		if self.hud.On then
			local Hud = g_i18n:getText("Hud_off");
			self.NGHOverlay:render();
		end;
		if not self.hud.On then
			g_currentMission:addHelpButtonText(g_i18n:getText("Hud"), InputBinding.Hud);
		end;
	end;
end;
function Palfinger:onLeave()
	
end;

function Palfinger:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;