
--Written by "ihc-433" 
--Update by "Werkstattleiter" und "Ordaton"  NAS-Moddingsquad
--Date: 10.11.2012

Actros = {};

function Actros.prerequisitesPresent(specializations)
    return true; 
end;

function Actros:load(xmlFile)
		--Erster Trigger
	self.Trigger1 = Actros.Trigger1;
	self.TriggerIndex1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Trigger1#index"));
	addTrigger(self.TriggerIndex1, "Trigger1", self);
	self.enteredTrigger1 = false;
		--Zweiter Trigger
	self.Trigger2 = Actros.Trigger2;
	self.TriggerIndex2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Trigger2#index"));
	addTrigger(self.TriggerIndex2, "Trigger2", self);
	self.enteredTrigger2 = false;
	
	local hydraulicsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hydraulics#count"), 0);	
	self.hydraulics = {};	
	for i=1, hydraulicsCount do
		local hydraulicName = string.format("vehicle.hydraulics.hydraulic%d", i);		
		self.hydraulics[i] = {};		
		self.hydraulics[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#index"));
		self.hydraulics[i].punch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punch"));
		self.hydraulics[i].translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punchFixpoint"));
		self.hydraulics[i].fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#fixpoint"));
		if self.hydraulics[i].punch ~= nil and self.hydraulics[i].translationPunch ~= nil then
			local ax, ay, az = getWorldTranslation(self.hydraulics[i].punch);
			local bx, by, bz = getWorldTranslation(self.hydraulics[i].translationPunch);		
			self.hydraulics[i].punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		end;
	end;
	
end;

function Actros:Trigger1(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	if onEnter then
		self.enteredTrigger1 = true;
	end;
	if onLeave then 
		self.enteredTrigger1 = false;
	end;
end;

function Actros:Trigger2(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	if onEnter then
		self.enteredTrigger2 = true;
	end;
	if onLeave then 
		self.enteredTrigger2 = false;
	end;
end;

function Actros:readStream(streamId, connection)
	
end;

function Actros:writeStream(streamId, connection)	
	
end;

function Actros:delete()
	
end;

function Actros:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Actros:keyEvent(unicode, sym, modifier, isDown)
end;

function Actros:update(dt)


	
	if self:getIsActiveForInput() then
		if InputBinding.isPressed(InputBinding.Actros_GH_1) then
			self:setAnimationTime(1, self.animationParts[1].currentPosition+(self.animationParts[1].offSet*(dt/10)));
		end;
		if InputBinding.isPressed(InputBinding.Actros_GH_2) then
			self:setAnimationTime(1, self.animationParts[1].currentPosition-(self.animationParts[1].offSet*(dt/10)));
		end;
				if self.animationParts[1].clipEndTime then
					g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Actros_GH_2")), InputBinding.Actros_GH_2);
				else
					g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Actros_GH_1")), InputBinding.Actros_GH_1);
				end;
		if InputBinding.isPressed(InputBinding.Actros_GH_4) then
			self:setAnimationTime(2, self.animationParts[2].currentPosition+(self.animationParts[2].offSet*(dt/10)));
		end;
		if InputBinding.isPressed(InputBinding.Actros_GH_3) then
			self:setAnimationTime(2, self.animationParts[2].currentPosition-(self.animationParts[2].offSet*(dt/10)));
		end;
				if self.animationParts[2].clipEndTime then
					g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Actros_GH_3")), InputBinding.Actros_GH_3);
				else
					g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Actros_GH_4")), InputBinding.Actros_GH_4);
				end;
		if InputBinding.isPressed(InputBinding.Actros_GH_6) then
			self:setAnimationTime(3, self.animationParts[3].currentPosition+(self.animationParts[3].offSet*(dt/10)));
		end;
		if InputBinding.isPressed(InputBinding.Actros_GH_5) then
			self:setAnimationTime(3, self.animationParts[3].currentPosition-(self.animationParts[3].offSet*(dt/10)));
		end;
				if self.animationParts[3].clipEndTime then
					g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Actros_GH_5")), InputBinding.Actros_GH_5);
				else
					g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Actros_GH_6")), InputBinding.Actros_GH_6);
			end;
		if InputBinding.isPressed(InputBinding.Actros_GH_8) then
			self:setAnimationTime(4, self.animationParts[4].currentPosition+(self.animationParts[4].offSet*(dt/10)));
		end;
		if InputBinding.isPressed(InputBinding.Actros_GH_7) then
			self:setAnimationTime(4, self.animationParts[4].currentPosition-(self.animationParts[4].offSet*(dt/10)));
		end;
	end;
end;

function Actros:updateTick(dt)

	for i=1, table.getn(self.hydraulics) do
		local ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		local bx, by, bz = getWorldTranslation(self.hydraulics[i].fixPoint);
		if bx ~= nil and by ~= nil and bz ~= nil then
			local x, y, z = worldDirectionToLocal(getParent(self.hydraulics[i].node), bx-ax, by-ay, bz-az);
			setDirection(self.hydraulics[i].node, x, y, z, 0, 0, 1);
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			if self.hydraulics[i].punch ~= nil and self.hydraulics[i].punchDistance ~= nil and self.hydraulics[i].translationPunch then
				if self.hydraulics[i].doScale then
					local xScale, yScale, zScale = getScale(self.hydraulics[i].punch);
					local newScale = xScale * (distance / self.hydraulics[i].punchDistance);
					setScale(self.hydraulics[i].punch, 1, 1, newScale);
				else
					setTranslation(self.hydraulics[i].punch, 0, 0, distance-self.hydraulics[i].punchDistance);
				end;
			end;
		end;
	end;
	
end;

function Actros:draw()
	


end;

function Actros:onLeave()
	
end;