--
--@  Vorota
--@ DIM_DIM [LSSA Modding Team]
--@ 21.12.12
--@ http://lssa.ru/
--

   
Vorota = {};
  
local Vorota_mt = Class(Vorota);
  
function Vorota.onCreate(id)
    g_currentMission:addUpdateable(Vorota:new(id));
end;
  
function Vorota:new(id, customMt)
  
      local instance = {};
      if customMt ~= nil then
          setmetatable(instance, customMt);
      else
          setmetatable(instance, Vorota_mt);
      end;
	  
 	--T
	
    local trig1 = getUserAttribute(id, "trigger1");
    instance.trigger1 = Utils.indexToObject(id, trig1);
    addTrigger(instance.trigger1, "triggerCallback", instance);
 	--T
	
	--
	local inputKey = getUserAttribute(id, "inputKey");
	instance.inputKey = InputBinding[inputKey];
	instance.posText = getUserAttribute(id, "posText");
	instance.negText =  getUserAttribute(id, "negText");
	local automat = getUserAttribute(id, "automat");	
	instance.automat =  automat;	
	--	
	
	--
	local c=1;
	instance.schranken = {};
	while true do
		local s = getUserAttribute(id, "Vorota"..c);
		if s == nil then break; end;
		local sidx = Utils.indexToObject(id,s);
		if sidx ~= nil then
			local schranke = {};
			schranke.idx = sidx;
			schranke.zeit = Utils.getNoNil(getUserAttribute(sidx,"Sped"),5)*1000;
			local x,y,z = Utils.getVectorFromString(getUserAttribute(sidx, "rotMin"));
			schranke.rotMin = {};
			schranke.rotMin[1] = Utils.getNoNil(math.rad(x),0);
			schranke.rotMin[2] = Utils.getNoNil(math.rad(y),0);
			schranke.rotMin[3] = Utils.getNoNil(math.rad(z),0);
			x,y,z = Utils.getVectorFromString(getUserAttribute(sidx, "rotMax"));
			schranke.rotMax = {};
			schranke.rotMax[1] = Utils.getNoNil(math.rad(x),0);
			schranke.rotMax[2] = Utils.getNoNil(math.rad(y),0);
			schranke.rotMax[3] = Utils.getNoNil(math.rad(z),0);
			x,y,z = Utils.getVectorFromString(getUserAttribute(sidx, "transMin"));
			schranke.transMin = {};
			schranke.transMin[1] = Utils.getNoNil((x),0);
			schranke.transMin[2] = Utils.getNoNil((y),0);
			schranke.transMin[3] = Utils.getNoNil((z),0);
			x,y,z = Utils.getVectorFromString(getUserAttribute(sidx, "transMax"));
			schranke.transMax = {};
			schranke.transMax[1] = Utils.getNoNil((x),0);
			schranke.transMax[2] = Utils.getNoNil((y),0);
			schranke.transMax[3] = Utils.getNoNil((z),0);			
			table.insert(instance.schranken,schranke);
		end;
		c=c+1;
	end;	
 	--
	
	instance.isEnabled = true;
	
    return instance;
end;
  
function Vorota:delete() 
    removeTrigger(self.triggerId);
end;
  
function Vorota:update(dt)
	
	local activeAutomat = false;	
	local activeSteeringInformations = false;
	if self.playerInDoorTrigger then
		activeSteeringInformations = true;
		activeAutomat = true;
	else
		if self.vehicleInDoorTrigger ~= nil then
			if self.vehicleInDoorTrigger:getIsActive() then
				activeSteeringInformations = true;
				activeAutomat = true;
			end;
		end;
	end;	

	if activeSteeringInformations then
		if self.automat == 0 then	
			if activeAutomat then
				self.Door = true;
			end;		
		else	
			if not self.Door then
				g_currentMission:addHelpButtonText(g_i18n:getText(self.posText), self.inputKey);
			else
				g_currentMission:addHelpButtonText(g_i18n:getText(self.negText), self.inputKey);
			end;				
			if InputBinding.hasEvent(self.inputKey) then
				self.Door = not self.Door;
			end;
		end;
	else	
		if self.automat == 0 then	
			self.Door = false;
		end;		
	end;
		
	if self.Door then		
		self.schrankeRMax = true;												
		self.schrankeRMin = false;
		self.schrankeTMax = true;												
		self.schrankeTMin = false;
	else
		self.schrankeRMax = false;												
		self.schrankeRMin = true;
		self.schrankeTMax = false;												
		self.schrankeTMin = true;
	end;
		
	for s=1,table.getn(self.schranken) do
		local schranke = self.schranken[s];
		local doRotate = self.schrankeRMax or self.schrankeRMin
		if schranke ~= nil and doRotate then				
			local curRot = {getRotation(schranke.idx)};
			local newRot = Utils.getMovedLimitedValues(curRot,schranke.rotMax,schranke.rotMin,3,schranke.zeit,dt,not self.schrankeRMax);
			setRotation(schranke.idx,unpack(newRot));
		end;
		local doTranslate = self.schrankeTMax or self.schrankeTMin				
		if schranke ~= nil and doTranslate then							
			local curTrans = {getTranslation(schranke.idx)};
			local newTrans = Utils.getMovedLimitedValues(curTrans,schranke.transMax,schranke.transMin,3,schranke.zeit,dt,not self.schrankeTMax);
			setTranslation(schranke.idx,unpack(newTrans));
		end;	
	end;
	
end;
  
function Vorota:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
  
 	if self.isEnabled then
		if (onEnter or onLeave) then
			local vehicle = g_currentMission.nodeToVehicle[otherShapeId];
			if vehicle ~= nil then
				self.playerInDoorTrigger = false;
				if onLeave then
					if self.vehicleInDoorTrigger == vehicle then
						self.vehicleInDoorTrigger = nil;
					end;
				else
					if vehicle ~= nil then
						self.vehicleInDoorTrigger = vehicle;
					end;
				end;
			else
				if g_currentMission.controlPlayer and g_currentMission.player ~= nil then
					if otherId == g_currentMission.player.rootNode then
						if onEnter then
							self.playerInDoorTrigger = true;
						else
							self.playerInDoorTrigger = false;
						end;
					end;
				else
					self.playerInDoorTrigger = false;
				end;
			end;
		end;
	else
		self.playerInDoorTrigger = false;
		self.vehicleInDoorTrigger = nil;
	end;
	
end;
    
g_onCreateUtil.addOnCreateFunction("VorotaOnCreate", Vorota.onCreate);

