--
-- manualIgnition
-- Specialization for manual Motor Ignition
--
-- @author  Templaer
-- @date  01/05/09
--
-- Modifikationen erst nach Rcksprache
-- Do not edit without my permission
--
-- @LS11 multiplayer ready: Andreas Schneider <aksdb@gmx.de> (24.10.2010)
-- V3 by Mofa-Killer

manualIgnition = {};

function manualIgnition.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function manualIgnition:load(xmlFile)
	self.updateVehicleState = SpecializationUtil.callSpecializationsFunction("updateVehicleState");

    -- Booleans
    self.ignitionKey = false;
	self.allowedIgnition = false;  
	
	self.fuelConsumption = 0;
	self.distanceDriven = 0;
	self.fuelUsed = 0;
	self.runningTime = 0;
	local motorSoundLeave  = getXMLString(xmlFile, "vehicle.motorSoundLeave#file");
    if motorSoundLeave  ~= nil and motorSoundLeave  ~= "" then
        motorSoundLeave  = Utils.getFilename(motorSoundLeave, self.baseDirectory);
        self.motorSoundLeavePitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundLeave#pitchOffset"), 0);
        self.motorSoundLeaveRadius = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundLeave#radius"), 50);
        self.motorSoundLeaveInnerRadius = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundLeave#innerRadius"), 10);
        self.motorSoundLeaveVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundLeave#volume"), 1);
        self.motorSoundLeave = createAudioSource("motorSoundLeave", motorSoundLeave, self.motorSoundLeaveRadius, self.motorSoundLeaveInnerRadius, self.motorSoundLeaveVolume, 0);
        link(self.components[1].node, self.motorSoundLeave);
        setVisibility(self.motorSoundLeave, false);
    end;
    local aiMotorSound  = getXMLString(xmlFile, "vehicle.aiMotorSound#file");
    if aiMotorSound  ~= nil and aiMotorSound  ~= "" then
        aiMotorSound  = Utils.getFilename(aiMotorSound, self.baseDirectory);
        self.aiMotorSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundRun#pitchOffset"), 0);
        self.aiMotorSoundRadius = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundRun#radius"), 50);
        self.aiMotorSoundInnerRadius = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundRun#innerRadius"), 10);
        self.aiMotorSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundRun#volume"), 1);
        self.aiMotorSound = createAudioSource("aiMotorSound", aiMotorSound, self.aiMotorSoundRadius, self.aiMotorSoundInnerRadius, self.aiMotorSoundVolume, 0);
        link(self.components[1].node, self.aiMotorSound);
        setVisibility(self.aiMotorSound, false);
    end;
	
	-- Backup Stop Sound volume
    self.motorStopSoundVolume2 = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorStopSound#volume"), 1.0);
	
	self.isMIActor = false;
end;

function manualIgnition:readStream(streamId, connection)
	self.ignitionKey = streamReadBool(streamId);
    self.allowedIgnition = true;
	--self.isMotorStarted = self.ignitionKey;
	--self.steeringEnabled = self.ignitionKey;
	--Utils.setEmittingState(self.exhaustParticleSystems, self.ignitionKey);
	--setVisibility(self.aiMotorSound, self.ignitionKey);
	--setVisibility(self.motorSoundLeave, self.ignitionKey);
	
	self.fuelConsumption = streamReadFloat32(streamId);
	self.distanceDriven = streamReadFloat32(streamId);
	self.fuelUsed = streamReadFloat32(streamId);
	self.runningTime = streamReadFloat32(streamId);   
end;

function manualIgnition:writeStream(streamId, connection)
    if self.isServer then
        streamWriteBool(streamId, self.ignitionKey);
        streamWriteFloat32(streamId, self.fuelConsumption);
        streamWriteFloat32(streamId, self.distanceDriven);
        streamWriteFloat32(streamId, self.fuelUsed);
        streamWriteFloat32(streamId, self.runningTime);
    end;
end;

function manualIgnition:delete()
end;

function manualIgnition:mouseEvent(posX, posY, isDown, isUp, button)
end;

function manualIgnition:keyEvent(unicode, sym, modifier, isDown)
end;

function manualIgnition:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
    local runningTime =  Utils.getNoNil(getXMLFloat(xmlFile, key.."#runningTime"),0);
    self.runningTime = runningTime;
    local distanceDriven =  Utils.getNoNil(getXMLFloat(xmlFile, key.."#distanceDriven"),0);
    self.distanceDriven = distanceDriven;
	local fuelUsed = Utils.getNoNil(getXMLFloat(xmlFile, key.."#fuelUsed"), 0);
	self.fuelUsed = fuelUsed;
	return BaseMission.VEHICLE_LOAD_OK;
end;

function manualIgnition:getSaveAttributesAndNodes(nodeIdent)
    local runningTime = Utils.getNoNil(self.runningTime, 10);
	local distanceDriven = Utils.getNoNil(self.distanceDriven, 10);
	local fuelUsed = Utils.getNoNil(self.fuelUsed, 10);
    local attributes = 'runningTime="'..string.format("%f", runningTime)..'"'..' distanceDriven="'..string.format("%f", distanceDriven)..'"'..' fuelUsed="'..string.format("%f", fuelUsed)..'"';
    return attributes, nil;
end;

function manualIgnition:update(dt)
	if self.isMotorStarted then
	    local kmMs = self.lastSpeed*self.speedDisplayScale / 1000;
		self.distanceDriven = self.distanceDriven + (kmMs * dt);
	    self.runningTime = self.runningTime + (dt / 1000 / 60 / 60);
		self.fuelConsumption = (self.lastMovedDistance*self.fuelUsage / dt) * 1000 * 60 * 60;
		self.fuelUsed = self.fuelUsed + self.lastMovedDistance*self.fuelUsage;
	end;
	
    if not self.isAITractorActivated then
        if self:getIsActiveForInput() then
            if InputBinding.hasEvent(InputBinding.IGNITION_START or InputBinding.IGNITION_STOP) then
		        self:updateVehicleState(not self.ignitionKey);
                --self.ignitionKey = not self.ignitionKey;
			    --self.allowedIgnition = true;
	        end;
        end;
	end;
end;

function manualIgnition:updateTick(dt)
    if not g_currentMission.controlledVehicle or (g_currentMission.controlledVehicle == nil) then
        if self.ignitionKey and not getVisibility(self.aiMotorSound) then
            setVisibility(self.aiMotorSound, true);
        elseif not self.ignitionKey and getVisibility(self.aiMotorSound) then
            setVisibility(self.aiMotorSound, false);
        end;
    end;
    if not self.isAITractorActivated then
	    if not self.ignitionKey or not self.deactivateOnLeave then
	        self.motorStopSoundVolume = 0;
        else
	        self.motorStopSoundVolume = self.motorStopSoundVolume2;
	    end;								
        if self.ignitionKey and self.allowedIgnition then	
		    self:startMotor();
			self.allowedIgnition = false;
			self.deactivateOnLeave = false;
			self.steeringEnabled = true;
			Utils.setEmittingState(self.exhaustParticleSystems, true);
		elseif not self.ignitionKey and self.allowedIgnition then
		    if self.motorStopSoundVolume == 0 then
			    self.motorStopSoundVolume = self.motorStopSoundVolume2;
			end;
			
			self:stopMotor();
			self.allowedIgnition = false;
	        self.steeringEnabled = false;
			self.deactivateOnLeave = true;
			setVisibility(self.aiMotorSound, false);
			setVisibility(self.motorSoundLeave, false);
		    if self.isServer then
		        for k,wheel in pairs(self.wheels) do
			        setWheelShapeProps(wheel.node, wheel.wheelShape, 0, self.motor.brakeForce, 0);
		        end;
		    end;
			self:onDeactivateAttachements();
		end;
    elseif not self.ignitionKey and not self.deactivateOnLeave then
		self:stopAITractor();
	end;
end;

function manualIgnition:onLeave()
    if not self.deactivateOnLeave then
	    Utils.setEmittingState(self.exhaustParticleSystems, true);
		self.allowedIgnition = false;
		self.isMotorStarted = true;
		self.ignitionKey = true; 
		self.steeringEnabled = false;	
        setVisibility(self.aiMotorSound, true);
        if self.isAutopilotActivated or self.isAIThreshing or self.isThreshing then
            setVisibility(self.aiThreshingSound, true);
        else
            setVisibility(self.aiThreshingSound, false);
        end;
		if self.isServer then
		    for k,wheel in pairs(self.wheels) do
			    setWheelShapeProps(wheel.node, wheel.wheelShape, 0, self.motor.brakeForce, 0);
		    end;
		end;
	else
		self.allowedIgnition = false;
		self.isMotorStarted = false;
		self.ignitionKey = false;
	end;
	
	if self.isMIActor then
		ManualIgnitionStatsEvent.sendEvent(self);
		self.isMIActor = false;
	end;
end;

function manualIgnition:onEnter()
	self.isMIActor = self.isEntered;
	if not self.ignitionKey then
		self.isMotorStarted = false;
		Motorized.stopSounds(self);
		self.steeringEnabled = false;
		Utils.setEmittingState(self.exhaustParticleSystems, false);
	else
	    self.steeringEnabled = true;
	end;
	
	if self.isEntered then
		setVisibility(self.aiMotorSound, false);
		setVisibility(self.motorSoundLeave, false);
	else
		setVisibility(self.motorSoundLeave, self.ignitionKey);
	end;
    
    if self.isAutopilotActivated or self.isAIThreshing or self.isThreshing then
        setVisibility(self.aiThreshingSound, true);
    else
        setVisibility(self.aiThreshingSound, false);
    end;
end;

function manualIgnition:draw()
end;

function manualIgnition:updateVehicleState(isRunning, noEventSend)
    ManualIgnitionEvent.sendEvent(self, isRunning, noEventSend);
    self.ignitionKey = isRunning;
    self.allowedIgnition = true;
end;