--
-- MultiPowerShaft
-- Specialization for MultiPowerShaft
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @date  26/07/09
-- @history: v1.0 - Updated by Alex2009 MultiPowerShaftAttacher
-- @history: v1.1 - Updated by Alex2009 MultiPowerShaftAttacher bug fix
--
-- @edit: MRA-Modding(Alex2009(www.alex2009.de)) The script now accepts more than one attacher

MultiPowerShaft = {};

function MultiPowerShaft.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function MultiPowerShaft:load(xmlFile)
	self.powerShafts = {};
	local i=0;
    while true do	
        local baseName = string.format("vehicle.powerShafts.powerShaft(%d)#", i);
        if getXMLString(xmlFile, baseName.."index") == nil then
            break;
        end;
        local node = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName.."index"));
        local part = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName.."part"));
        local fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName.."fixPoint"));
        local x,y,z = getRotation(node);
        local rot = {x,y,z};
        x,y,z = getTranslation(part);
        local trans = {x,y,z};
        local ax, ay, az = getWorldTranslation(part);
        local bx, by, bz = getWorldTranslation(fixPoint);	
        local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
        table.insert(self.powerShafts,i,{node=node,part=part,rot=rot,trans=trans,distance=distance,fixPoint=fixPoint,attacherVehiclePowerShaft=nil,doJointSearch=false})
        i=i+1;
    end;
    self.isTrailerAttachedForUpdate = false;
end;

function MultiPowerShaft:delete()
end;

function MultiPowerShaft:mouseEvent(posX, posY, isDown, isUp, button)
end;

function MultiPowerShaft:keyEvent(unicode, sym, modifier, isDown)
end;

function MultiPowerShaft:update(dt)
    if self.isTrailerAttachedForUpdate then
        local i=0;
        while true do
            if self.powerShafts[i] == nil then
                break;
            end;
            if self.powerShafts[i].doJointSearch then
                for ia=1, table.getn(self.attacherVehicle.attachedImplements) do
                    if self.attacherVehicle.attachedImplements[ia].object == self then	
                        local index = self.attacherVehicle.attachedImplements[ia].jointDescIndex;
                        local joint = self.attacherVehicle.attacherJoints[index];	
                        if joint.MultipowerShaftAttacher ~= nil and joint.MultipowerShaftAttacher[i] ~= nil then
                            self.powerShafts[i].attacherVehiclePowerShaft = joint.MultipowerShaftAttacher[i];
                        end;
                    end;
                end;
                self.powerShafts[i].doJointSearch = false;
            end;
            i=i+1;
        end;
        	
        local i=0;
        while true do
            if self.powerShafts[i] == nil then
                break;
            end;
            if self.powerShafts[i].attacherVehiclePowerShaft ~= nil then	
                local ax, ay, az = getWorldTranslation(self.powerShafts[i].node);
                local bx, by, bz = getWorldTranslation(self.powerShafts[i].attacherVehiclePowerShaft);
                local x, y, z = worldDirectionToLocal(getParent(self.powerShafts[i].node), bx-ax, by-ay, bz-az);
                setDirection(self.powerShafts[i].node, x, y, z, 0, -1, 0);
                local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
                setTranslation(self.powerShafts[i].part, 0, 0, distance-self.powerShafts[i].distance);	
            end;	
            i=i+1;
        end;
    end;
end;

function MultiPowerShaft:draw()
end;


function MultiPowerShaft:onAttach(attacherVehicle)
    local i=0;
    while true do
        if self.powerShafts[i] == nil then
            break;
        end;
        self.powerShafts[i].doJointSearch = true;
        if not self.isTrailerAttachedForUpdate then
            self.isTrailerAttachedForUpdate = true;
        end;
        i=i+1;
    end;   
end;

function MultiPowerShaft:onDetach()
    local i=0;
    while true do
        if self.powerShafts[i] == nil then
            break;
        end;
        setTranslation(self.powerShafts[i].part, unpack(self.powerShafts[i].trans));
        setRotation(self.powerShafts[i].node, unpack(self.powerShafts[i].rot));
        self.powerShafts[i].attacherVehiclePowerShaft = nil;
        if self.isTrailerAttachedForUpdate then
            self.isTrailerAttachedForUpdate = false;
        end;
        i=i+1;
    end;
end;




