ManualIgnitionEvent = {};
ManualIgnitionEvent_mt = Class(ManualIgnitionEvent, Event);

InitEventClass(ManualIgnitionEvent, "ManualIgnitionEvent");

function ManualIgnitionEvent:emptyNew()
    local self = Event:new(ManualIgnitionEvent_mt);
    self.className="ManualIgnitionEvent";
    return self;
end;

function ManualIgnitionEvent:new(vehicle, interactiveControlID)
    local self = ManualIgnitionEvent:emptyNew()
    self.vehicle = vehicle;
	self.interactiveControlID = interactiveControlID;
    return self;
end;

function ManualIgnitionEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.interactiveControlID = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function ManualIgnitionEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteBool(streamId, self.interactiveControlID);
end;

function ManualIgnitionEvent:run(connection)
	self.vehicle:updateVehicleState(self.interactiveControlID, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(ManualIgnitionEvent:new(self.vehicle, self.interactiveControlID), nil, connection, self.object);
	end;
end;

function ManualIgnitionEvent.sendEvent(vehicle, icObject, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(ManualIgnitionEvent:new(vehicle, icObject), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(ManualIgnitionEvent:new(vehicle, icObject));
		end;
	end;
end;