--
-- HaspelSpeedd.lua
--
-- @author  MRA-Modding(Alex2009,Repi)
-- @website www.alex2009.de, www.mra-modding.de
-- @date    4.02.2012
--
--Modifikation erst nach rcksprache mit dem Autor(Alex2009) erlaubt.
--Modification allowed only after consultation with the author(Alex2009).

HaspelSpeed = {};

function HaspelSpeed.prerequisitesPresent(specializations)
    return true;
end;

function HaspelSpeed:load(xmlFile)
    self.UpdateHaspelSpeed = SpecializationUtil.callSpecializationsFunction("UpdateHaspelSpeed");
    self.MaxReelSpeed = 0.003;
    self.MinReelSpeed = 0.0007;
    self.SpeedAddValue = 0.00005;
    self.SendSpeedData = false;
end;

function HaspelSpeed:delete()
end;

function HaspelSpeed:mouseEvent(posX, posY, isDown, isUp, button)
end;

function HaspelSpeed:keyEvent(unicode, sym, modifier, isDown)
end;

function HaspelSpeed:update(dt)
    if g_currentMission.missionDynamicInfo.isMultiplayer then
        if self.isAIThreshing then
            return;
        end;
    end;
    if self:getIsActiveForInput() then
        if self.reelStarted then
            if self.MRACutter ~= nil then
                if (not self.MRACutterstartreel and not self.MRACutterstopreel) then  
                    if Input.isKeyPressed(Input.KEY_shift) and InputBinding.isPressed(InputBinding.PageDown) then
                        self.SendSpeedData = true;
                        if (self.reelSpeed-self.SpeedAddValue) >= self.MinReelSpeed then
                            self.reelSpeed = (self.reelSpeed-self.SpeedAddValue);
                            for _, rollNode in pairs(self.rollNodes) do
                                rollNode.speed = -self.reelSpeed;
                            end;
                            self.reelSpeedMax = self.reelSpeed;
                            self.reelSpeedEnd = (self.reelSpeed-0.00001);
                        end;
                    elseif self.SendSpeedData then
                        self:UpdateHaspelSpeed(self.reelSpeed);
                    end;
                    if Input.isKeyPressed(Input.KEY_shift) and InputBinding.isPressed(InputBinding.PageUp) then
                        self.SendSpeedData = true;
                        if (self.reelSpeed+self.SpeedAddValue) <= self.MaxReelSpeed then
                            self.reelSpeed = (self.reelSpeed+self.SpeedAddValue);
                            for _, rollNode in pairs(self.rollNodes) do
                                rollNode.speed = -self.reelSpeed;
                            end;
                            self.reelSpeedMax = self.reelSpeed;
                            self.reelSpeedEnd = (self.reelSpeed-0.00001);
                        end;
                    elseif self.SendSpeedData then
                        self:UpdateHaspelSpeed(self.reelSpeed);
                    end;
                elseif self.SendSpeedData then
                    self:UpdateHaspelSpeed(self.reelSpeed);
                end;
            end;
        end;
    end;
end;

function HaspelSpeed:readStream(streamId, connection)
	if not connection:getIsServer() then
        local speed = streamReadFloat32(streamId);
        HaspelSpeed:UpdateHaspelSpeed(speed,true);
    end;
end;

function HaspelSpeed:writeStream(streamId, connection)
    if connection:getIsServer() then
        streamWriteFloat32(streamId, self.speed);
    end;
end;

function HaspelSpeed:updateTick(dt)
    if self.isServer then
        if g_currentMission.missionDynamicInfo.isMultiplayer then
            if self.isAIThreshing then
                if self.reelSpeed ~= 0.003 then
                    self:UpdateHaspelSpeed(0.003);
                end;
            end;
        end;
    end;
end;

function HaspelSpeed:draw()
end;

function HaspelSpeed:onDetach()
    for _,object in pairs(self.fruitExtraObjects) do
        setVisibility(object, false);
    end;
end;

function HaspelSpeed:onAttach()
    Cutter.updateExtraObjects(self)
end;

function HaspelSpeed:UpdateHaspelSpeed(speed,noEventSend)
    HaspelSpeedUpdateHaspelSpeedEvent.sendEvent(self, speed, noEventSend)
    self.SendSpeedData = false;
    self.reelSpeed = speed;
    for _, rollNode in pairs(self.rollNodes) do
        rollNode.speed = -self.reelSpeed;
    end;
    self.reelSpeedMax = speed;
    self.reelSpeedEnd = (speed-0.00001);
end;

HaspelSpeedUpdateHaspelSpeedEvent = {};
HaspelSpeedUpdateHaspelSpeedEvent_mt = Class(HaspelSpeedUpdateHaspelSpeedEvent, Event);

InitEventClass(HaspelSpeedUpdateHaspelSpeedEvent, "HaspelSpeedUpdateHaspelSpeedEvent");

function HaspelSpeedUpdateHaspelSpeedEvent:emptyNew()
    local self = Event:new(HaspelSpeedUpdateHaspelSpeedEvent_mt);
    self.className="HaspelSpeedUpdateHaspelSpeedEvent";
    return self;
end;

function HaspelSpeedUpdateHaspelSpeedEvent:new(vehicle, speed)
    local self = HaspelSpeedUpdateHaspelSpeedEvent:emptyNew()
    self.vehicle = vehicle;
	self.speed = speed;
    return self;
end;

function HaspelSpeedUpdateHaspelSpeedEvent:readStream(streamId, connection)
    self.vehicle = networkGetObject(streamReadInt32(streamId));
	self.speed = streamReadFloat32(streamId);
    self:run(connection);
end;

function HaspelSpeedUpdateHaspelSpeedEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteFloat32(streamId, self.speed);
end;

function HaspelSpeedUpdateHaspelSpeedEvent:run(connection)
	self.vehicle:UpdateHaspelSpeed(self.speed, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(HaspelSpeedUpdateHaspelSpeedEvent:new(self.vehicle, self.speed), nil, connection, self.vehicle);
    end;
end;

function HaspelSpeedUpdateHaspelSpeedEvent.sendEvent(vehicle, speed, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(HaspelSpeedUpdateHaspelSpeedEvent:new(vehicle, speed), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(HaspelSpeedUpdateHaspelSpeedEvent:new(vehicle, speed));
		end;
	end;
end;