--
-- Lexion 550
-- Specialization for Lexion 550
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @history:	v1.0 - Initial version
-- 10/03/13		Michi77 - small changes for Lexion 550

specialJoint = {};

function specialJoint.prerequisitesPresent(specializations)
return true;
end;

function specialJoint:load(xmlFile)

self.specialJoint = {};
self.specialJoint.index = getXMLInt(xmlFile, "vehicle.specialJoint#index");
self.specialJoint.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.specialJoint#node"));
self.specialJoint.rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.specialJoint#rotationNode"));
self.specialJoint.rotNode2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.specialJoint#rotationNode2"));
local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.specialJoint#maxRotLimit"));
self.specialJoint.maxRotLimit = {};
self.specialJoint.maxRotLimit[1] = math.rad(math.abs(Utils.getNoNil(x, 0)));
self.specialJoint.maxRotLimit[2] = math.rad(math.abs(Utils.getNoNil(y, 0)));
self.specialJoint.maxRotLimit[3] = math.rad(math.abs(Utils.getNoNil(z, 0)));
end;

function specialJoint:delete()
end;

function specialJoint:mouseEvent(posX, posY, isDown, isUp, button)
end;

function specialJoint:keyEvent(unicode, sym, modifier, isDown)
end;

function specialJoint:update(dt)
end;

function specialJoint:updateTick(dt)
end;

function specialJoint:draw()
end;
