--
-- Vario1200
-- Specialization for Vario1200
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v1.0
-- @date  		03/09/11
-- @history:	v1.0 - Initial version
--

Vario1200 = {};

function Vario1200.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Cutter, specializations) and SpecializationUtil.hasSpecialization(AnimatedVehicle, specializations);
end;

function Vario1200:load(xmlFile)
	
	self.vario1200 = {};
	self.vario1200.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.vario#index"));
	self.vario1200.fixpoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.vario#fixpoint"));
	self.vario1200.maxTrans = {Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.vario#maxTrans"))};
	self.vario1200.minTrans = {getTranslation(self.vario1200.node)};
	self.vario1200.offset = 10;
	self.vario1200.speed = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.vario#speed"), 11);
	self.vario1200.speedScaleTime = 5000;
	self.vario1200.speedScaleBackup = self.reelSpeedScale;
	self.vario1200.rollSpeedBackup = self.rollNodes[1].speed;
	self.vario1200.visNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.vario#visNode"));
	self.vario1200.visTransAttach = getXMLFloat(xmlFile, "vehicle.vario#visTrans");
	local x,y,z = getTranslation(self.vario1200.visNode);
	self.vario1200.visTransDetach = y;
	self.doJointUpdateVis = false;
	self.reelSpeedScale = 0;
	for _, rollNode in pairs(self.rollNodes) do
		rollNode.speed = 0;
	end;

	self.specialJoint = {};
	self.specialJoint.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.specialJoint#node"));
	self.specialJoint.backup = self.attacherJoint.node;
end;

function Vario1200:delete()
end;

function Vario1200:readStream(streamId, connection)
end;

function Vario1200:writeStream(streamId, connection)
end;

function Vario1200:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Vario1200:keyEvent(unicode, sym, modifier, isDown)
end;

function Vario1200:update(dt)
	
		local percent = math.max(0.85, math.min((self.lastSpeed*3600) / self.vario1200.speed, 1.3));
	
		local speedScale = Utils.getMovedLimitedValues({self.reelSpeedScale}, {self.vario1200.speedScaleBackup * percent}, {0}, 1, self.vario1200.speedScaleTime, dt, false);
		self.reelSpeedScale = speedScale[1];
		for _, rollNode in pairs(self.rollNodes) do
			local rollSpeed = Utils.getMovedLimitedValues({rollNode.speed}, {self.vario1200.rollSpeedBackup * percent}, {0}, 1, self.vario1200.speedScaleTime, dt, false);
			rollNode.speed = rollSpeed[1];
		end;
		
		if self.reelSpeedScale ~= 0 or self.rollNodes[1].speed ~= 0 then
			local percent = math.max(0.85, math.min((self.lastSpeed*3600) / self.vario1200.speed, 1.5));
			
			local speedScale = Utils.getMovedLimitedValues({self.reelSpeedScale}, {self.vario1200.speedScaleBackup * percent}, {0}, 1, self.vario1200.speedScaleTime*1.5, dt, true);
			self.reelSpeedScale = speedScale[1];
			rotate(self.reelNode, -dt*self.reelSpeed*self.reelSpeedScale, 0, 0);
			for _, rollNode in pairs(self.rollNodes) do
				local rollSpeed = Utils.getMovedLimitedValues({rollNode.speed}, {self.vario1200.rollSpeedBackup * percent}, {0}, 1, self.vario1200.speedScaleTime*1.5, dt, true);
				rollNode.speed = rollSpeed[1];
				rotate(rollNode.node, -dt*rollNode.speed, 0, 0);
			end;
		end;
	end;
end;

function Vario1200:updateTick(dt)
	if self:getIsActive() and self.reelStarted then
	    local camera = getCamera();
		if camera ~= 0 then
			local x,y,z = getWorldTranslation(camera);
			local x1,y1,z1 = getWorldTranslation(self.rootNode);
			local distance = Utils.vector3Length(x-x1,y-y1,z-z1);
			local visible = (distance < 300);
			if visible ~= self.particleSystemsVisible then			
				self.particleSystemsVisible = visible;
			end;
		end;
	end;
end;