SpecializationUtil.registerSpecialization("toggleTipSide", "ToggleTipSide", g_currentModDirectory.."ToggleTipSide.lua")


ToggleTipSide_Register = {};

function ToggleTipSide_Register:loadMap(name)
	if self.firstRun == nil then
		self.firstRun = false;
		
		print("--- loading ToggleTipSide - specialization for ToggleTipSide by fruktor (www.eifok-team.de)");
		
		for k, v in pairs(VehicleTypeUtil.vehicleTypes) do
			if v ~= nil then
				local allowInsertion = false;
				
				local foundTrailer = false;
				local foundSteerable = false;
				
				for i = 1, table.maxn(v.specializations) do
					local vs = v.specializations[i];
					if vs ~= nil and vs == SpecializationUtil.getSpecialization("trailer") then
						foundTrailer = true;
						vs.toggleTipSideText = g_i18n:getText("TOGGLETIPSIDETEXT");
						vs.toggleTipCantTipText = g_i18n:getText("TOGGLETIP_CANTTIP");
						vs.toggleTipNotSelectedText = g_i18n:getText("TOGGLETIP_NOTSELECTED");					
					end;
					if vs ~= nil and vs == SpecializationUtil.getSpecialization("steerable") then
						foundSteerable = true;
					end;

				end;
				
				if foundTrailer then --and not foundSteerable then
					table.insert(v.specializations, SpecializationUtil.getSpecialization("toggleTipSide"));
				end;
				
			end;	
		end;
	end;
end;

function ToggleTipSide_Register:deleteMap()
  
end;

function ToggleTipSide_Register:keyEvent(unicode, sym, modifier, isDown)

end;

function ToggleTipSide_Register:mouseEvent(posX, posY, isDown, isUp, button)

end;

function ToggleTipSide_Register:update(dt)
	
end;

function ToggleTipSide_Register:draw()
  
end;

addModEventListener(ToggleTipSide_Register);