SetTipSideEvent = {};
SetTipSideEvent_mt = Class(SetTipSideEvent, Event);

InitEventClass(SetTipSideEvent, "SetTipSideEvent");

function SetTipSideEvent:emptyNew()
    local self = Event:new(SetTipSideEvent_mt);
    self.className="SetTipSideEvent";
    return self;
end;

function SetTipSideEvent:new(vehicle, state)
    local self = SetTipSideEvent:emptyNew()
    self.vehicle = vehicle;
	self.state = state;
	return self;
end;

function SetTipSideEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.state = streamReadInt32(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetTipSideEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteInt32(streamId, self.state);
end;

function SetTipSideEvent:run(connection)
	self.vehicle:setTipSide(self.state, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetTipSideEvent:new(self.vehicle, self.state), nil, connection, self.object);
	end;
end;

function SetTipSideEvent.sendEvent(vehicle, state, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetTipSideEvent:new(vehicle, state), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetTipSideEvent:new(vehicle, state));
		end;
	end;
end;