-- RemorcaRM2
-- 
-- Script Specializat Pentru RM2
-- 
-- 
-- LS2013 Script: MMV MOdding Romania
-- 
-- 28/02/2011


RemorcaRM2 = {};

function RemorcaRM2.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function RemorcaRM2:load(xmlFile)	
		
	local translationPartNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPart#index"));
    if translationPartNode ~= nil then
        self.translationPart = {};
        self.translationPart.node = translationPartNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart#minTrans"));
        self.translationPart.minTrans = {};
        self.translationPart.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart#maxTrans"));
        self.translationPart.maxTrans = {};
        self.translationPart.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart#transTime"), 2)*1000;
        self.translationPart.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart#touchTransLimit"), 10);
    end;
    
	local OblonStangaNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.OblonStanga#index"));
    if OblonStangaNode ~= nil then
        self.OblonStanga = {};
        self.OblonStanga.node = OblonStangaNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.OblonStanga#minRot"));
        self.OblonStanga.minRot = {};
        self.OblonStanga.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.OblonStanga.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.OblonStanga.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.OblonStanga#maxRot"));
        self.OblonStanga.maxRot = {};
        self.OblonStanga.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.OblonStanga.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.OblonStanga.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.OblonStanga.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.OblonStanga#rotTime"), 2)*1000;
        self.OblonStanga.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.OblonStanga#touchRotLimit"), 10));
    end;

	local OblonDreaptaNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.OblonDreapta#index"));
    if OblonDreaptaNode ~= nil then
        self.OblonDreapta = {};
        self.OblonDreapta.node = OblonDreaptaNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.OblonDreapta#minRot"));
        self.OblonDreapta.minRot = {};
        self.OblonDreapta.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.OblonDreapta.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.OblonDreapta.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.OblonDreapta#maxRot"));
        self.OblonDreapta.maxRot = {};
        self.OblonDreapta.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.OblonDreapta.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.OblonDreapta.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.OblonDreapta.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.OblonDreapta#rotTime"), 2)*1000;
        self.OblonDreapta.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.OblonDreapta#touchRotLimit"), 10));
    end;	

    local OblonSpateNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.OblonSpate#index"));
    if OblonSpateNode ~= nil then
        self.OblonSpate = {};
        self.OblonSpate.node = OblonSpateNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.OblonSpate#minRot"));
        self.OblonSpate.minRot = {};
        self.OblonSpate.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.OblonSpate.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.OblonSpate.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.OblonSpate#maxRot"));
        self.OblonSpate.maxRot = {};
        self.OblonSpate.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.OblonSpate.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.OblonSpate.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.OblonSpate.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.OblonSpate#rotTime"), 2)*1000;
        self.OblonSpate.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.OblonSpate#touchRotLimit"), 10));
    end;	
end;

function RemorcaRM2:getSaveAttributesAndNodes(nodeIdent)
end;

function RemorcaRM2:mouseEvent(posX, posY, isDown, isUp, button)
end;

function RemorcaRM2:keyEvent(unicode, sym, modifier, isDown)
end;

function RemorcaRM2:update(dt)

     if self.inrange or self.isEntered then

	if InputBinding.hasEvent (InputBinding.DeschideOblonStanga) then
		self.openOblonStanga = not self.openOblonStanga;
	end;

     if InputBinding.hasEvent (InputBinding.DeschideOblonDreapta) then
		self.openOblonDreapta = not self.openOblonDreapta;
      end;

      if InputBinding.hasEvent (InputBinding.DeschideOblonSpate) then
		self.openOblonSpate = not self.openOblonSpate;
      end;
end;


     if self.inrange or self.isEntered then
		if self.openOblonStanga then
			g_currentMission:addExtraPrintText(string.format("Taste %s: Inchide OblonStanga", InputBinding.getKeyNamesOfDigitalAction(InputBinding.DeschideOblonStanga)));
		else
			g_currentMission:addExtraPrintText(string.format("Taste %s: Deschide OblonStanga", InputBinding.getKeyNamesOfDigitalAction(InputBinding.DeschideOblonStanga)));
		end;
	end; 

      if self.inrange or self.isEntered then
		if self.openOblonDreapta then
			g_currentMission:addExtraPrintText(string.format("Taste %s: Inchide OblonDreapta", InputBinding.getKeyNamesOfDigitalAction(InputBinding.DeschideOblonDreapta)));
		else
			g_currentMission:addExtraPrintText(string.format("Taste %s: Deschide OblonDreapta", InputBinding.getKeyNamesOfDigitalAction(InputBinding.DeschideOblonDreapta)));
		end;
	end; 

      if self.inrange or self.isEntered then
		if self.openOblonSpate then
			g_currentMission:addExtraPrintText(string.format("Taste %s: Inchide OblonSpate", InputBinding.getKeyNamesOfDigitalAction(InputBinding.DeschideOblonSpate)));
		else
			g_currentMission:addExtraPrintText(string.format("Taste %s: Deschide OblonSpate", InputBinding.getKeyNamesOfDigitalAction(InputBinding.DeschideOblonSpate)));
		end;
	end; 


     if self.OblonStanga ~= nil then
		local x, y, z = getRotation(self.OblonStanga.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.OblonStanga.minRot, self.OblonStanga.maxRot, 3, self.OblonStanga.rotTime, dt, self.openOblonStanga);
		setRotation(self.OblonStanga.node, unpack(newRot));
	end;

      if self.OblonDreapta ~= nil then
		local x, y, z = getRotation(self.OblonDreapta.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.OblonDreapta.minRot, self.OblonDreapta.maxRot, 3, self.OblonDreapta.rotTime, dt, self.openOblonDreapta);
		setRotation(self.OblonDreapta.node, unpack(newRot));
	end;



      if self.OblonSpate ~= nil then
		local x, y, z = getRotation(self.OblonSpate.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.OblonSpate.minRot, self.OblonSpate.maxRot, 3, self.OblonSpate.rotTime, dt, self.openOblonSpate);
		setRotation(self.OblonSpate.node, unpack(newRot));
	end;
			
end;


function RemorcaRM2:updateTick(dt)
if g_currentMission.player ~= nil then
		-- Getting the distance between the player and the implement 
		local nearestDistance = 4.0; --max distance allowed
		local px, py, pz = getWorldTranslation(self.rootNode); 
		local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);	
		if distance < nearestDistance then
			self.inrange = true; 
		else
			self.inrange = false; 
		end;
	end;
end;

function RemorcaRM2:draw()
end;