--
--	Extra wheels specialization
--	author: 	Burner
--	date:		26/08/2011
--

ExtraWheels = {};

function ExtraWheels.prerequisitesPresent(specializations)
    return true;
end;

function ExtraWheels:load(xmlFile)
	self.extraWheels = {};
	local i=0;
	while true do
		local wheelnamei = string.format("vehicle.extraWheels.extraWheel(%d)", i);
		local extraWheel = {};
		local reprStr = getXMLString(xmlFile, wheelnamei .. "#repr");
		if reprStr == nil then
			break;
		end;
		extraWheel.repr = Utils.indexToObject(self.components, reprStr);
		extraWheel.driveNode = Utils.indexToObject(self.components, getXMLString(xmlFile, wheelnamei .. "#driveNode"));
		if extraWheel.driveNode == nil then
			extraWheel.driveNode = extraWheel.repr;
		end;		
		extraWheel.rotXActor = Utils.indexToObject(self.components, getXMLString(xmlFile, wheelnamei .. "#rotXActor"));
		extraWheel.rotYActor = Utils.indexToObject(self.components, getXMLString(xmlFile, wheelnamei .. "#rotYActor"));
		table.insert(self.extraWheels, extraWheel);
		i = i+1;
	end;
end;

function ExtraWheels:delete()
end;

function ExtraWheels:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ExtraWheels:keyEvent(unicode, sym, modifier, isDown)
end;

function ExtraWheels:update(dt)
	for k, extraWheel in pairs(self.extraWheels) do
		local zX, zY, zZ = localDirectionToWorld(extraWheel.rotYActor, 0, 0, 1);
		local zX, zY, zZ = worldDirectionToLocal(getParent(extraWheel.repr), zX, zY, zZ);
		local wX, wY, wZ = getRotation(extraWheel.rotXActor);
		local xX, xY, xZ = getRotation(extraWheel.driveNode);
		setDirection(extraWheel.repr, zX, zY, zZ, 0, 1, 0);
		setRotation(extraWheel.driveNode, wX, xY, xZ);
	end;
end;

function ExtraWheels:updateTick(dt)
end;

function ExtraWheels:setHydraulicDirection(index)
end;

function ExtraWheels:draw()
end;