--
-- ArticulatedAxes
--

ArticulatedAxes = {};

function ArticulatedAxes.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function ArticulatedAxes:load(xmlFile)

    self.setRotateMaxMinScale = SpecializationUtil.callSpecializationsFunction("setRotateMaxMinScale");

    self.articulatedAxes = {}

    local i = 0
    while true do
        local baseName = string.format("vehicle.articulatedAxes.articulatedAxis(%d)", i)
        i = i + 1 
        if not hasXMLProperty(xmlFile, baseName) then
            break
        end
        
        local index = getXMLInt(xmlFile, baseName.."#componentJointIndex");
        if index ~= nil then
            local componentJoint = self.componentJoints[index+1];
            local rotSpeed = getXMLFloat(xmlFile, baseName.."#rotSpeed");
            local rotMax = getXMLFloat(xmlFile, baseName.."#rotMax");
            local rotMin = getXMLFloat(xmlFile, baseName.."#rotMin");
            if componentJoint ~= nil and rotSpeed ~= nil and rotMax ~= nil and rotMin ~= nil then
                rotSpeed = math.rad(rotSpeed);
                rotMax = math.rad(rotMax);
                rotMin = math.rad(rotMin);
                local entry = {};
    
                entry.componentJoint = componentJoint;
                entry.anchorActor = Utils.getNoNil(getXMLInt(xmlFile,  baseName.."#anchorActor"), 0);
    
                entry.rotScaleMaxMin = Utils.getNoNil(getXMLFloat(xmlFile, baseName.."#initRotScale"), 1.0);
                entry.rotMax = rotMax;
                entry.rotMin = rotMin;
                entry.rotSpeed = rotSpeed;
    
    
                local maxRotTime = rotMax/rotSpeed;
                local minRotTime = rotMin/rotSpeed;
                if minRotTime > maxRotTime then
                    local temp = minRotTime;
                    minRotTime = maxRotTime;
                    maxRotTime = temp;
                end;
                if maxRotTime > self.maxRotTime then
                    self.maxRotTime = maxRotTime;
                end;
                if minRotTime < self.minRotTime then
                    self.minRotTime = minRotTime;
                end;
    
                entry.curRot = 0;
    
                table.insert(self.articulatedAxes, entry)
            end;
        end;
    end
    
    self.lastRotatedTime = 0;
end;

function ArticulatedAxes:delete()
end;

function ArticulatedAxes:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ArticulatedAxes:keyEvent(unicode, sym, modifier, isDown)
end;

function ArticulatedAxes:setRotateMaxMinScale(axisId, newScale)
    local articulatedAxis = self.articulatedAxes[axisId]
    if articulatedAxis ~= nil then
        if articulatedAxis.rotScaleMaxMin ~= newScale then
            articulatedAxis.rotScaleMaxMin = newScale
            self.lastRotatedTime = 0; -- Force update.
        end
    end
end

function ArticulatedAxes:update(dt)

    if self.isServer then
        if self:getIsActive() then
            --if self.articulatedAxes ~= nil then
                if self.lastRotatedTime ~= self.rotatedTime then
                    self.lastRotatedTime = self.rotatedTime;
                    
                    for _,articulatedAxis in pairs(self.articulatedAxes) do
                        local steeringAngle = self.rotatedTime * articulatedAxis.rotSpeed;
                        steeringAngle = Utils.clamp(steeringAngle, articulatedAxis.rotMin * articulatedAxis.rotScaleMaxMin, articulatedAxis.rotMax * articulatedAxis.rotScaleMaxMin)
                        if math.abs(steeringAngle - articulatedAxis.curRot) > 0.001 then
                            setRotation(articulatedAxis.componentJoint.jointNode, 0, steeringAngle, 0);
                            setJointFrame(articulatedAxis.componentJoint.jointIndex, articulatedAxis.anchorActor, articulatedAxis.componentJoint.jointNode);
                            articulatedAxis.curRot = steeringAngle;
                        end;
                    end
                end;
            --end;
        end;
    end;

end;

function ArticulatedAxes:draw()
end;

--print("Script loaded: ArticulatedAxes.LUA");