--
-- changeFoilColor
-- Specialization for changeFoilColor functionality
--
-- @author	upsidedown
-- @Version 1.0
-- @based on washable by Manuel Leithner (SFM-Modding)

changeFoilColor = {};

function changeFoilColor.prerequisitesPresent(specializations)
    return true;
end;

function changeFoilColor:load(xmlFile)

	
	self.secondFoilColor = false;
	
	local i = 0;
	self.foilComponents = {};
	while true do
		local path = string.format("vehicle.foils.foilComponent(%d)", i);
		local component = Utils.indexToObject(self.components, getXMLString(xmlFile, path .. "#index"));	
		if component == nil then
			break;
		end;
		table.insert(self.foilComponents, component);
		i = i + 1;
	end;
	
	self.secondFoilVisible = {};
	self.secondFoilVisible.object1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.foilVisible#index1"));
	self.secondFoilVisible.object2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.foilVisible#index2"));
	-- self.secondFoilVisible.copyRotation = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.foilVisible#copyRotation"), false);
	-- self.secondFoilVisible.copyTranslation = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.foilVisible#copyTranslation"), false);
	self.secondFoilVisible.doVisible = self.secondFoilVisible.object1 ~= nil and self.secondFoilVisible.object2 ~= nil;
	
	
end;

function changeFoilColor:readStream(streamId, connection)
	self.secondFoilColor = streamReadBool(streamId);
end;

function changeFoilColor:writeStream(streamId, connection)
	streamWriteBool(streamId,self.secondFoilColor)
end;

function changeFoilColor:delete()
end;

function changeFoilColor:mouseEvent(posX, posY, isDown, isUp, button)
end;

function changeFoilColor:keyEvent(unicode, sym, modifier, isDown)
end;

function changeFoilColor:update(dt)
	if g_currentMission.controlledVehicle == nil then --player on foot
		local pvx, pvy, pvz = getWorldTranslation(g_currentMission.player.rootNode);
		local x, y, z = getWorldTranslation(self.rootNode);
		local farmerDistance = Utils.vector3Length(pvx-x, pvy-y, pvz-z);
		
		if farmerDistance < 5  then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("FOILCOLOR")), InputBinding.IMPLEMENT_EXTRA2);
			if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
				self.secondFoilColor = not self.secondFoilColor; 
				if g_server ~= nil then						
					g_server:broadcastEvent(FoilColorEvent:new(self, self.secondFoilColor), nil, nil, self);						
				else
					g_client:getServerConnection():sendEvent(FoilColorEvent:new(self, self.secondFoilColor));						
				end;	
			end;
		end;
	end;

end;

function changeFoilColor:updateTick(dt)
	if true then
		local shaderValue = 0;
		if self.secondFoilColor then
			shaderValue = 1;
		end;
		for _, component in pairs(self.foilComponents) do
			setShaderParameter(component, "dirtScale", shaderValue, 0,0,0,false);
		end;
	end;
	
	
	if true then
		if self.secondFoilVisible.doVisible then
			if self.secondFoilColor then
				setVisibility(self.secondFoilVisible.object1,false);
				setVisibility(self.secondFoilVisible.object2,true);
				-- if self.secondFoilVisible.copyRotation then
					-- local x,y,z = getRotation(self.secondFoilVisible.object1)
					-- setRotation(self.secondFoilVisible.object2,x,y,z)
				-- end;
				-- if self.secondFoilVisible.copyTranslation then
					-- local x,y,z = getTranslation(self.secondFoilVisible.object1)
					-- setTranslation(self.secondFoilVisible.object2,x,y,z)
				-- end;				
							
			else
				setVisibility(self.secondFoilVisible.object1,true);
				setVisibility(self.secondFoilVisible.object2,false);	
			end
		end
	end;
end;

function changeFoilColor:draw()
end;




function changeFoilColor:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		self.secondFoilColor = Utils.getNoNil(getXMLBool(xmlFile, key.."#secondFoil"),false);
	end; 
    return BaseMission.VEHICLE_LOAD_OK;
end;

function changeFoilColor:getSaveAttributesAndNodes(nodeIdent)
    local attributes = 'secondFoil="'.. tostring(self.secondFoilColor) .. '"';
    return attributes, nil;
end;







FoilColorEvent = {};
FoilColorEvent_mt = Class(FoilColorEvent, Event);

InitEventClass(FoilColorEvent, "FoilColorEvent");

function FoilColorEvent:emptyNew()  
    local self = Event:new(FoilColorEvent_mt );
    self.className="FoilColorEvent";
    return self;
end;

function FoilColorEvent:new(object, value) 
    self.object = object;
    self.value = value;
    return self;
end;

function FoilColorEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.value = streamReadBool(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function FoilColorEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
    streamWriteBool(streamId, self.value );
end;

function FoilColorEvent:run(connection)
    self.object.secondFoilColor = self.value
    if not connection:getIsServer() then  
      g_server:broadcastEvent(FoilColorEvent:new(self.object, self.value), nil, connection, self.object);
    end;
end;

function FoilColorEvent.sendEvent(object, value, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then 
			g_server:broadcastEvent(FoilColorEvent:new(object, value), nil, nil, object);
		else
			g_client:getServerConnection():sendEvent(FoilColorEvent:new(object, value));
		end;
	end;
end;