PickupEvent = {};
PickupEvent_mt = Class(PickupEvent, Event);

InitEventClass(PickupEvent, "PickupEvent");

function PickupEvent:emptyNew()
    local self = Event:new(PickupEvent_mt);
    self.className="PickupEvent";
    return self;
end;

function PickupEvent:new(object, pickupMode)
    local self = PickupEvent:emptyNew()
    self.object = object;
	self.pickupMode = pickupMode;
    return self;
end;

function PickupEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.pickupMode = streamReadBool(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function PickupEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.pickupMode);
end;

function PickupEvent:run(connection)
	self.object:setPickupMode(self.pickupMode);
    if not connection:getIsServer() then
        g_server:broadcastEvent(PickupEvent:new(self.object, self.pickupMode), nil, connection, self.object);
    end;	
end;

function PickupEvent.sendEvent(vehicle, pickupMode, noEventSend)
	if pickupMode ~= vehicle.pickupMode then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(PickupEvent:new(vehicle, pickupMode), nil, nil, vehicle);
			else
				g_client:getServerConnection():sendEvent(PickupEvent:new(vehicle, pickupMode));
			end;
		end;
	end;
end;

