
---xyzspain 




Lely = {};

function Lely.prerequisitesPresent(specializations)
     --return SpecializationUtil.hasSpecialization(Attachable, specializations);
	 return true
end;

function Lely:load(xmlFile)

-- self.setStateEvent= SpecializationUtil.callSpecializationsFunction("setStateEvent");
	-- desplazamiento de conjuntos
	
		--------------------------
		local rotationNode1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation1#index"));
    if rotationNode1 ~= nil then
        self.rotation1 = {};
        self.rotation1.node = rotationNode1;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation1#minRot"));
        self.rotation1.minRot = {};
        self.rotation1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation1#maxRot"));
        self.rotation1.maxRot = {};
        self.rotation1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotation1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation1#rotTime"), 2)*1000;
     
    end;
	local translationNode1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.translation1#index"));
    if translationNode1 ~= nil then
        self.translation1 = {};
        self.translation1.node = translationNode1;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation1#minTrans"));
        self.translation1.minTrans = {};
        self.translation1.minTrans[1] = Utils.getNoNil(x, 0);
        self.translation1.minTrans[2] = Utils.getNoNil(y, 0);
        self.translation1.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation1#maxTrans"));
        self.translation1.maxTrans = {};
        self.translation1.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translation1.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translation1.maxTrans[3] = Utils.getNoNil(z, 0);

	    self.translation1.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translation1#transTime"), 2)*1000;
      
    end;
	
	local count = getXMLInt(xmlFile, "vehicle.translationParts#count");
	if count ~= nil then
		self.translationParts = {}
		local translationPart = self.translationParts;
		for i=1, count do
			local varName = string.format("translationPart" .. "%d", i);
			translationPart[varName] = {};
			local translationPartname = string.format("vehicle.translationParts.translationPart" .. "%d", i);
			translationPart[varName].index = Utils.indexToObject(self.components, getXMLString(xmlFile, translationPartname .. "#index"));
			local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, translationPartname .. "#minTrans"));
			translationPart[varName].minTrans = {};
			translationPart[varName].minTrans[1] = Utils.getNoNil(x, 0);
			translationPart[varName].minTrans[2] = Utils.getNoNil(y, 0);
			translationPart[varName].minTrans[3] = Utils.getNoNil(z, 0);
			local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, translationPartname .. "#maxTrans"));
			translationPart[varName].maxTrans = {};
			translationPart[varName].maxTrans[1] = Utils.getNoNil(x, 0);
			translationPart[varName].maxTrans[2] = Utils.getNoNil(y, 0);
			translationPart[varName].maxTrans[3] = Utils.getNoNil(z, 0);

			translationPart[varName].transTime = Utils.getNoNil(getXMLInt(xmlFile, translationPartname .. "#transTime"), 2)*1000;	
			translationPart[varName].touchTransLimit = Utils.getNoNil(getXMLInt(xmlFile, translationPartname .. "#touchTransLimit"), 1)/1000;	
		end;
	end;
	
	self.changeAttach = false

end;

function Lely:delete()
	
end;



function Lely:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Lely:keyEvent(unicode, sym, modifier, isDown)
	
end;



function Lely:updateTick(dt)
end;

function Lely:update(dt)

	if g_currentMission.controlledVehicle == nil then --player on foot
		if g_currentMission.player ~= nil then
			local pvx, pvy, pvz = getWorldTranslation(g_currentMission.player.rootNode);
			local x, y, z = getWorldTranslation(self.rootNode);
			local farmerDistance = Utils.vector3Length(pvx-x, pvy-y, pvz-z);
			
			if farmerDistance > 6 or self.attacherVehicle ~= nil then
				return
			end
		
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("DEICHSEL")), InputBinding.CHANGE_ATTACH);
					
			if InputBinding.hasEvent(InputBinding.CHANGE_ATTACH) then
				self.changeAttach = not self.changeAttach;
				
				if g_server ~= nil then						
					g_server:broadcastEvent(LelyEvent:new(self, self.changeAttach), nil, nil, self);						
				else
					g_client:getServerConnection():sendEvent(LelyEvent:new(self, self.changeAttach));						
				end;			
			end;
		end;
	end;
	
	
	
		if self.changeAttach then
			self.rotation1max= true;
			self.translation1max= true;
			self.attacherJoint.jointType = Vehicle.JOINTTYPE_TRAILERLOW;  
		else
			self.rotation1max= false;
			self.translation1max= false;
			self.attacherJoint.jointType = Vehicle.JOINTTYPE_TRAILER;
		end;
	
	
		------------------------------------------------------------------------------

		if self.translation1max ~= nil  then 
			local x, y, z = getTranslation(self.translation1.node); 
			local trans = {x,y,z}; 
			local newTrans = Utils.getMovedLimitedValues(trans, self.translation1.maxTrans, self.translation1.minTrans, 3, self.translation1.transTime, dt, not self.translation1max); 
			setTranslation(self.translation1.node, unpack(newTrans)); 
		end;	

		if self.rotation1max ~= nil then
			local x, y, z = getRotation(self.rotation1.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotation1.maxRot, self.rotation1.minRot, 3, self.rotation1.rotTime, dt, not self.rotation1max);
			setRotation(self.rotation1.node, unpack(newRot));
		end;
			

end;

function Lely:draw()
	
end;



function Lely:getSaveAttributesAndNodes(nodeIdent)
	local attributes = ' changeAttach="'..tostring(self.changeAttach)..'"';	
	return attributes, nil;
end;

function Lely:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
       self.changeAttach = Utils.getNoNil(getXMLBool(xmlFile, key.."#changeAttach"),false);
	end;
    return BaseMission.VEHICLE_LOAD_OK;
end;

function Lely:writeStream(streamId, connection)
	streamWriteBool(streamId, self.changeAttach)
end;

function Lely:readStream(streamId, connection)  
	self.changeAttach = streamReadBool(streamId);
end;


LelyEvent = {};
LelyEvent_mt = Class(LelyEvent, Event);

InitEventClass(LelyEvent, "LelyEvent");

function LelyEvent:emptyNew()  
    local self = Event:new(LelyEvent_mt );
    self.className="LelyEvent";
    return self;
end;

function LelyEvent:new(object, value) 
    self.object = object;
    self.value = value;

    return self;
end;

function LelyEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.value = streamReadBool(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function LelyEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
    streamWriteBool(streamId, self.value );
end;

function LelyEvent:run(connection)
    self.object.changeAttach = self.value
    if not connection:getIsServer() then  
      g_server:broadcastEvent(LelyEvent:new(self.object, self.value), nil, connection, self.object);
    end;
end;

function LelyEvent.sendEvent(object, value, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then 
			g_server:broadcastEvent(LelyEvent:new(object, value), nil, nil, object);
		else
			g_client:getServerConnection():sendEvent(LelyEvent:new(object, value));
		end;
	end;
end;