CreateBaleEvent = {};
CreateBaleEvent_mt = Class(CreateBaleEvent, Event);
 
InitEventClass(CreateBaleEvent, "CreateBaleEvent");

function CreateBaleEvent:emptyNew()
    local self = Event:new(CreateBaleEvent_mt);
    self.className="CreateBaleEvent";
    return self;
end;

function CreateBaleEvent:new(object, usedFruitType, baleTime)
    local self = CreateBaleEvent:emptyNew()
    self.usedFruitType = usedFruitType;
    self.baleTime = baleTime;
    self.object = object;
    return self;
end;

function CreateBaleEvent:readStream(streamId, connection)
    self.object = networkGetObject(streamReadInt32(streamId));
    self.usedFruitType = streamReadInt8(streamId);
    self.baleTime = streamReadFloat32(streamId);
    self:run(connection);
end;

function CreateBaleEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
    streamWriteInt8(streamId, self.usedFruitType);
    streamWriteFloat32(streamId, self.baleTime);
end;

function CreateBaleEvent:run(connection)
   print("creating bale");
    self.object:createBale(self.usedFruitType);
end;