ArmEvent = {};
ArmEvent_mt = Class(ArmEvent, Event);

InitEventClass(ArmEvent, "ArmEvent");

function ArmEvent:emptyNew()
    local self = Event:new(ArmEvent_mt);
    self.className="ArmEvent";
    return self;
end;

function ArmEvent:new(object, armMode)
    local self = ArmEvent:emptyNew()
    self.object = object;
	self.armMode = armMode;
    return self;
end;

function ArmEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.armMode = streamReadBool(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function ArmEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.armMode);
end;

function ArmEvent:run(connection)
	self.object:setArmMode(self.armMode);
    if not connection:getIsServer() then
        g_server:broadcastEvent(ArmEvent:new(self.object, self.armMode), nil, connection, self.object);
    end;	
end;

function ArmEvent.sendEvent(vehicle, armMode, noEventSend)
	if armMode ~= vehicle.armMode then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(ArmEvent:new(vehicle, armMode), nil, nil, vehicle);
			else
				g_client:getServerConnection():sendEvent(ArmEvent:new(vehicle, armMode));
			end;
		end;
	end;
end;

