Oldtimer = {}
function Oldtimer.prerequisitesPresent(specializations)
  return true
end
function Oldtimer:load(xmlFile)
  self.exhaustingSystem = {}
  self.exhaustingSystem.flap = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.exhaustParticleSystems#flap"))
  self.exhaustingSystem.maxRot = Utils.degToRad(Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.exhaustParticleSystems#maxRot"), 0))
  self.exhaustingSystem.maxRpm = self.motor:getMaxRpm()
end
function Oldtimer:delete()
end
function Oldtimer:mouseEvent(posX, posY, isDown, isUp, button)
end
function Oldtimer:keyEvent(unicode, sym, modifier, isDown)
end
function Oldtimer:update(dt)
  if self:getIsActive() and self.exhaustingSystem.flap ~= nil then
    local angle = math.rad(math.random(-20, 5)) + self.exhaustingSystem.maxRot * self.motor.lastMotorRpm / self.exhaustingSystem.maxRpm
    angle = math.max(math.min(angle, 0), self.exhaustingSystem.maxRot)
    setRotation(self.exhaustingSystem.flap, 0, 0, angle)
  end
end
function Oldtimer:updateTick(dt)
end
function Oldtimer:draw()
end
