-- 
-- specialization for Zapfwelle
-- 05/08/13
-- author: schwaki
--

Zapfwelle = {};

function Zapfwelle.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Zapfwelle:load(xmlFile)
	
    self.Zapfwelle = {};
	self.Zapfwelle.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Zapfwelle#index"));
	self.Zapfwelle.speedFactor = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.Zapfwelle#speedFactor"), 2);
end;

function Zapfwelle:delete()
end;

function Zapfwelle:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Zapfwelle:keyEvent(unicode, sym, modifier, isDown)
end;

function Zapfwelle:update(dt)	
end;

function Zapfwelle:updateTick(dt)
	if self.isMotorStarted then
			
			rotate(self.Zapfwelle.node,0, self.motor.lastMotorRpm*self.Zapfwelle.speedFactor,0); 
		
	end;
end;

function Zapfwelle:draw()		
end;
