--Hallenkran.lua
--
--@Autor: Alex2009
--@Web: www.alex2009.de
--@Date: 30.08.2012
--
--Modifizierung erst nach rcksprache mit mir(Alex2009) erlaubt.
--Modification allowed back only after consultation with me(Alex2009).

torStateUpdateEvent = {};
torStateUpdateEvent_mt = Class(torStateUpdateEvent, Event);

InitEventClass(torStateUpdateEvent, "torStateUpdateEvent");

function torStateUpdateEvent:emptyNew()
    local self = Event:new(torStateUpdateEvent_mt);
    self.className = "torStateUpdateEvent";
    return self;
end;

function torStateUpdateEvent:new(object, torid, torstate)
    local self = torStateUpdateEvent:emptyNew()
    self.object = object;
    self.torid = torid;
	self.torstate = torstate;
    return self;
end;

function torStateUpdateEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.torid = streamReadInt32(streamId);
	self.torstate = streamReadBool(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function torStateUpdateEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
    streamWriteInt32(streamId, self.torid);
	streamWriteBool(streamId, self.torstate);
end;

function torStateUpdateEvent:run(connection)
	self.object:torStateUpdate(self.torid,self.torstate,true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(torStateUpdateEvent:new(self.object, self.torid, self.torstate), nil, connection, self.object);
    end;
end;

function torStateUpdateEvent.sendEvent(object, torid, torstate, noEventSend)
    if noEventSend == nil or noEventSend == false then
        if g_server ~= nil then
            g_server:broadcastEvent(torStateUpdateEvent:new(object, torid, torstate), nil, nil, object);
        else
            g_client:getServerConnection():sendEvent(torStateUpdateEvent:new(object, torid, torstate));
        end;
    end;
end;