--Hallenkran.lua
--
--@Autor: Alex2009(www.Alex2009.de)
--
--Modifizierung erst nach rcksprache mit mir(Alex2009) erlaubt.
--Modification allowed back only after consultation with me(Alex2009).

steerStateUpdateEvent = {};
steerStateUpdateEvent_mt = Class(steerStateUpdateEvent, Event);

InitEventClass(steerStateUpdateEvent, "steerStateUpdateEvent");

function steerStateUpdateEvent:emptyNew()
    local self = Event:new(steerStateUpdateEvent_mt);
    self.className = "steerStateUpdateEvent";
    return self;
end;

function steerStateUpdateEvent:new(object, steerstate)
    local self = steerStateUpdateEvent:emptyNew()
    self.object = object;
	self.steerstate = steerstate;
    return self;
end;

function steerStateUpdateEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.steerstate = streamReadBool(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function steerStateUpdateEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.steerstate);
end;

function steerStateUpdateEvent:run(connection)
	self.object:steerStateUpdate(self.steerstate);
    if not connection:getIsServer() then
        g_server:broadcastEvent(steerStateUpdateEvent:new(self.object, self.steerstate), nil, connection, self.object);
    end;
end;

function steerStateUpdateEvent.sendEvent(object, steerstate, noEventSend)
    if noEventSend == nil or noEventSend == false then
        if g_server ~= nil then
            g_server:broadcastEvent(steerStateUpdateEvent:new(object, steerstate), nil, nil, object);
        else
            g_client:getServerConnection():sendEvent(steerStateUpdateEvent:new(object, steerstate));
        end;
    end;
end;