--soundStateUpdateEvent.lua
--
--@Autor: Alex2009
--@Web: www.alex2009.de
--@Date: 30.08.2012
--
--Modifizierung erst nach rcksprache mit mir(Alex2009) erlaubt.
--Modification allowed back only after consultation with me(Alex2009).

soundStateUpdateEvent = {};
soundStateUpdateEvent_mt = Class(soundStateUpdateEvent, Event);

InitEventClass(soundStateUpdateEvent, "soundStateUpdateEvent");

function soundStateUpdateEvent:emptyNew()
    local self = Event:new(soundStateUpdateEvent_mt);
    self.className = "soundStateUpdateEvent";
    return self;
end;

function soundStateUpdateEvent:new(object, soundID, soundState)
    local self = soundStateUpdateEvent:emptyNew()
    self.object = object;
    self.soundID = soundID;
	self.soundState = soundState;
    return self;
end;

function soundStateUpdateEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.soundID = streamReadInt32(streamId);
	self.soundState = streamReadBool(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function soundStateUpdateEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
    streamWriteInt32(streamId, self.soundID);
	streamWriteBool(streamId, self.soundState);
end;

function soundStateUpdateEvent:run(connection)
	self.object:soundStateUpdate(self.soundID,self.soundState);
    if not connection:getIsServer() then
        g_server:broadcastEvent(soundStateUpdateEvent:new(self.object, self.soundID, self.soundState), nil, connection, self.object);
    end;
end;

function soundStateUpdateEvent.sendEvent(object, soundID, soundState, noEventSend)
    if noEventSend == nil or noEventSend == false then
        if g_server ~= nil then
            g_server:broadcastEvent(soundStateUpdateEvent:new(object, soundID, soundState), nil, nil, object);
        else
            g_client:getServerConnection():sendEvent(soundStateUpdateEvent:new(object, soundID, soundState));
        end;
    end;
end;