--hallenkranMap.lua
--
--@Autor: Alex2009(www.Alex2009.de)
--
--Modifizierung erst nach rcksprache mit mir(Alex2009) erlaubt.
--Modification allowed back only after consultation with me(Alex2009).

source(Utils.getFilename("Scripte/baleUpdateEvent.lua",g_currentModDirectory));
source(Utils.getFilename("Scripte/kranUpdateEvent.lua",g_currentModDirectory));
source(Utils.getFilename("Scripte/torStateUpdateEvent.lua",g_currentModDirectory));
source(Utils.getFilename("Scripte/steerStateUpdateEvent.lua",g_currentModDirectory));
source(Utils.getFilename("Scripte/soundStateUpdateEvent.lua",g_currentModDirectory));

hallenkranMap = {};
hallenkranMap.Dir = g_currentModDirectory;
hallenkranMap_mt = Class(hallenkranMap, Object);
InitObjectClass(hallenkranMap, "hallenkranMap");

function hallenkranMap.onCreate(id)
    local object = hallenkranMap:new(g_server ~= nil, g_client ~= nil)
    if object:load(id) then
        g_currentMission:addOnCreateLoadedObject(object)
        object:register(true)
    else
        object:delete()
    end
end

function hallenkranMap:new(isServer, isClient, customMt)
    local mt = customMt
    if mt == nil then
        mt = hallenkranMap_mt
    end
    local self = Object:new(isServer, isClient, hallenkranMap_mt);
    registerObjectClassName(self, "hallenkranMap");
    self.TorID = nil;
    self.Tor1Open = false;
    self.Tor2Open = false;
    self.Tor3Open = false;
    self.Tor4Open = false;
    self.Tor5Open = false;
    self.moveAccVZ = 0;
    self.moveAccLR = 0;
    self.steerAllowed = false;
    self.steer = false;
    self.MPsteer = false;
    self.KranAktiv = true;
    self.moveSpeed = 0.070;
    self.slowSpeed = 0.060;
    self.BaleAttacherActive = false;
    self.Balecount = 0;
    self.pendingDynamicMountObjects = {};
    self.dynamicMountedObjects = {};
    if g_currentMission.kranHallen == nil then
        g_currentMission.kranHallen = {};
        table.insert(g_currentMission.kranHallen,self);
    else
        table.insert(g_currentMission.kranHallen,self);
    end;
    return self;
end;

function hallenkranMap:load(id) 
    local fileO = Utils.getFilename("GUI/Steuerpult_Fast.dds",hallenkranMap.Dir);
    self.SteuerpultFast = Overlay:new("SteuerpultFast", fileO, 0.138,0.0,0.48828,0.2907);
    local fileT = Utils.getFilename("GUI/Steuerpult_Slow.dds",hallenkranMap.Dir);
    self.SteuerpultSlow = Overlay:new("SteuerpultSlow", fileT, 0.138,0.0,0.48828,0.2907);
    
    local id = Utils.indexToObject(id,"0");
    local hallentore = getChild(id, "Hallentore");
    self.Tor1 = getChild(hallentore, "Tor1");
    self.Tor1Trigger = getChild(self.Tor1, "Trigger");
    addTrigger(self.Tor1Trigger, "triggerCallback", self);
    
    self.Tor2 = getChild(hallentore, "Tor2");
    self.Tor2Trigger = getChild(self.Tor2, "Trigger");
    addTrigger(self.Tor2Trigger, "triggerCallback", self);
    
    self.Tor3 = getChild(hallentore, "Tor3");
    self.Tor3Trigger = getChild(self.Tor3, "Trigger");
    addTrigger(self.Tor3Trigger, "triggerCallback", self);
    
    self.Tor4 = getChild(hallentore, "Tor4");
    self.Tor4Trigger = getChild(self.Tor4, "Trigger");
    addTrigger(self.Tor4Trigger, "triggerCallback", self);
    
    self.Tor5 = getChild(hallentore, "Tor5");
    self.Tor5Trigger = getChild(self.Tor5, "Trigger");
    addTrigger(self.Tor5Trigger, "triggerCallback", self);
    
    local hallenkran = getChild(id, "Hallenkran");
    if (hallenkran ~= nil) and (hallenkran ~= 0) then
        self.HallenkranTrigger = getChild(id, "HallenkranTrigger");
        addTrigger(self.HallenkranTrigger, "triggerCallback", self);
        self.VZ = getChild(hallenkran, "VZ"); 
        self.LR = getChild(self.VZ, "LR");
        self.Seil = getChild(self.LR, "Seil"); 
        self.camera = getChild(self.LR, "camera"); 
        self.HakenPos = getChild(self.Seil, "HakenPos");
        self.Haken = getChild(self.LR, "Haken");    
        self.Unterbau = getChild(self.Haken, "Unterbau");  
        self.ArmL = getChild(self.Unterbau, "LR_L");
        self.ArmLC = getCollisionMask(self.ArmL);
        self.ArmR = getChild(self.Unterbau, "LR_R");  
        self.ArmRC = getCollisionMask(self.ArmR);
        
        self.BaleTrigger = getChildAt(self.ArmL,0); 
        addTrigger(self.BaleTrigger, "baletriggerCallback", self);
        self.BaleTriggerO = getChildAt(self.ArmR,0); 
        addTrigger(self.BaleTriggerO, "baletriggerCallback", self);
        
        self.SoundVZO = getChild(self.VZ, "LRO");
        self.SoundVZT = getChild(self.VZ, "LRT");
        self.SoundLR = getChild(self.Seil, "LR");
        self.SoundHR = getChild(self.Seil, "HR");
        self.SoundAZ = getChild(self.Unterbau, "AZ");
        self.SoundRL = getChild(self.Unterbau, "RL");
        setVisibility(self.SoundVZO,false);
        setVisibility(self.SoundVZT,false);
        setVisibility(self.SoundLR,false);
        setVisibility(self.SoundHR,false);
        setVisibility(self.SoundAZ,false);
        setVisibility(self.SoundRL,false);
        self.SampleVZO = getAudioSourceSample(getChild(self.VZ, "LRO"));
        self.SampleVZT = getAudioSourceSample(getChild(self.VZ, "LRT"));
        self.SampleLR = getAudioSourceSample(getChild(self.Seil, "LR"));
        --------------
        self.SoundVZOE = false;
        self.SoundVZTE = false;
        self.SoundLRE = false;
        self.SoundHRE = false;
        self.SoundAZE = false;
        self.SoundRLE = false;
        --------------
    end;
    
    g_currentMission:addNodeObject(id, self);
	g_currentMission:addOnCreateLoadedObjectToSave(self);
	
    return true;
end;

function hallenkranMap:delete()
    unregisterObjectClassName(self);
    if self.steer then
        setCamera(0, 1);
    end;
    for object,_ in pairs(self.dynamicMountedObjects) do
        if self.dynamicMountedObjects[object] ~= nil then
            self.dynamicMountedObjects[object] = nil;
            object:unmountDynamic();
        end
    end  
    self:stopKranSounds();
    removeTrigger(self.BaleTrigger);
    removeTrigger(self.BaleTriggerO);
	removeTrigger(self.Tor1Trigger);
    removeTrigger(self.Tor2Trigger);
    removeTrigger(self.Tor3Trigger);
    removeTrigger(self.Tor4Trigger);
    removeTrigger(self.Tor5Trigger);   
    removeTrigger(self.HallenkranTrigger);
    self:stopKranSounds()
    for i,tself in pairs(g_currentMission.kranHallen) do
        if tself == self then
            table.remove(g_currentMission.kranHallen,i);
            break;
        end;
    end;
end;

function hallenkranMap:readStream(streamId, connection)
    if connection:getIsServer() then
        self.MPsteer = streamReadBool(streamId);
        local pos1 = streamReadFloat32(streamId);
        local pos2 = streamReadFloat32(streamId);
        local pos3 = streamReadFloat32(streamId);
        local pos4 = streamReadFloat32(streamId);
        local pos5 = streamReadFloat32(streamId);
        local pos6 = streamReadFloat32(streamId);
        self:kranUpdate(pos1, pos2, pos3, pos4, pos5, pos6);
        self.Tor1Open = streamReadBool(streamId);
        self.Tor2Open = streamReadBool(streamId);
        self.Tor3Open = streamReadBool(streamId);
        self.Tor4Open = streamReadBool(streamId);
        self.Tor5Open = streamReadBool(streamId);
        local grabState = streamReadBool(streamId);
        self:grabStateUpdate(grabState,true);
        local x,y,z = getTranslation(self.Tor5);
        if (not self.Tor5Open and (z > -42.8547)) then
            setTranslation(self.Tor5,x,y,-42.8547);
        elseif (self.Tor5Open and (z < -35.41066)) then
            setTranslation(self.Tor5,x,y,-35.41066);
        end;
        local x,y,z = getTranslation(self.Tor4);
        if (not self.Tor4Open and (x < 7.00399)) then
            setTranslation(self.Tor4,7.00399,y,z);
        elseif (self.Tor4Open and (x > -0.5382)) then
            setTranslation(self.Tor4,-0.5382,y,z);
        end;
        local x,y,z = getTranslation(self.Tor3);
        if (not self.Tor3Open and (x > -0.94905)) then
            setTranslation(self.Tor3,-0.94905,y,z);
        elseif (self.Tor3Open and (x < 6.15077)) then
            setTranslation(self.Tor3,6.15077,y,z);
        end;
        local x,y,z = getTranslation(self.Tor2);
        if (not self.Tor2Open and (x < 23.767)) then
            setTranslation(self.Tor2,23.767,y,z);
        elseif (self.Tor2Open and (x > 16.09301)) then
            setTranslation(self.Tor2,16.09301,y,z);
        end;
        local x,y,z = getTranslation(self.Tor1);
        if (not self.Tor1Open and (x > 15.273)) then
            setTranslation(self.Tor1,15.273,y,z);
        elseif (self.Tor1Open and (x < 22.39217)) then
            setTranslation(self.Tor1,22.39217,y,z);
        end;
    end;
end

function hallenkranMap:writeStream(streamId, connection)
    if not connection:getIsServer() then
        if self.steer then
            streamWriteBool(streamId, true);
        else
            streamWriteBool(streamId, self.MPsteer);
        end;
        local vzx,vzy,vzz = getTranslation(self.VZ);
        local lrx,lry,lrz = getTranslation(self.LR);
        local sx,sy,sz = getScale(self.Seil);
        local rx,ry,rz = getRotation(self.Unterbau);
        local ALx,ALy,ALz = getTranslation(self.ArmL);
        local ARx,ARy,ARz = getTranslation(self.ArmR);      
        streamWriteFloat32(streamId, vzx);
        streamWriteFloat32(streamId, lrz);
        streamWriteFloat32(streamId, sy);
        streamWriteFloat32(streamId, ry);
        streamWriteFloat32(streamId, ALx);
        streamWriteFloat32(streamId, ARx);
        streamWriteBool(streamId, self.Tor1Open);
        streamWriteBool(streamId, self.Tor2Open);
        streamWriteBool(streamId, self.Tor3Open);
        streamWriteBool(streamId, self.Tor4Open);
        streamWriteBool(streamId, self.Tor5Open);
        streamWriteBool(streamId, self.BaleAttacherActive);
    end;
end

function hallenkranMap:deleteFinal()
end;

function hallenkranMap:update(dt)      
    if self.TorID ~= nil then
        g_currentMission:addHelpButtonText(g_i18n:getText("TorO"), InputBinding.T_O);
        if InputBinding.hasEvent(InputBinding.T_O) then
            self:torStateUpdate(self.TorID);
        end;
    end;
    if self.KranAktiv and self.steerAllowed then
        if (not self.MPsteer) or (self.steer and self.MPsteer) then
            if InputBinding.hasEvent(InputBinding.Steer) then
                self.steer = not self.steer;
                steerStateUpdateEvent.sendEvent(self, self.steer);
                if self.steer then
                    local node = getRootNode();
                    setRootNode(node, 1);
                    setCamera(self.camera, 1);
                    setViewport(1, 0.279, 0.734, 0.208, 0.195);
                else
                    setCamera(0, 1);
                end;
            end;
        end;
        if self.steer then
            g_currentMission:addHelpButtonText(g_i18n:getText("steerD"), InputBinding.Steer);
            if self.Balecount > 0 then
                if self.BaleAttacherActive then
                    g_currentMission:addHelpButtonText(g_i18n:getText("Bale_Deattach"), InputBinding.ATB);
                else
                    g_currentMission:addHelpButtonText(g_i18n:getText("Bale_Attach"), InputBinding.ATB);
                end;
            end;
            if InputBinding.hasEvent(InputBinding.HK_S) then
                if (self.moveSpeed == 0.070) then
                    self.moveSpeed = 0.025;
                    self.slowSpeed = 0.020;
                else
                    self.moveSpeed = 0.070;
                    self.slowSpeed = 0.060;        
                end;
            end;

            if InputBinding.hasEvent(InputBinding.ATB) then
                self:grabStateUpdate(not self.BaleAttacherActive);
            end;
            
            if InputBinding.isPressed(InputBinding.VZ_Z) and not InputBinding.isPressed(InputBinding.VZ_V) then
                if self.moveAccVZ < 1 then
                    self.moveAccVZ = self.moveAccVZ + (dt/4500);
                end;
                local x,y,z = getTranslation(self.VZ);
                if ((x+((dt/10000)+(self.moveSpeed*self.moveAccVZ))) <= 3.0282) then                   
                    setVisibility(self.SoundVZO,true);
                    setVisibility(self.SoundVZT,true);
                    if not self.SoundVZOE then
                        self.SoundVZOE = true;
                        soundStateUpdateEvent.sendEvent(self, 1, true)
                    end;
                    if not self.SoundVZTE then
                        self.SoundVZTE = true;
                        soundStateUpdateEvent.sendEvent(self, 2, true)
                    end;
                    setSamplePitch(self.SampleVZO,self.moveAccVZ);
                    setSamplePitch(self.SampleVZT,self.moveAccVZ);
                    setTranslation(self.VZ,(x+((dt/10000)+(self.moveSpeed*self.moveAccVZ))),y,z);
                else
                    if self.SoundVZOE then
                        self.SoundVZOE = false;
                        soundStateUpdateEvent.sendEvent(self, 1, false)
                    end;
                    if self.SoundVZTE then
                        self.SoundVZTE = false;
                        soundStateUpdateEvent.sendEvent(self, 2, false)
                    end;
                    setVisibility(self.SoundVZO,false);
                    setVisibility(self.SoundVZT,false);
                end;
            elseif InputBinding.isPressed(InputBinding.VZ_V) and not InputBinding.isPressed(InputBinding.VZ_Z) then
                if self.moveAccVZ < 1 then
                    self.moveAccVZ = self.moveAccVZ + (dt/2500);
                end;
                local x,y,z = getTranslation(self.VZ);
                if ((x-((dt/10000)+(self.moveSpeed*self.moveAccVZ))) >= -33.16811) then
                    setVisibility(self.SoundVZO,true);
                    setVisibility(self.SoundVZT,true);
                    if not self.SoundVZOE then
                        self.SoundVZOE = true;
                        soundStateUpdateEvent.sendEvent(self, 1, true)
                    end;
                    if not self.SoundVZTE then
                        self.SoundVZTE = true;
                        soundStateUpdateEvent.sendEvent(self, 2, true)
                    end;
                    setSamplePitch(self.SampleVZO,self.moveAccVZ);
                    setSamplePitch(self.SampleVZT,self.moveAccVZ);
                    setTranslation(self.VZ,(x-((dt/10000)+(self.moveSpeed*self.moveAccVZ))),y,z);
                else
                    if self.SoundVZOE then
                        self.SoundVZOE = false;
                        soundStateUpdateEvent.sendEvent(self, 1, false)
                    end;
                    if self.SoundVZTE then
                        self.SoundVZTE = false;
                        soundStateUpdateEvent.sendEvent(self, 2, false)
                    end;
                    setVisibility(self.SoundVZO,false);
                    setVisibility(self.SoundVZT,false);
                end;
            else
                if self.SoundVZOE then
                    self.SoundVZOE = false;
                    soundStateUpdateEvent.sendEvent(self, 1, false)
                end;
                if self.SoundVZTE then
                    self.SoundVZTE = false;
                    soundStateUpdateEvent.sendEvent(self, 2, false)
                end;
                self.moveAccVZ = 0;
                setVisibility(self.SoundVZO,false);
                setVisibility(self.SoundVZT,false);
            end;        
            if InputBinding.isPressed(InputBinding.LR_L) and not InputBinding.isPressed(InputBinding.LR_R) then
                if self.moveAccLR < 1 then
                    self.moveAccLR = self.moveAccLR + (dt/2500);
                end;
                local x,y,z = getTranslation(self.LR);
                if ((z+((dt/10000)+(self.moveSpeed*self.moveAccLR))) <= 10.89417) then
                    setVisibility(self.SoundLR,true);
                    if not self.SoundLRE then
                        self.SoundLRE = true;
                        soundStateUpdateEvent.sendEvent(self, 3, true)
                    end;
                    setSamplePitch(self.SampleLR,self.moveAccLR);
                    setTranslation(self.LR,x,y,(z+((dt/10000)+(self.moveSpeed*self.moveAccLR))));
                else
                    setVisibility(self.SoundLR,false);
                    if self.SoundLRE then
                        self.SoundLRE = false;
                        soundStateUpdateEvent.sendEvent(self, 3, false)
                    end;
                end;
            elseif InputBinding.isPressed(InputBinding.LR_R) and not InputBinding.isPressed(InputBinding.LR_L) then
                if self.moveAccLR < 1 then
                    self.moveAccLR = self.moveAccLR + (dt/2500);
                end;
                local x,y,z = getTranslation(self.LR);
                if ((z-((dt/10000)+(self.moveSpeed*self.moveAccLR))) >= -12.91583) then
                    setVisibility(self.SoundLR,true);
                    if not self.SoundLRE then
                        self.SoundLRE = true;
                        soundStateUpdateEvent.sendEvent(self, 3, true)
                    end;
                    setSamplePitch(self.SampleLR,self.moveAccLR);
                    setTranslation(self.LR,x,y,(z-((dt/10000)+(self.moveSpeed*self.moveAccLR))));
                else
                    setVisibility(self.SoundLR,false);
                    if self.SoundLRE then
                        self.SoundLRE = false;
                        soundStateUpdateEvent.sendEvent(self, 3, false)
                    end;
                end;
            else
                self.moveAccLR = 0;
                setVisibility(self.SoundLR,false);
                if self.SoundLRE then
                    self.SoundLRE = false;
                    soundStateUpdateEvent.sendEvent(self, 3, false)
                end;
            end;
            if InputBinding.isPressed(InputBinding.S_M) then
                local x,y,z = getScale(self.Seil);
                if ((y+((dt/10000)+self.moveSpeed)) <= 1.25) then
                    setVisibility(self.SoundHR,true);
                    if not self.SoundHRE then
                        self.SoundHRE = true;
                        soundStateUpdateEvent.sendEvent(self, 4, true)  
                    end;
                    setScale(self.Seil,x,(y+((dt/10000)+(self.moveSpeed-self.slowSpeed))),z);
                    local wx,wy,wz = getWorldTranslation(self.HakenPos);
                    setTranslation(self.Haken,worldToLocal(self.LR,wx,wy,wz));
                else
                    setVisibility(self.SoundHR,false);
                    if self.SoundHRE then
                        self.SoundHRE = false;
                        soundStateUpdateEvent.sendEvent(self, 4, false)  
                    end;
                end;
            elseif InputBinding.isPressed(InputBinding.S_P) then
                local x,y,z = getScale(self.Seil);
                if ((y-((dt/10000)+self.moveSpeed)) >= 0.07) then
                    setVisibility(self.SoundHR,true);
                    setScale(self.Seil,x,(y-((dt/10000)+(self.moveSpeed-self.slowSpeed))),z);
                    local wx,wy,wz = getWorldTranslation(self.HakenPos);
                    setTranslation(self.Haken,worldToLocal(self.LR,wx,wy,wz));
                    if not self.SoundHRE then
                        self.SoundHRE = true;
                        soundStateUpdateEvent.sendEvent(self, 4, true)  
                    end;
                else
                    setVisibility(self.SoundHR,false);
                    if self.SoundHRE then
                        self.SoundHRE = false;
                        soundStateUpdateEvent.sendEvent(self, 4, false)  
                    end;
                end;
            else
                setVisibility(self.SoundHR,false);
                if self.SoundHRE then
                    self.SoundHRE = false;
                    soundStateUpdateEvent.sendEvent(self, 4, false)  
                end;
            end;
            if InputBinding.isPressed(InputBinding.R_L) then
                setVisibility(self.SoundRL,true);
                if not self.SoundRLE then
                    self.SoundRLE = true;
                    soundStateUpdateEvent.sendEvent(self, 6, true)  
                end;
                local x,y,z = getRotation(self.Unterbau);
                setRotation(self.Unterbau,x,(y+((dt/10000)+(self.moveSpeed-self.slowSpeed))),z);
            elseif InputBinding.isPressed(InputBinding.R_R) then
                setVisibility(self.SoundRL,true);
                if not self.SoundRLE then
                    self.SoundRLE = true;
                    soundStateUpdateEvent.sendEvent(self, 6, true)  
                end;
                local x,y,z = getRotation(self.Unterbau);
                setRotation(self.Unterbau,x,(y-((dt/10000)+(self.moveSpeed-self.slowSpeed))),z);
            else
                setVisibility(self.SoundRL,false);
                if self.SoundRLE then
                    self.SoundRLE = false;
                    soundStateUpdateEvent.sendEvent(self, 6, false)  
                end;
            end;
            if InputBinding.isPressed(InputBinding.L_P) then
                local x,y,z = getTranslation(self.ArmL);
                if((x-((dt/10000)+(self.moveSpeed-self.slowSpeed))) >=-14.77266) then
                    setVisibility(self.SoundAZ,true);
                    if not self.SoundAZE then
                        self.SoundAZE = true;
                        soundStateUpdateEvent.sendEvent(self, 5, true)  
                    end;
                    setTranslation(self.ArmL,(x-((dt/10000)+(self.moveSpeed-self.slowSpeed))),y,z);
                    local x,y,z = getTranslation(self.ArmR);
                    setTranslation(self.ArmR,(x+((dt/10000)+(self.moveSpeed-self.slowSpeed))),y,z);
                else
                    setVisibility(self.SoundAZ,false);
                    if self.SoundAZE then
                        self.SoundAZE = false;
                        soundStateUpdateEvent.sendEvent(self, 5, false)  
                    end;
                end;
            elseif InputBinding.isPressed(InputBinding.L_M) then
                local x,y,z = getTranslation(self.ArmL);
                if((x+((dt/10000)+(self.moveSpeed-self.slowSpeed))) <=-14.177) then
                    setVisibility(self.SoundAZ,true);
                    if not self.SoundAZE then
                        self.SoundAZE = true;
                        soundStateUpdateEvent.sendEvent(self, 5, true)  
                    end;
                    setTranslation(self.ArmL,(x+((dt/10000)+(self.moveSpeed-self.slowSpeed))),y,z);
                    local x,y,z = getTranslation(self.ArmR);
                    setTranslation(self.ArmR,(x-((dt/10000)+(self.moveSpeed-self.slowSpeed))),y,z);
                else
                    setVisibility(self.SoundAZ,false);
                    if self.SoundAZE then
                        self.SoundAZE = false;
                        soundStateUpdateEvent.sendEvent(self, 5, false)  
                    end;
                end;
            else
                setVisibility(self.SoundAZ,false);
                if self.SoundAZE then
                    self.SoundAZE = false;
                    soundStateUpdateEvent.sendEvent(self, 5, false)  
                end;
            end;
            local vzx,vzy,vzz = getTranslation(self.VZ);
            local lrx,lry,lrz = getTranslation(self.LR);
            local sx,sy,sz = getScale(self.Seil);
            local rx,ry,rz = getRotation(self.Unterbau);
            local ALx,ALy,ALz = getTranslation(self.ArmL);
            local ARx,ARy,ARz = getTranslation(self.ArmR);
            kranUpdateEvent.sendEvent(self, vzx, lrz, sy, ry, ALx, ARx);
        else
            if not self.MPsteer then
                g_currentMission:addHelpButtonText(g_i18n:getText("steerE"), InputBinding.Steer);
            end;
        end;
    end;
    
    local x,y,z = getTranslation(self.Tor5);
    if (not self.Tor5Open and (z > -42.8547)) then
        setTranslation(self.Tor5,x,y,(z-(dt/1100)));
    elseif (self.Tor5Open and (z < -35.41066)) then
        setTranslation(self.Tor5,x,y,(z+(dt/1100)));
    end;
    local x,y,z = getTranslation(self.Tor4);
    if (not self.Tor4Open and (x < 7.00399)) then
        setTranslation(self.Tor4,(x+(dt/1100)),y,z);
    elseif (self.Tor4Open and (x > -0.5382)) then
        setTranslation(self.Tor4,(x-(dt/1100)),y,z);
    end;
    local x,y,z = getTranslation(self.Tor3);
    if (not self.Tor3Open and (x > -0.94905)) then
        setTranslation(self.Tor3,(x-(dt/1100)),y,z);
    elseif (self.Tor3Open and (x < 6.15077)) then
        setTranslation(self.Tor3,(x+(dt/1100)),y,z);
    end;
    local x,y,z = getTranslation(self.Tor2);
    if (not self.Tor2Open and (x < 23.767)) then
        setTranslation(self.Tor2,(x+(dt/1100)),y,z);
    elseif (self.Tor2Open and (x > 16.09301)) then
        setTranslation(self.Tor2,(x-(dt/1100)),y,z);
    end;
    local x,y,z = getTranslation(self.Tor1);
    if (not self.Tor1Open and (x > 15.273)) then
        setTranslation(self.Tor1,(x-(dt/1100)),y,z);
    elseif (self.Tor1Open and (x < 22.39217)) then
        setTranslation(self.Tor1,(x+(dt/1100)),y,z);
    end;
end;

local old_FSBaseMissionDraw = FSBaseMission.draw;
FSBaseMission.draw = function(self)
    old_FSBaseMissionDraw(self)
    if g_currentMission.kranHallen ~= nil and self.isRunning and g_gui.currentGui == nil then
        for _,tself in pairs(g_currentMission.kranHallen) do
            if tself.steer then
                if tself.moveSpeed >= 0.070 then
                    tself.SteuerpultFast:render();
                else
                    tself.SteuerpultSlow:render();
                end;
            end;
        end;
    end;
end;

function hallenkranMap:updateTick()    
end;

function hallenkranMap:torStateUpdate(id,state,mpevent)
    if mpevent then
        if (id==1) then
            self.Tor1Open = state;
        elseif (id==2) then
            self.Tor2Open = state;
        elseif (id==3) then
            self.Tor3Open = state;
        elseif (id==4) then
            self.Tor4Open = state;
        elseif (id==5) then
            self.Tor5Open = state;
        end;
    else
        if (id==1) then
            self.Tor1Open = not self.Tor1Open;
            torStateUpdateEvent.sendEvent(self, id, self.Tor1Open);
        elseif (id==2) then
            self.Tor2Open = not self.Tor2Open;
            torStateUpdateEvent.sendEvent(self, id, self.Tor2Open);
        elseif (id==3) then
            self.Tor3Open = not self.Tor3Open;
            torStateUpdateEvent.sendEvent(self, id, self.Tor3Open);
        elseif (id==4) then
            self.Tor4Open = not self.Tor4Open;
            torStateUpdateEvent.sendEvent(self, id, self.Tor4Open);
        elseif (id==5) then
            self.Tor5Open = not self.Tor5Open;
            torStateUpdateEvent.sendEvent(self, id, self.Tor5Open);
        end;
    end;
end;

function hallenkranMap:soundStateUpdate(id,state)
    if id == 1 then
        setVisibility(self.SoundVZO,state);
        setSamplePitch(self.SampleVZO,0.5);
    elseif id == 2 then
        setVisibility(self.SoundVZT,state);
        setSamplePitch(self.SampleVZT,0.5);
    elseif id == 3 then
        setVisibility(self.SoundLR,state);
        setSamplePitch(self.SampleLR,0.5);
    elseif id == 4 then
        setVisibility(self.SoundHR,state);
    elseif id == 5 then
        setVisibility(self.SoundAZ,state);
    elseif id == 6 then
        setVisibility(self.SoundRL,state);
    end;
end;

function hallenkranMap:addDynamicMountedObject(object)
    self.dynamicMountedObjects[object] = object;
end;

function hallenkranMap:removeDynamicMountedObject(object,del)
end;
 
function hallenkranMap:baletriggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
    if onEnter and not self.BaleAttacherActive then
        for _,ballen in pairs(g_currentMission.itemsToSave) do
            if ballen.item.nodeId == otherId then
                if self.pendingDynamicMountObjects[ballen.item] == nil then
                    self.pendingDynamicMountObjects[ballen.item] = ballen.item;
                    self.Balecount = self.Balecount + 1;
                end;
            end;
        end;
    elseif onLeave and not self.BaleAttacherActive then
        for _,ballen in pairs(g_currentMission.itemsToSave) do
            if ballen.item.nodeId == otherId then
                if self.pendingDynamicMountObjects[ballen.item] ~= nil then
                    self.pendingDynamicMountObjects[ballen.item] = nil;
                    self.Balecount = math.max(self.Balecount-1,0);
                end;
            end;
        end;
    end;
end;

function hallenkranMap:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
    local vehicle = g_currentMission.nodeToVehicle[otherShapeId];
    if vehicle ~= nil and g_currentMission.controlledVehicle ~= nil and g_currentMission.controlledVehicle == vehicle then
        if self.KranAktiv then
            if (triggerId == self.HallenkranTrigger) then
                if onLeave then
                    if self.steer then
                        self.steer = false;
                        steerStateUpdateEvent.sendEvent(self, self.steer);
                        self.steerAllowed = false;
                        setCamera(0, 1);
                        self:stopKranSounds();
                    elseif self.steerAllowed then
                        self.steerAllowed = false;
                    end;
                end;
            end;
        end;
        if (triggerId == self.Tor5Trigger) then
            if onLeave then
                self.TorID = nil;
            end;
        elseif (triggerId == self.Tor4Trigger) then
            if onLeave then
                self.TorID = nil;
            end;
        elseif (triggerId == self.Tor3Trigger) then
            if onLeave then
                self.TorID = nil;
            end;
        elseif (triggerId == self.Tor2Trigger) then
            if onLeave then
                self.TorID = nil;
            end;
        elseif (triggerId == self.Tor1Trigger) then
            if onLeave then
                self.TorID = nil;
            end;
        end;        
    else
        if g_currentMission.controlPlayer and g_currentMission.player ~= nil then
            if otherId == g_currentMission.player.rootNode then
                if self.KranAktiv then
                    if (triggerId == self.HallenkranTrigger) then
                        if onEnter then
                            self.steerAllowed = true;
                        elseif onLeave then
                            if self.steer then
                                self.steer = false;
                                steerStateUpdateEvent.sendEvent(self, self.steer);
                                self.steerAllowed = false;
                                setCamera(0, 1);
                                self:stopKranSounds();
                            elseif self.steerAllowed then
                                self.steerAllowed = false;
                            end;
                        end;
                    end;
                end;
                if (triggerId == self.Tor5Trigger) then
                    if onEnter then
                        self.TorID = 5;
                    elseif onLeave then
                        self.TorID = nil;
                    end;
                elseif (triggerId == self.Tor4Trigger) then
                    if onEnter then
                        self.TorID = 4;
                    elseif onLeave then
                        self.TorID = nil;
                    end;
                elseif (triggerId == self.Tor3Trigger) then
                    if onEnter then
                        self.TorID = 3;
                    elseif onLeave then
                        self.TorID = nil;
                    end;
                elseif (triggerId == self.Tor2Trigger) then
                    if onEnter then
                        self.TorID = 2;
                    elseif onLeave then
                        self.TorID = nil;
                    end;
                elseif (triggerId == self.Tor1Trigger) then
                    if onEnter then
                        self.TorID = 1;
                    elseif onLeave then
                        self.TorID = nil;
                    end;
                end;
            end;
        end;
    end;
end;

local old_toggleVehicle = BaseMission.toggleVehicle;
BaseMission.toggleVehicle = function(self,delta)
    old_toggleVehicle(self,delta);
    if not self.isToggleVehicleAllowed then
        return
    end
    local numVehicles = table.getn(self.steerables)
    if numVehicles > 0 then
        if g_currentMission.kranHallen ~= nil then
            for _,tself in pairs(g_currentMission.kranHallen) do
                if tself.steer then
                    tself.steer = false;
                    steerStateUpdateEvent.sendEvent(tself, tself.steer);
                    tself.steerAllowed = false;
                    setCamera(0, 1);
                    tself:stopKranSounds();
                elseif tself.steerAllowed then
                    tself.steerAllowed = false;
                end;
                tself.TorID = nil;
            end;
        end;
    end;
end;

function hallenkranMap:stopKranSounds()
    setVisibility(self.SoundVZO,false);
    setVisibility(self.SoundVZT,false);
    setVisibility(self.SoundLR,false);
    setVisibility(self.SoundHR,false);
    setVisibility(self.SoundAZ,false);
    setVisibility(self.SoundRL,false);
end;

function hallenkranMap:steerStateUpdate(state)
    self.MPsteer = state;
    self.SoundVZOE = false;
    self.SoundVZTE = false;
    self.SoundLRE = false;
    self.SoundHRE = false;
    self.SoundAZE = false;
    self.SoundRLE = false;
    self:stopKranSounds();
end;

function hallenkranMap:kranUpdate(pos1, pos2, pos3, pos4, pos5, pos6)
    local x,y,z = getTranslation(self.VZ);
    setTranslation(self.VZ,pos1,y,z);             
    local x,y,z = getTranslation(self.LR);
    setTranslation(self.LR,x,y,pos2);
    local x,y,z = getScale(self.Seil);
    setScale(self.Seil,x,pos3,z);
    local wx,wy,wz = getWorldTranslation(self.HakenPos);
    setTranslation(self.Haken,worldToLocal(self.LR,wx,wy,wz));
    local x,y,z = getRotation(self.Unterbau);
    setRotation(self.Unterbau,x,pos4,z);
    local x,y,z = getTranslation(self.ArmL);
    setTranslation(self.ArmL,pos5,y,z);
    local x,y,z = getTranslation(self.ArmR);
    setTranslation(self.ArmR,pos6,y,z); 
end;

function hallenkranMap:grabStateUpdate(grabState,mpevent)
    baleUpdateEvent.sendEvent(self, grabState, mpevent)
    self.BaleAttacherActive = grabState;
    if grabState then
        setCollisionMask(self.ArmL,0);
        setCollisionMask(self.ArmR,0);
        setRigidBodyType(self.ArmL,"NoRigidBody");
        setRigidBodyType(self.ArmR,"NoRigidBody");
    else
        setRigidBodyType(self.ArmL,"Kinematic");
        setRigidBodyType(self.ArmR,"Kinematic");
        setCollisionMask(self.ArmL,self.ArmLC);
        setCollisionMask(self.ArmR,self.ArmRC);
    end;
    if self.BaleAttacherActive then
        for object,_ in pairs(self.pendingDynamicMountObjects) do
            if self.dynamicMountedObjects[object] == nil then
                if object:mountDynamic(self, self.BaleTrigger, self.Unterbau, false, 1, true) then
                    self:addDynamicMountedObject(object);
                end
            end
        end
    elseif self.Balecount > 0 then
        for object,_ in pairs(self.dynamicMountedObjects) do
            if self.dynamicMountedObjects[object] ~= nil then
                self.dynamicMountedObjects[object] = nil;
                object:unmountDynamic();
            end
        end        
    end;
end;

local oldMountDynamicObject = MountableObject.mountDynamic;
MountableObject.mountDynamic = function(self, object, objectActorId, jointNode, singleAxisMovement, forceLimitScale, special)
 if special ~= nil then
     if not self:getSupportsMountDynamic() or self.mountObject ~= nil or self.dynamicMountObject ~= nil then
         return false;
     end
     local constr = JointConstructor:new();
     constr:setActors(objectActorId, self.nodeId);
     constr:setJointTransforms(jointNode, jointNode);
     constr:setRotationLimit(0, 0, 0);
     constr:setRotationLimit(1, 0, 0);
     constr:setRotationLimit(2, 0, 0);
     constr:setTranslationLimit(0, true, 0, 0);
     constr:setTranslationLimit(1, true, 0, 0);
     constr:setTranslationLimit(2, true, 0, 0);
     constr:setEnableCollision(true);
     self.dynamicMountJointIndex = constr:finalize();
     self.dynamicMountObjectActorId = objectActorId;
     self.dynamicMountObject = object;
     self.dynamicMountObject:addDynamicMountedObject(self);
     return true;
 else
    return oldMountDynamicObject(self, object, objectActorId, jointNode, singleAxisMovement, forceLimitScale);
 end;
end

function hallenkranMap:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
    if self.KranAktiv and (getXMLFloat(xmlFile,key.."#VZ") ~= nil) then
        local vz = getXMLFloat(xmlFile,key.."#VZ");
        local x,y,z = getTranslation(self.VZ);
        setTranslation(self.VZ,vz,y,z);
        
        local lr = getXMLFloat(xmlFile,key.."#LR");
        local x,y,z = getTranslation(self.LR);
        setTranslation(self.LR,x,y,lr);
        
        local sc = getXMLFloat(xmlFile,key.."#SC");
        local x,y,z = getScale(self.Seil);
        setScale(self.Seil,x,sc,z);
        local wx,wy,wz = getWorldTranslation(self.HakenPos);
        setTranslation(self.Haken,worldToLocal(self.LR,wx,wy,wz));
        
        local ry = getXMLFloat(xmlFile,key.."#RZ");
        local x,y,z = getRotation(self.Unterbau);
        setRotation(self.Unterbau,x,ry,z);

        local ALx = getXMLFloat(xmlFile,key.."#AL");
        local x,y,z = getTranslation(self.ArmL);
        setTranslation(self.ArmL,ALx,y,z);

        local ARx = getXMLFloat(xmlFile,key.."#AR");
        local x,y,z = getTranslation(self.ArmR);
        setTranslation(self.ArmR,ARx,y,z);    
    end;
    if (getXMLBool(xmlFile,key.."#Tor1") ~= nil) then
        self.Tor1Open = getXMLBool(xmlFile,key.."#Tor1");
        self.Tor2Open = getXMLBool(xmlFile,key.."#Tor2");
        self.Tor3Open = getXMLBool(xmlFile,key.."#Tor3");
        self.Tor4Open = getXMLBool(xmlFile,key.."#Tor4");
        self.Tor5Open = getXMLBool(xmlFile,key.."#Tor5"); 
        local x,y,z = getTranslation(self.Tor5);
        if (not self.Tor5Open and (z > -42.8547)) then
            setTranslation(self.Tor5,x,y,-42.8547);
        elseif (self.Tor5Open and (z < -35.41066)) then
            setTranslation(self.Tor5,x,y,-35.41066);
        end;
        local x,y,z = getTranslation(self.Tor4);
        if (not self.Tor4Open and (x < 7.00399)) then
            setTranslation(self.Tor4,7.00399,y,z);
        elseif (self.Tor4Open and (x > -0.5382)) then
            setTranslation(self.Tor4,-0.5382,y,z);
        end;
        local x,y,z = getTranslation(self.Tor3);
        if (not self.Tor3Open and (x > -0.94905)) then
            setTranslation(self.Tor3,-0.94905,y,z);
        elseif (self.Tor3Open and (x < 6.15077)) then
            setTranslation(self.Tor3,6.15077,y,z);
        end;
        local x,y,z = getTranslation(self.Tor2);
        if (not self.Tor2Open and (x < 23.767)) then
            setTranslation(self.Tor2,23.767,y,z);
        elseif (self.Tor2Open and (x > 16.09301)) then
            setTranslation(self.Tor2,16.09301,y,z);
        end;
        local x,y,z = getTranslation(self.Tor1);
        if (not self.Tor1Open and (x > 15.273)) then
            setTranslation(self.Tor1,15.273,y,z);
        elseif (self.Tor1Open and (x < 22.39217)) then
            setTranslation(self.Tor1,22.39217,y,z);
        end;
    end;
    return true
end

function hallenkranMap:getSaveAttributesAndNodes(nodeIdent)
    local vzx,vzy,vzz = getTranslation(self.VZ);
    local lrx,lry,lrz = getTranslation(self.LR);
    local sx,sy,sz = getScale(self.Seil);
    local rx,ry,rz = getRotation(self.Unterbau);
    local ALx,ALy,ALz = getTranslation(self.ArmL);
    local ARx,ARy,ARz = getTranslation(self.ArmR);
    local attributes = "";
    local nodes = "";
    attributes = attributes .. ' VZ="'..vzx..'" LR="'..lrz..'" SC="'..sy..'" RZ="'..ry..'" AL="'..ALx..'" AR="'..ARx..'"';
    attributes = attributes .. ' Tor1="'..tostring(self.Tor1Open)..'" Tor2="'..tostring(self.Tor2Open)..'" Tor3="'..tostring(self.Tor3Open)..'"';
    attributes = attributes .. ' Tor4="'..tostring(self.Tor4Open)..'" Tor5="'..tostring(self.Tor5Open)..'"';
    return attributes, nodes
end
g_onCreateUtil.addOnCreateFunction("hallenkranMap", hallenkranMap.onCreate);