﻿-- ##############################################
-- #	Custom Info Trigger						#
-- #	version: v1.4							#
-- #	Date: 02.09.2013						#
-- #	author: [FSM]Webby /[FSM]Chefkoch		#
-- # 	Keine Veränderung ohne					# 
-- # 	meine Erlaubnis!						#
-- # 	No modification without					# 
-- # 	my permission!							#
-- #											#
-- #	MEGA THX 2:								#
-- #											#
-- #	Bluebaby210 (to save a XML in 			#
-- #	savegame for found Triggers) and much	#
-- #	more Stuff in this Script :)			#
-- #											#
-- #	Fiat80-90DT								#
-- #	@planet-ls.de							#
-- #											#
-- #	Ls-2013Modding							#
-- #	http://facebook.com/Ls2013Modding		#
-- #											#
-- #											#
-- #	4 helping me out 						#
-- #	with this Script						#
-- #											#
-- #	History:								#
-- #	v1.0 = Projekt started					#
-- #	v1.1 = Nomore HelpIcons in MP			#
-- #	v1.2 = variable TimeToShow				#
-- #	v1.3 = Nomore HelpIcons after Mapreload #
-- #    v1.4 = added UserAttributes Resurrect & #
-- #		  activeTime - modified by Sven777b #
-- #		  with permission					#
-- #											#
-- ############################################## 

print("CustomInfoTrigger v1.4 by [FSM]Chefkoch loaded!	UserAttributes Resurrect & activeTime - modified by Sven777b with permission , Save and Load from XML by Bluebaby210")

ModEvent = {};

ModEvent.triggers = {};

function ModEvent:loadMap(name)

	local dir = getUserProfileAppPath() .. "savegame"..g_currentMission.missionInfo.savegameIndex;
	createFolder(dir);
	self.saveXMLFile = dir .. "/CustomInfoTrigger.xml";

	if g_currentMission.missionStats.playTime == 0 then
		self.firstRun = false;
	else
		self.firstRun = true;
	end;

end;

function ModEvent:deleteMap()	
	ModEvent.triggers = {};
end;

function ModEvent:delete()
end;

function ModEvent:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ModEvent:keyEvent(unicode, sym, modifier, isDown)
end;

function ModEvent:update(dt)

		if self.firstRun then
			ModEvent:loadCustomInfoTriggerFromXML();
			self.firstRun = false;			
		end;
		
end;

function ModEvent:draw()
	for i=1, table.getn(ModEvent.triggers) do
		ModEvent.triggers[i]:draw();
	end;
end;

local CareerScreenSaveSelectedGame = CareerScreen.saveSelectedGame;
CareerScreen.saveSelectedGame = function(self)
	CareerScreenSaveSelectedGame(self); 
	ModEvent:saveCustomInfoTriggerToXML();
end;

function ModEvent:loadCustomInfoTriggerFromXML()

	if fileExists(self.saveXMLFile) then
		local xmlFile = loadXMLFile("CustomInfoTrigger", self.saveXMLFile);
			for i=1, table.getn(ModEvent.triggers) do
				local key = ("CustomInfoTrigger."..ModEvent.triggers[i].textInfo.."");
				ModEvent.triggers[i].isEnabled = Utils.getNoNil(getXMLBool(xmlFile, key.."#visibility"),true);
				setVisibility(ModEvent.triggers[i].triggerId, ModEvent.triggers[i].isEnabled);
				ModEvent.triggers[i].activeNow = true; --S7B
			end;
	end;

end;

function ModEvent:saveCustomInfoTriggerToXML()

	local existDir = io.open (self.saveXMLFile, "w");	
	if existDir == nil then
		createXMLFile("CustomInfoTrigger", self.saveXMLFile, "saveObject");
	end;
	
    local xmlFile = io.open (self.saveXMLFile, "w");
    if xmlFile ~= nil then
        xmlFile:write('<?xml version="1.0" encoding="utf-8" standalone="no" ?>\n');
		xmlFile:write('\n');
        xmlFile:write('<CustomInfoTrigger>\n');
		for i=1, table.getn(ModEvent.triggers) do
			xmlFile:write('    <'..ModEvent.triggers[i].textInfo..'  visibility="'..tostring(ModEvent.triggers[i].isEnabled)..'"/> \n');
		end;		
        xmlFile:write("</CustomInfoTrigger>");
        xmlFile:close();
    end;	

end;

addModEventListener(ModEvent);

customInfoTrigger ={};

local customInfoTrigger_mt = Class(customInfoTrigger, Object);
function customInfoTrigger.onCreate(id)
    local instance = customInfoTrigger:new(g_server ~= nil, g_client ~= nil);
    local index = g_currentMission:addOnCreateLoadedObject(instance);
    instance:load(id);
    instance:register(true);
	table.insert(ModEvent.triggers, instance);
end;

function customInfoTrigger:new(isServer, isClient)
    local self = Object:new(isServer, isClient, customInfoTrigger_mt);
    self.className = "customInfoTrigger";
    return self;
end;

function customInfoTrigger:load(id)

	self.triggerId = id;
	addTrigger(id, "triggerCallback", self);
	
	self.infoSymbol = getChildAt(id, 0);		
	local x, y, z = getTranslation(self.infoSymbol);
	self.posY = y;
	self.jump = 0.05;
	
	self.isEnabled = true;
 	self.textInfo = getUserAttribute(id, "InfoField");
	self.titleInfo = getUserAttribute(id, "Title");
	self.victorySymbol = Utils.getNoNil(getUserAttribute(id, "Victory"), false);	--boolean
	--S7B
	self.resurrect = Utils.getNoNil(getUserAttribute(id, "Resurrect"),false);
	self.activeNow = true;
	local timestring = getUserAttribute(id,"activeTime");
	if timestring ~= nil then
		self.times = Utils.splitString("-",timestring);
		self.times[1] = self.times[1]*3600000;
		self.times[2] = self.times[2]*3600000;
	end;
	--S7B^

end;

function customInfoTrigger:delete()
	removeTrigger(self.triggerId);
end;

function customInfoTrigger:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay)
	if self.activeNow then --S7B
		if onEnter and self.isEnabled then 
			if (g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode) or (g_currentMission.controlledVehicle ~= nil and otherId == g_currentMission.controlledVehicle.components[1].node) then
				g_currentMission.inGameMessage:showMessage((self.titleInfo), g_i18n:getText(self.textInfo), 0, self.victorySymbol);
				setVisibility(self.triggerId, false);
				self.isEnabled = false;
			end;
		end;
		--S7B
		if onLeave and not self.isEnabled and self.resurrect then
			setVisibility(self.triggerId, true);
			self.isEnabled = true;
		end;
		--S7B^
	end; --S7B
end;

function customInfoTrigger:update(dt)

--S7B	
	if self.times ~= nil then
		local inTime =	( (self.times[1] > self.times[2]) and (g_currentMission.environment.dayTime > self.times[1] or g_currentMission.environment.dayTime < self.times[2]) ) or
								( (self.times[1] < self.times[2]) and (g_currentMission.environment.dayTime > self.times[1] and g_currentMission.environment.dayTime < self.times[2]) ) ;
		if inTime ~= self.activeNow then
			self.activeNow = inTime;
			setVisibility(self.triggerId, inTime);
		end;
	end;
--S7B^

	if self.isEnabled and self.activeNow then --S7B
		rotate(self.infoSymbol, 0, 0.005 * dt, 0);		
		self.jump = self.jump - 0.00015 * dt;
		local x, y, z = getTranslation(self.infoSymbol);
		setTranslation(self.infoSymbol, x, y + self.jump, z);
		
		if y + self.jump <= self.posY then
			self.jump = 0.05;
		end;
	end;

end;


g_onCreateUtil.addOnCreateFunction("customInfoTriggerOnCreate", customInfoTrigger.onCreate);
