-- Sektionaltorscript by Blacky_BPG
-- 
-- 
-- 
-- 19.04.2013		V 1.1	Scriptumstellung wegen Skalierbarkeit
-- 17.04.2013		V 1.0

Sektionaltor = {};
  
local Sektionaltor_mt = Class(Sektionaltor);
  
function Sektionaltor.onCreate(id)
	g_currentMission:addUpdateable(Sektionaltor:new(id));
end;
  
function Sektionaltor:new(id, customMt)
	local instance = {};
	if customMt ~= nil then
		setmetatable(instance, customMt);
	else
		setmetatable(instance, Sektionaltor_mt);
	end;

	instance.triggerId = id;
	addTrigger(id, "triggerCallback", instance);

	local audio = getUserAttribute(id, "audioIndex");
	if audio ~= nil then
		instance.audio = Utils.indexToObject(id, audio);
	else
		print("Error: Sektionaltor.lua(27) Audio index not correct or missing, deactivate trigger");
		self:delete();
	end;
	local colliId = getUserAttribute(id, "collisionBoxIndex");
	if colliId ~= nil then
		instance.colliIndex = Utils.indexToObject(id, colliId);
		instance.colliMask = getCollisionMask(instance.colliIndex);
	else
		print("Error: Sektionaltor.lua(34) collisionbox index not correct or missing, deactivate trigger");
		self:delete();
	end;
	instance.closeTime = Utils.getNoNil(getUserAttribute(id, "autoCloseTime"),0);
	if instance.closeTime > 0 then
		instance.closeTime = instance.closeTime * 1000;
	end;
	local lightGreen = getUserAttribute(id, "greenLightIndex");
	local lightRed = getUserAttribute(id, "redLightIndex");
	instance.statusLights = false;
	if lightGreen ~= nil and lightRed ~= nil then
		instance.statusLights = true;
		instance.lightGreen = Utils.indexToObject(id, lightGreen);
		instance.lightRed = Utils.indexToObject(id, lightRed);
	end;
	instance.speedScale = Utils.getNoNil(getUserAttribute(id, "speedScale"),10);
	instance.speedScale = instance.speedScale / 20;
	local li = getUserAttribute(id, "lightIndex");
	instance.lightIndex = nil;
	if li ~= nil then
		instance.lightIndex = Utils.indexToObject(id, li);
		instance.lightAllways = Utils.getNoNil(getUserAttribute(id, "lightsAllways"),false);
		instance.lightNightlight = Utils.getNoNil(getUserAttribute(id, "lightsNightlight"),true);
		instance.lightOn = Utils.getNoNil(getUserAttribute(id, "lightsOn"),1230) * 60000;
		instance.lightOff = Utils.getNoNil(getUserAttribute(id, "lightsOff"),390) * 60000;
	end;
	
	local rootNode = getChild(id, "Sektion_1")
	instance.animCharSet = 0;
	if rootNode ~= nil then
		instance.animCharSet = getAnimCharacterSet(rootNode);
		if instance.animCharSet ~= 0 then
			local clipSource = getUserAttribute(id, "animationClip");
			if clipSource ~= nil then
				instance.clip = getAnimClipIndex(instance.animCharSet, clipSource);
				if instance.clip ~= nil then
					if instance.clip >= 0 then
						assignAnimTrackClip(instance.animCharSet, 0, instance.clip);
						setAnimTrackLoopState(instance.animCharSet, 0, false);
						setAnimTrackSpeedScale(instance.animCharSet, 0, instance.speedScale);
						instance.animDuration = getAnimClipDuration(instance.animCharSet, instance.clip);
					else
						print("Error: Sektionaltor.lua(75) clip for child Sektion_1 are not usable, deactivate trigger");
						self:delete();
					end;
				else
					print("Error: Sektionaltor.lua(73) no clip named "..tostring(clipSource).." can be found in animation for child Sektion_1, deactivate trigger");
					self:delete();
				end;
			else
				print("Error: Sektionaltor.lua(71) no clip name assigned for child Sektion_1, deactivate trigger");
				self:delete();
			end;
		else
			print("Error: Sektionaltor.lua(69) no animation assigned for child Sektion_1, deactivate trigger");
			self:delete();
		end;
	else
		print("Error: Sektionaltor.lua(66) no child Sektion_1 are found in assigned gate, deactivate trigger");
		self:delete();
	end;

	instance.isEnabled = true;
	instance.trackTime = 0;
	instance.lastTrackTime = 0;
	instance.flickrCounter = 0;
	instance.autoCloseTimer = 0;

	setVisibility(self.audio, false);
	if self.lightIndex ~= nil then
		setVisibility(self.lightIndex, false);
	end;
	
	instance.count = 0;
	instance.countBackup = 0;

	return instance;
end;
  
function Sektionaltor:delete()
	removeTrigger(self.triggerId);
end;
  
function Sektionaltor:update(dt)
	local dTime = Utils.getNoNil(g_currentMission.environment.dayTime,720);
	if self.lightIndex ~= nil then
		if self.lightAllways == true then
			if self.lightNightlight == true then
				if dTime >= self.lightOn or dTime < self.lightOff then
					setVisibility(self.lightIndex, true);
				end;
			else
				setVisibility(self.lightIndex, true);
			end;
		end;
	end;
	if self.trackTime < 1 then 
		self.trackTime = 0;
	end;

	if self.trackTime > self.animDuration then
		self.trackTime = self.animDuration;
	end;

	if self.count > 0 then
		if self.lightIndex ~= nil then
			if self.lightAllways ~= true then
				if (self.lightNightlight == true and (dTime >= self.lightOn or dTime < self.lightOff)) or self.lightNightlight ~= true then
					if self.flickrCounter == 0 or self.flickrCounter == 4 or self.flickrCounter == 8 or self.flickrCounter >= 13 then
						setVisibility(self.lightIndex, true);
					elseif self.flickrCounter == 2 or self.flickrCounter == 5 or self.flickrCounter == 11 then
						setVisibility(self.lightIndex, false);
					end;
					if self.flickrCounter < 14 then
						self.flickrCounter = self.flickrCounter + 1;
					end;
				end;
			end;
		end;
		if self.autoCloseTimer <= dTime and self.closeTime > 0 then
			self.countBackup = self.count;
			self.count = 0;
		end;
		if self.trackTime < self.animDuration then
			self.trackTime = self.trackTime + 10 * self.speedScale;
		end;
		if self.trackTime >= (self.animDuration / 2) then
			setCollisionMask(self.colliIndex,0);
			if self.statusLights == true then
				setVisibility(self.lightGreen, true);
				setVisibility(self.lightRed, false);
			end;
		end;
	else
		self.autoCloseTimer = 0;
		if self.trackTime > 0 then
			self.trackTime = self.trackTime - 10 * self.speedScale;
			if self.trackTime <= (self.animDuration / 2) then
				setCollisionMask(self.colliIndex,self.colliMask);
				if self.statusLights == true then
					setVisibility(self.lightGreen, false);
					setVisibility(self.lightRed, true);
				end;
			end;
		else
			if self.lightIndex ~= nil then
				if self.lightAllways ~= true then
					setVisibility(self.lightIndex, false);
				end;
				self.flickrCounter = 0;
			end;
		end;
	end;

	if self.lastTrackTime ~= self.trackTime then
		setVisibility(self.audio, true);
		enableAnimTrack(self.animCharSet, self.clip);
		setAnimTrackTime(self.animCharSet, self.clip, self.trackTime, true);
		disableAnimTrack(self.animCharSet, self.clip);
		self.lastTrackTime = self.trackTime;
	else
		setVisibility(self.audio, false);
	end;
end;
  
function Sektionaltor:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay)
	if onEnter and self.isEnabled then
		self.count = self.count + 1;
		if self.closeTime > 0 then
			self.autoCloseTimer = (g_currentMission.environment.dayTime + ((10 * self.speedScale * 1000) + self.closeTime) * g_currentMission.missionStats.timeScale);
		end;
		local vehicle = g_currentMission.nodeToVehicle[otherId];
		if vehicle ~= nil then
			if SpecializationUtil.hasSpecialization(TrafficVehicle, vehicle.specializations) then
				self.count = self.count - 1;
				self.autoCloseTimer = 0;
			else
				self.count = self.count + self.countBackup;
				self.countBackup = 0;
			end;
		else
			self.count = self.count + self.countBackup;
			self.countBackup = 0;
		end;
	elseif onLeave then
		self.count = self.count - 1;
		if self.count < 0 then
			self.count = 0;
			if self.countBackup > 0 then
				self.countBackup = self.countBackup - 1;
			end;
		end;
	end;
end;
    
g_onCreateUtil.addOnCreateFunction("SektionaltorOnCreate", Sektionaltor.onCreate);
