-- author: rafftnix
-- date: 13.12.2013

-- skript for map repair triggers

-- nderungen am Skript nur mit meiner Zustimmung!
-- Modification only with my permission!

MapRepairTrigger = {}

local MapRepairTrigger_mt = Class(MapRepairTrigger);

function MapRepairTrigger.onCreate(nodeId)
	if g_server ~= nil then
		local trigger = MapRepairTrigger:new();
		trigger:load(nodeId);
		g_currentMission:addNonUpdateable(trigger);
	end;
end;

function MapRepairTrigger:new(mt)
	if mt == nil then
		mt = MapRepairTrigger_mt;
	end;
	
	local self = {}
	
	setmetatable(self, mt);
		
	return self;
end;

function MapRepairTrigger:load(id)
	addTrigger(id, "mapRepairTriggerCallback", self);
	self.triggerId = id;
end;

function MapRepairTrigger:delete()
	removeTrigger(self.triggerId);
end;

function MapRepairTrigger:mapRepairTriggerCallback(triggerId, otherId, onEnter, onLeave, onStay)
	local vehicle = g_currentMission.nodeToVehicle[otherId];
	if vehicle ~= nil and vehicle.damageLevel ~= nil and not vehicle.dontAllowDamage then
		if onEnter then
			vehicle.isInRepairTrigger = true;
		elseif onLeave then
			vehicle.isInRepairTrigger = false;
		end;
	end;
end;

g_onCreateUtil.addOnCreateFunction("mapRepairTriggerOnCreate", MapRepairTrigger.onCreate);