--
-- Landwehrkanal
--
-- @author  Stefan Geiger
-- @date  06/08/12
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

Landwehrkanal = {}

local Landwehrkanal_mt = Class(Landwehrkanal, Mission00);


function Landwehrkanal:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = Landwehrkanal_mt;
    end;
    local self = Landwehrkanal:superClass():new(baseDirectory, mt);

--    self.playerStartX = 39;
--    self.playerStartY = 0.1;
--    self.playerStartZ = -330;
--    self.playerRotX = 0;
--    self.playerRotY = Utils.degToRad(90);

    return self;
end;

function Landwehrkanal:delete()
    Landwehrkanal:superClass().delete(self);
end;

function Landwehrkanal:load()
    self:startLoadingTask();

    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);

    self.helpIconsBase = nil;
    self.collectableHorseshoesObject = nil;
    self.fieldDefinitionBase = nil;
    self.vehicleShopBase = nil;

    self:loadMap(Utils.getFilename("map/Landwehrkanal.i3d", self.baseDirectory), true, self.loadMap01Finished, self);
end;

function Landwehrkanal:loadMap01Finished(node, arguments)

    self:loadMapXMLFile(Utils.getFilename("Landwehrkanal.xml", self.baseDirectory));

    self.missionPDA:loadMap(Utils.getFilename("pda_map.png", self.baseDirectory), 2048, 2048);
	
	self.terrainDetailAngleNumChannels = 3;
	
    self.terrainDetailAngleMaxValue = bitShiftLeft(1, self.terrainDetailAngleNumChannels) - 1;

    g_inGameMenu:setMapViewsMap(Utils.getFilename("pda_map.png", self.baseDirectory));

    local iconSize = self.missionPDA.pdaMapWidth / 15;

    -- ATMs
    self.missionPDA:createMapHotspot("Bank", Utils.getFilename("$dataS2/missions/hud_pda_spot_bank.png", self.baseDirectory), 0 - 13, 0 + 97, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Bank", Utils.getFilename("$dataS2/missions/hud_pda_spot_bank.png", self.baseDirectory), 0 - 537, 0 - 119, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
   

    -- Vehicle Shop
    self.missionPDA:createMapHotspot("Shop", Utils.getFilename("$dataS2/missions/hud_pda_spot_shop.png", self.baseDirectory), 0 - 557, 0 - 98, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- Phone Booths
   -- self.missionPDA:createMapHotspot("Phone", Utils.getFilename("$dataS2/missions/hud_pda_spot_phone.png", self.baseDirectory), 0 + 89.6, 0 - 417.9, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
   -- self.missionPDA:createMapHotspot("Phone", Utils.getFilename("$dataS2/missions/hud_pda_spot_phone.png", self.baseDirectory), 0 - 603.4, 0 - 834, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- farm silos
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), 0 - 295, 0 - 448, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), 0 - 580.4, 0 + 666.7, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), 0 - 126.4, 0 - 124, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	
    -- bga
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), 0 - 704, 0 + 52.5, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    
    -- Grass Heaps
    -- self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), 0 + 888.8 , 0 + 569.6, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    -- self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), 0 + 753.5 , 0 + 864.9, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- livestock
    self.missionPDA:createMapHotspot("Cows", Utils.getFilename("$dataS2/missions/hud_pda_spot_cows.png", self.baseDirectory), 0 - 262, 0 - 487, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Sheep", Utils.getFilename("$dataS2/missions/hud_pda_spot_sheep.png", self.baseDirectory), 0 - 481, 0 + 688, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Chickens", Utils.getFilename("$dataS2/missions/hud_pda_spot_chickens.png", self.baseDirectory), 0 - 319, 0 - 447, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    Landwehrkanal:superClass().load(self);

    if not self.missionDynamicInfo.isMultiplayer then
        self:updateFoundHorseshoes();
        self:updateFoundHelpIcons();
        self:updateMeteoriteCrash();
        self:updateRainbow();
    else
        self:removeAllHorseshoes();
        self:removeAllHelpIcons();
    end;

    if g_isGamescomVersion then
        self:playerOwnsAllFields();
    end;

    self:finishLoadingTask();
end;

function Landwehrkanal:onStartMission()
    Landwehrkanal:superClass().onStartMission(self);
end;

function Landwehrkanal:mouseEvent(posX, posY, isDown, isUp, button)
    Landwehrkanal:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function Landwehrkanal:keyEvent(unicode, sym, modifier, isDown)
    Landwehrkanal:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function Landwehrkanal:update(dt)
    Landwehrkanal:superClass().update(self, dt);
end;

function Landwehrkanal:draw()
    Landwehrkanal:superClass().draw(self);
end;